/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.rekindled.embers.ConfigManager;
import com.rekindled.embers.EmbersClientEvents;
import java.util.OptionalDouble;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class EmbersRenderTypes
extends RenderType {
    public static ShaderInstance additiveShader;
    public static final RenderStateShard.ShaderStateShard ADDITIVE_SHADER;
    public static ShaderInstance emberParticleShader;
    public static final RenderStateShard.ShaderStateShard EMBER_PARTICLE_SHADER;
    public static ShaderInstance emberParticleFabShader;
    public static final RenderStateShard.ShaderStateShard EMBER_PARTICLE_FAB_SHADER;
    public static ShaderInstance translucentParticleShader;
    public static final RenderStateShard.ShaderStateShard TRANSLUCENT_PARTICLE_SHADER;
    public static ShaderInstance mithrilShader;
    public static final RenderStateShard.ShaderStateShard MITHRIL_SHADER;
    public static ParticleRenderType PARTICLE_SHEET_ADDITIVE;
    public static ParticleRenderType PARTICLE_SHEET_EMBER_ROUGH;
    public static ParticleRenderType PARTICLE_SHEET_EMBER;
    public static ParticleRenderType PARTICLE_SHEET_EMBER_HARD;
    public static ParticleRenderType PARTICLE_SHEET_ADDITIVE_XRAY;
    public static ParticleRenderType PARTICLE_SHEET_TRANSLUCENT_NODEPTH;
    public static final RenderType FLUID;
    public static final RenderStateShard.ShaderStateShard PTLC_SHADER;
    public static final RenderStateShard.ShaderStateShard PTCN_SHADER;
    public static final RenderStateShard.ShaderStateShard PTC_SHADER;
    public static final RenderType CRYSTAL;
    public static final RenderType CRYSTAL_FALLBACK;
    public static final RenderType FIELD_CHART;
    public static final RenderType FIELD_CHART_FALLBACK;
    public static Function<ResourceLocation, RenderType> CRYSTAL_SEED;
    public static final RenderType BEAM;
    public static final RenderType GLOW_LINES;
    public static final RenderType GLOW_GUI;
    public static final RenderType HEAT_BAR_ENDS;
    public static Function<RenderStateShard.EmptyTextureStateShard, RenderType> GLOW_TEXT;
    public static final RenderType NOTE_BACKGROUND;
    public static final RenderType NOTE_PEDESTAL;
    public static ResourceLocation MITHRIL_REFLECTION;
    public static RenderType MITHRIL;

    public EmbersRenderTypes(String pName, VertexFormat pFormat, VertexFormat.Mode pMode, int pBufferSize, boolean pAffectsCrumbling, boolean pSortOnUpload, Runnable pSetupState, Runnable pClearState) {
        super(pName, pFormat, pMode, pBufferSize, pAffectsCrumbling, pSortOnUpload, pSetupState, pClearState);
    }

    public static void applyParticleUniforms(ShaderInstance shader, float offset, float fade, float alphaCutoff) {
        RenderSystem.getShader().m_173350_("DepthBuffer", (Object)EmbersClientEvents.depthBuffer.m_83980_());
        RenderSystem.getShader().m_173356_("ProjMatInv").m_5679_(new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix()).invert());
        RenderSystem.getShader().m_173356_("Offset").m_5985_(offset);
        RenderSystem.getShader().m_173356_("Fade").m_5985_(fade);
        RenderSystem.getShader().m_173356_("AlphaCutoff").m_5985_(alphaCutoff);
    }

    private static RenderType getSeed(ResourceLocation texture) {
        return EmbersRenderTypes.m_173215_((String)"embers:crystal_seed_render_type", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173112_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110677_(f_110154_).m_110671_(f_110152_).m_110691_(true));
    }

    private static RenderType getText(RenderStateShard.EmptyTextureStateShard state) {
        RenderType.CompositeState rendertype$state = RenderType.CompositeState.m_110628_().m_173292_(f_173086_).m_173290_(state).m_110685_(f_110136_).m_110671_(f_110152_).m_110691_(false);
        return EmbersRenderTypes.m_173215_((String)"embers:glow_text", (VertexFormat)DefaultVertexFormat.f_85820_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)rendertype$state);
    }

    public static RenderType getNote(ResourceLocation location) {
        RenderType.CompositeState rendertype$state = RenderType.CompositeState.m_110628_().m_173292_(f_173065_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(location, false, false)).m_110685_(f_110139_).m_110671_(f_110152_).m_110661_(f_110110_).m_110677_(f_110154_).m_110691_(false);
        return EmbersRenderTypes.m_173215_((String)"alchemical_note", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)rendertype$state);
    }

    static {
        ADDITIVE_SHADER = new RenderStateShard.ShaderStateShard(() -> additiveShader);
        EMBER_PARTICLE_SHADER = new RenderStateShard.ShaderStateShard(() -> emberParticleShader);
        EMBER_PARTICLE_FAB_SHADER = new RenderStateShard.ShaderStateShard(() -> emberParticleFabShader);
        TRANSLUCENT_PARTICLE_SHADER = new RenderStateShard.ShaderStateShard(() -> translucentParticleShader);
        MITHRIL_SHADER = new RenderStateShard.ShaderStateShard(() -> mithrilShader);
        PARTICLE_SHEET_ADDITIVE = new ParticleRenderType(){

            public void m_6505_(BufferBuilder p_107455_, TextureManager p_107456_) {
                int fancyness;
                RenderSystem.enableDepthTest();
                Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
                RenderSystem.depthMask((boolean)false);
                if (!((Boolean)ConfigManager.RENDER_FALLBACK.get()).booleanValue() && (fancyness = ((GraphicsStatus)Minecraft.m_91087_().f_91066_.m_232060_().m_231551_()).m_35965_()) >= GraphicsStatus.FANCY.m_35965_()) {
                    EMBER_PARTICLE_SHADER.m_110185_();
                    EmbersRenderTypes.applyParticleUniforms(emberParticleShader, 0.0f, 0.1875f, 0.0f);
                }
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118260_);
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                p_107455_.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
            }

            public void m_6294_(Tesselator p_107458_) {
                p_107458_.m_85914_();
            }

            public String toString() {
                return "PARTICLE_SHEET_ADDITIVE";
            }
        };
        PARTICLE_SHEET_EMBER_ROUGH = new ParticleRenderType(){

            public void m_6505_(BufferBuilder p_107455_, TextureManager p_107456_) {
                int fancyness;
                RenderSystem.enableDepthTest();
                Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
                RenderSystem.depthMask((boolean)false);
                if (!((Boolean)ConfigManager.RENDER_FALLBACK.get()).booleanValue() && (fancyness = ((GraphicsStatus)Minecraft.m_91087_().f_91066_.m_232060_().m_231551_()).m_35965_()) >= GraphicsStatus.FANCY.m_35965_()) {
                    if (fancyness >= GraphicsStatus.FABULOUS.m_35965_()) {
                        EMBER_PARTICLE_FAB_SHADER.m_110185_();
                    } else {
                        EMBER_PARTICLE_SHADER.m_110185_();
                    }
                    EmbersRenderTypes.applyParticleUniforms(RenderSystem.getShader(), 0.0625f, 0.125f, 0.1f);
                    RenderSystem.disableDepthTest();
                }
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118260_);
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                p_107455_.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
            }

            public void m_6294_(Tesselator p_107458_) {
                p_107458_.m_85914_();
                RenderSystem.enableDepthTest();
            }

            public String toString() {
                return "PARTICLE_SHEET_EMBER_ROUGH";
            }
        };
        PARTICLE_SHEET_EMBER = new ParticleRenderType(){

            public void m_6505_(BufferBuilder p_107455_, TextureManager p_107456_) {
                int fancyness;
                RenderSystem.enableDepthTest();
                Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
                RenderSystem.depthMask((boolean)false);
                if (!((Boolean)ConfigManager.RENDER_FALLBACK.get()).booleanValue() && (fancyness = ((GraphicsStatus)Minecraft.m_91087_().f_91066_.m_232060_().m_231551_()).m_35965_()) >= GraphicsStatus.FANCY.m_35965_()) {
                    if (fancyness >= GraphicsStatus.FABULOUS.m_35965_()) {
                        EMBER_PARTICLE_FAB_SHADER.m_110185_();
                    } else {
                        EMBER_PARTICLE_SHADER.m_110185_();
                    }
                    EmbersRenderTypes.applyParticleUniforms(RenderSystem.getShader(), 0.1875f, 0.3125f, 0.0f);
                    RenderSystem.disableDepthTest();
                }
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118260_);
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                p_107455_.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
            }

            public void m_6294_(Tesselator p_107458_) {
                p_107458_.m_85914_();
                RenderSystem.enableDepthTest();
            }

            public String toString() {
                return "PARTICLE_SHEET_EMBER";
            }
        };
        PARTICLE_SHEET_EMBER_HARD = new ParticleRenderType(){

            public void m_6505_(BufferBuilder p_107455_, TextureManager p_107456_) {
                int fancyness;
                RenderSystem.enableDepthTest();
                Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
                RenderSystem.depthMask((boolean)false);
                if (!((Boolean)ConfigManager.RENDER_FALLBACK.get()).booleanValue() && (fancyness = ((GraphicsStatus)Minecraft.m_91087_().f_91066_.m_232060_().m_231551_()).m_35965_()) >= GraphicsStatus.FABULOUS.m_35965_()) {
                    EMBER_PARTICLE_FAB_SHADER.m_110185_();
                    EmbersRenderTypes.applyParticleUniforms(emberParticleFabShader, 0.0f, 0.0f, 0.0f);
                }
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118260_);
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                p_107455_.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
            }

            public void m_6294_(Tesselator p_107458_) {
                p_107458_.m_85914_();
            }

            public String toString() {
                return "PARTICLE_SHEET_EMBER_HARD";
            }
        };
        PARTICLE_SHEET_ADDITIVE_XRAY = new ParticleRenderType(){

            public void m_6505_(BufferBuilder p_107455_, TextureManager p_107456_) {
                int fancyness;
                RenderSystem.enableDepthTest();
                Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
                RenderSystem.depthMask((boolean)false);
                if (!((Boolean)ConfigManager.RENDER_FALLBACK.get()).booleanValue() && (fancyness = ((GraphicsStatus)Minecraft.m_91087_().f_91066_.m_232060_().m_231551_()).m_35965_()) >= GraphicsStatus.FANCY.m_35965_()) {
                    if (fancyness >= GraphicsStatus.FABULOUS.m_35965_()) {
                        EMBER_PARTICLE_FAB_SHADER.m_110185_();
                    } else {
                        EMBER_PARTICLE_SHADER.m_110185_();
                    }
                    EmbersRenderTypes.applyParticleUniforms(RenderSystem.getShader(), 50.0f, 40.0f, 0.0f);
                }
                RenderSystem.disableDepthTest();
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118260_);
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                p_107455_.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
            }

            public void m_6294_(Tesselator p_107458_) {
                p_107458_.m_85914_();
                RenderSystem.enableDepthTest();
            }

            public String toString() {
                return "PARTICLE_SHEET_ADDITIVE_XRAY";
            }
        };
        PARTICLE_SHEET_TRANSLUCENT_NODEPTH = new ParticleRenderType(){

            public void m_6505_(BufferBuilder p_107455_, TextureManager p_107456_) {
                int fancyness;
                RenderSystem.enableDepthTest();
                Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
                RenderSystem.depthMask((boolean)false);
                if (!((Boolean)ConfigManager.RENDER_FALLBACK.get()).booleanValue() && (fancyness = ((GraphicsStatus)Minecraft.m_91087_().f_91066_.m_232060_().m_231551_()).m_35965_()) >= GraphicsStatus.FANCY.m_35965_()) {
                    TRANSLUCENT_PARTICLE_SHADER.m_110185_();
                    EmbersRenderTypes.applyParticleUniforms(translucentParticleShader, 0.0f, 0.1875f, 0.0f);
                }
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118260_);
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                p_107455_.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
            }

            public void m_6294_(Tesselator p_107458_) {
                p_107458_.m_85914_();
            }

            public String toString() {
                return "PARTICLE_SHEET_TRANSLUCENT_NODEPTH";
            }
        };
        FLUID = EmbersRenderTypes.m_173215_((String)"embers:fluid_render_type", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110671_(f_110152_).m_173292_(f_173065_).m_173290_((RenderStateShard.EmptyTextureStateShard)f_110145_).m_110685_(f_110139_).m_110661_(f_110158_).m_110677_(f_110154_).m_110691_(true));
        PTLC_SHADER = new RenderStateShard.ShaderStateShard(GameRenderer::m_172637_);
        PTCN_SHADER = new RenderStateShard.ShaderStateShard(GameRenderer::m_172838_);
        PTC_SHADER = new RenderStateShard.ShaderStateShard(GameRenderer::m_172820_);
        CRYSTAL = EmbersRenderTypes.m_173215_((String)"embers:crystal_render_type", (VertexFormat)DefaultVertexFormat.f_85819_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(ADDITIVE_SHADER).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("embers:textures/block/crystal_material.png"), false, false)).m_110685_(f_110136_).m_110661_(f_110110_).m_110671_(f_110153_).m_110677_(f_110155_).m_110691_(false));
        CRYSTAL_FALLBACK = EmbersRenderTypes.m_173215_((String)"embers:crystal_render_type", (VertexFormat)DefaultVertexFormat.f_85819_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(PTC_SHADER).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("embers:textures/block/crystal_material.png"), false, false)).m_110685_(f_110136_).m_110661_(f_110110_).m_110671_(f_110153_).m_110677_(f_110155_).m_110691_(false));
        FIELD_CHART = EmbersRenderTypes.m_173215_((String)"embers:field_chart_render_type", (VertexFormat)DefaultVertexFormat.f_85819_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(ADDITIVE_SHADER).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("embers:textures/block/field_square.png"), false, false)).m_110685_(f_110136_).m_110661_(f_110110_).m_110691_(false));
        FIELD_CHART_FALLBACK = EmbersRenderTypes.m_173215_((String)"embers:field_chart_render_type", (VertexFormat)DefaultVertexFormat.f_85819_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(PTC_SHADER).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("embers:textures/block/field_square.png"), false, false)).m_110685_(f_110136_).m_110661_(f_110110_).m_110691_(false));
        CRYSTAL_SEED = Util.m_143827_(EmbersRenderTypes::getSeed);
        BEAM = EmbersRenderTypes.m_173215_((String)"embers:beam_render_type", (VertexFormat)DefaultVertexFormat.f_85821_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(PTLC_SHADER).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("embers:textures/entity/alchemy_circle.png"), false, false)).m_110685_(f_110136_).m_110661_(f_110110_).m_110669_(f_110119_).m_110687_(f_110114_).m_110675_(f_110125_).m_110691_(false));
        GLOW_LINES = EmbersRenderTypes.m_173215_((String)"embers:glow_lines", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173095_).m_110671_(f_110153_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.of(6.0))).m_110669_(f_110119_).m_110685_(f_110139_).m_110675_(f_110129_).m_110687_(f_110114_).m_110661_(f_110110_).m_110691_(false));
        GLOW_GUI = EmbersRenderTypes.m_173215_((String)"embers:glow_gui", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_285573_).m_110685_(f_110136_).m_110663_(f_110113_).m_110691_(false));
        HEAT_BAR_ENDS = EmbersRenderTypes.m_173215_((String)"embers:heat_bar_ends", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173102_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("embers", "textures/gui/heat_bar.png"), false, false)).m_110685_(f_110134_).m_110663_(f_110113_).m_110691_(false));
        GLOW_TEXT = Util.m_143827_(EmbersRenderTypes::getText);
        NOTE_BACKGROUND = EmbersRenderTypes.getNote(new ResourceLocation("embers", "textures/gui/alchemical_note.png"));
        NOTE_PEDESTAL = EmbersRenderTypes.getNote(new ResourceLocation("embers", "textures/gui/alchemical_note_pedestal.png"));
        MITHRIL_REFLECTION = new ResourceLocation("embers:textures/misc/mithril_reflection.png");
        MITHRIL = EmbersRenderTypes.m_173215_((String)"embers:mithril_render_type", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(MITHRIL_SHADER).m_173290_(new RenderStateShard.EmptyTextureStateShard(() -> {
            TextureManager texturemanager = Minecraft.m_91087_().m_91097_();
            texturemanager.m_118506_(InventoryMenu.f_39692_).m_117960_(false, false);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
            texturemanager.m_118506_(MITHRIL_REFLECTION).m_117960_(true, false);
            RenderSystem.setShaderTexture((int)3, (ResourceLocation)MITHRIL_REFLECTION);
            mithrilShader.m_173356_("PlayerPos").m_142276_(Minecraft.m_91087_().f_91063_.m_109153_().m_90583_().m_252839_());
        }, () -> {})).m_110677_(f_110154_).m_110671_(f_110152_).m_110691_(true));
    }
}

