/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.research.subtypes;

import com.rekindled.embers.gui.GuiCodex;
import com.rekindled.embers.research.ResearchBase;
import com.rekindled.embers.util.Vec2i;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;

public class ResearchShowItem
extends ResearchBase {
    LinkedList<DisplayItem> displayItems = new LinkedList();

    public ResearchShowItem(ResourceLocation location, ItemStack icon, double x, double y) {
        super(location, icon, x, y);
    }

    public ResearchShowItem(ResourceLocation location, ItemStack icon, Vec2i pos) {
        this(location, icon, (double)pos.x, (double)pos.y);
    }

    @Deprecated
    public ResearchShowItem(String location, ItemStack icon, double x, double y) {
        super(location, icon, x, y);
    }

    @Deprecated
    public ResearchShowItem(String location, ItemStack icon, Vec2i pos) {
        this(location, icon, (double)pos.x, (double)pos.y);
    }

    public ResearchShowItem addItem(DisplayItem item) {
        this.displayItems.add(item);
        return this;
    }

    @Override
    public List<FormattedCharSequence> getLines(Font renderer, FormattedText s, int width) {
        ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
        int offset = this.displayItems.size() * 24;
        for (int i = 0; i < offset; i += 9 + 3) {
            lines.add(0, FormattedCharSequence.f_13691_);
            Objects.requireNonNull(renderer);
        }
        lines.addAll(super.getLines(renderer, s, width));
        return lines;
    }

    @Override
    public void renderPageContent(GuiGraphics graphics, GuiCodex gui, int basePosX, int basePosY, Font fontRenderer) {
        int slotX;
        int slotY;
        int batchOff;
        ItemStack[] stacks;
        int textOffX = 3;
        int textOffY = 2;
        int y = 0;
        for (DisplayItem displayItem : this.displayItems) {
            stacks = displayItem.getStacks();
            batchOff = displayItem.sideText == null ? (168 - stacks.length * 24) / 2 : 0;
            slotY = basePosY - textOffY + 43 + y * 24;
            for (int x = 0; x < stacks.length; ++x) {
                slotX = basePosX - textOffX + batchOff + 20;
                graphics.m_280218_(this.getBackground(), slotX + x * 24, slotY, GuiCodex.pageWidth, 0, 24, 24);
            }
            ++y;
        }
        super.renderPageContent(graphics, gui, basePosX, basePosY, fontRenderer);
        y = 0;
        for (DisplayItem displayItem : this.displayItems) {
            stacks = displayItem.getStacks();
            batchOff = displayItem.sideText == null ? (168 - stacks.length * 24) / 2 : 0;
            slotY = basePosY - textOffY + 43 + y * 24;
            for (int x = 0; x < stacks.length; ++x) {
                slotX = basePosX - textOffX + batchOff + 20 + x * 24;
                gui.renderItemStackMinusTooltipAt(graphics, stacks[x], slotX + 4, slotY + 4);
            }
            if (displayItem.sideText != null) {
                int n;
                List strings = fontRenderer.m_92923_((FormattedText)displayItem.getSideText(), 152 - stacks.length * 24);
                if (strings.size() <= 1) {
                    Objects.requireNonNull(fontRenderer);
                    n = (9 + 3) / 2;
                } else {
                    n = 0;
                }
                int textOff = n;
                for (int i = 0; i < Math.min(strings.size(), 2); ++i) {
                    FormattedCharSequence formattedCharSequence = (FormattedCharSequence)strings.get(i);
                    int n2 = basePosX + 20 + stacks.length * 24;
                    Objects.requireNonNull(fontRenderer);
                    GuiCodex.drawTextGlowing(fontRenderer, graphics, formattedCharSequence, n2, slotY + textOffY + textOff + i * (9 + 3));
                }
            }
            ++y;
        }
    }

    public static class DisplayItem {
        public ItemStack[] stacks;
        public ResourceLocation sideText;

        public DisplayItem(ItemStack ... stacks) {
            this.stacks = stacks;
        }

        public DisplayItem(ResourceLocation sideText, ItemStack ... stacks) {
            this.stacks = stacks;
            this.sideText = sideText;
        }

        public ItemStack[] getStacks() {
            return this.stacks;
        }

        public Component getSideText() {
            return Component.m_237115_((String)(this.sideText.m_135827_() + ".research.image." + this.sideText.m_135815_()));
        }
    }
}

