/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.upgrade;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.event.DialInformationEvent;
import com.rekindled.embers.api.event.UpgradeEvent;
import com.rekindled.embers.api.upgrades.IUpgradeProvider;
import com.rekindled.embers.api.upgrades.UpgradeContext;
import com.rekindled.embers.blockentity.CatalyticPlugBlockEntity;
import com.rekindled.embers.recipe.FluidHandlerContext;
import com.rekindled.embers.upgrade.DefaultUpgradeProvider;
import com.rekindled.embers.util.DecimalFormats;
import com.rekindled.embers.util.Misc;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class CatalyticPlugUpgrade
extends DefaultUpgradeProvider {
    private static HashSet<Class<? extends BlockEntity>> blacklist = new HashSet();

    public static void registerBlacklistedTile(Class<? extends BlockEntity> tile) {
        blacklist.add(tile);
    }

    public CatalyticPlugUpgrade(BlockEntity tile) {
        super(new ResourceLocation("embers", "catalytic_plug"), tile);
    }

    public static double getMultiplier(double multiplier, int distance, int count) {
        if (distance > 1) {
            multiplier = 1.0 + (multiplier - 1.0) / ((double)distance * 0.5);
        }
        if (count > 2) {
            multiplier = 1.0 + (multiplier - 1.0) / ((double)count * 0.4);
        }
        return multiplier;
    }

    @Override
    public int getLimit(BlockEntity tile) {
        return blacklist.contains(tile.getClass()) ? 0 : super.getLimit(tile);
    }

    @Override
    public double transformEmberConsumption(BlockEntity tile, double ember, int distance, int count) {
        return ember * CatalyticPlugUpgrade.getMultiplier(this.getCatalystMultiplier(), distance, count);
    }

    @Override
    public double getSpeed(BlockEntity tile, double speed, int distance, int count) {
        return speed * CatalyticPlugUpgrade.getMultiplier(this.getCatalystMultiplier(), distance, count);
    }

    @Override
    public double getOtherParameter(BlockEntity tile, String type, double value, int distance, int count) {
        if (type.equals("fuel_consumption")) {
            return value * CatalyticPlugUpgrade.getMultiplier(this.getCatalystMultiplier(), distance, count);
        }
        return value;
    }

    @Override
    public boolean doWork(BlockEntity tile, List<UpgradeContext> upgrades, int distance, int count) {
        if (this.getCatalystMultiplier() != 1.0 && this.tile instanceof CatalyticPlugBlockEntity) {
            this.depleteCatalyst(1);
            ((CatalyticPlugBlockEntity)this.tile).setActive(20);
        }
        return false;
    }

    private double getCatalystMultiplier() {
        BlockEntity blockEntity = this.tile;
        if (blockEntity instanceof CatalyticPlugBlockEntity) {
            CatalyticPlugBlockEntity plug = (CatalyticPlugBlockEntity)blockEntity;
            FluidHandlerContext context = new FluidHandlerContext((IFluidHandler)plug.tank);
            if (plug.burnTime <= 0 || plug.cachedRecipe == null) {
                plug.cachedRecipe = Misc.getRecipe(plug.cachedRecipe, (RecipeType)RegistryManager.GASEOUS_FUEL.get(), context, plug.m_58904_());
            }
            return plug.cachedRecipe == null ? 1.0 : plug.cachedRecipe.getPowerMultiplier(context);
        }
        return 1.0;
    }

    private void depleteCatalyst(int amt) {
        BlockEntity blockEntity = this.tile;
        if (blockEntity instanceof CatalyticPlugBlockEntity) {
            CatalyticPlugBlockEntity plug = (CatalyticPlugBlockEntity)blockEntity;
            plug.burnTime -= amt;
            if (plug.burnTime < 0) {
                FluidHandlerContext context = new FluidHandlerContext((IFluidHandler)plug.tank);
                plug.cachedRecipe = Misc.getRecipe(plug.cachedRecipe, (RecipeType)RegistryManager.GASEOUS_FUEL.get(), context, plug.m_58904_());
                while (plug.burnTime < 0 && plug.cachedRecipe != null && plug.cachedRecipe.m_5818_(context, plug.m_58904_())) {
                    plug.burnTime += plug.cachedRecipe.process(context, 1);
                }
                if (plug.burnTime < 0) {
                    plug.burnTime = 0;
                }
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void throwEvent(BlockEntity tile, List<UpgradeContext> upgrades, UpgradeEvent event, int distance, int count) {
        DialInformationEvent dialEvent;
        if (event instanceof DialInformationEvent && "ember".equals((dialEvent = (DialInformationEvent)event).getDialType())) {
            double multiplier = 1.0;
            boolean first = true;
            for (UpgradeContext upgrade : upgrades) {
                IUpgradeProvider iUpgradeProvider = upgrade.upgrade();
                if (!(iUpgradeProvider instanceof CatalyticPlugUpgrade)) continue;
                CatalyticPlugUpgrade plug = (CatalyticPlugUpgrade)iUpgradeProvider;
                if (first) {
                    if (plug != this) {
                        return;
                    }
                    first = false;
                }
                multiplier = plug.getSpeed(tile, multiplier, upgrade.distance(), upgrade.count());
            }
            DecimalFormat multiplierFormat = DecimalFormats.getDecimalFormat("embers.decimal_format.speed_multiplier");
            dialEvent.getInformation().add((Component)Component.m_237110_((String)"embers.tooltip.upgrade.catalytic_plug", (Object[])new Object[]{multiplierFormat.format(multiplier)}));
        }
    }
}

