/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.upgrade;

import com.rekindled.embers.api.event.AlchemyResultEvent;
import com.rekindled.embers.api.event.AlchemyStartEvent;
import com.rekindled.embers.api.event.UpgradeEvent;
import com.rekindled.embers.api.misc.AlchemyResult;
import com.rekindled.embers.api.upgrades.IUpgradeProvider;
import com.rekindled.embers.api.upgrades.UpgradeContext;
import com.rekindled.embers.api.upgrades.UpgradeUtil;
import com.rekindled.embers.blockentity.EntropicEnumeratorBlockEntity;
import com.rekindled.embers.upgrade.DefaultUpgradeProvider;
import com.rekindled.embers.util.Misc;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;

public class EntropicEnumeratorUpgrade
extends DefaultUpgradeProvider {
    public EntropicEnumeratorUpgrade(BlockEntity tile) {
        super(new ResourceLocation("embers", "entropic_enumerator"), tile);
    }

    @Override
    public int getPriority() {
        return -90;
    }

    @Override
    public void throwEvent(BlockEntity tile, List<UpgradeContext> upgrades, UpgradeEvent event, int distance, int count) {
        EntropicEnumeratorBlockEntity enumerator;
        BlockEntity blockEntity;
        UpgradeEvent alchemyEvent;
        if (event instanceof AlchemyStartEvent && ((AlchemyStartEvent)(alchemyEvent = (AlchemyStartEvent)event)).getRecipe() != null && (blockEntity = this.tile) instanceof EntropicEnumeratorBlockEntity) {
            enumerator = (EntropicEnumeratorBlockEntity)blockEntity;
            boolean willFail = true;
            AlchemyResult result = ((AlchemyStartEvent)alchemyEvent).getRecipe().getResult(((AlchemyStartEvent)alchemyEvent).context);
            int requirement = ((AlchemyStartEvent)alchemyEvent).getRecipe().getInputs().size();
            if (result.blackPins == requirement) {
                willFail = false;
            } else {
                boolean first = false;
                for (UpgradeContext upgrade : upgrades) {
                    IUpgradeProvider iUpgradeProvider = upgrade.upgrade();
                    if (!(iUpgradeProvider instanceof EntropicEnumeratorUpgrade)) continue;
                    EntropicEnumeratorUpgrade firstEnumerator = (EntropicEnumeratorUpgrade)iUpgradeProvider;
                    if (firstEnumerator == this) {
                        first = true;
                        break;
                    }
                    willFail = ((EntropicEnumeratorBlockEntity)firstEnumerator.tile).willFail;
                    break;
                }
                if (first) {
                    if (Misc.random.nextFloat(count + 3) > 3.0f) {
                        willFail = true;
                    } else {
                        int bonusNothing;
                        int bonusWhite = Math.min(result.whitePins, count + 1);
                        if (requirement <= result.blackPins + bonusWhite + (bonusNothing = count / 2)) {
                            willFail = false;
                        }
                    }
                }
                enumerator.willFail = willFail;
            }
            int solveTime = UpgradeUtil.getWorkTime(tile, 400, upgrades) - 10;
            if (solveTime < 38 * EntropicEnumeratorBlockEntity.solvingMoveTime) {
                return;
            }
            enumerator.solve(false, solveTime, willFail);
        }
        if (event instanceof AlchemyResultEvent) {
            alchemyEvent = (AlchemyResultEvent)event;
            blockEntity = this.tile;
            if (blockEntity instanceof EntropicEnumeratorBlockEntity) {
                enumerator = (EntropicEnumeratorBlockEntity)blockEntity;
                ((AlchemyResultEvent)alchemyEvent).setFailure(enumerator.willFail);
                enumerator.restartScramble(Misc.random.nextInt(EntropicEnumeratorBlockEntity.queueTime));
            }
        }
    }
}

