/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.rekindled.embers.api.augment.AugmentUtil;
import com.rekindled.embers.api.augment.IAugment;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;

public class AugmentPredicate
extends ItemPredicate {
    public static final ResourceLocation ID = new ResourceLocation("embers", "augment");
    protected final IAugment augment;
    protected final int level;

    public AugmentPredicate(IAugment augment, int level) {
        this.augment = augment;
        this.level = level;
    }

    public boolean m_45049_(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return AugmentUtil.hasHeat(stack) && AugmentUtil.getAugmentLevel(stack, this.augment) >= this.level;
    }

    public JsonElement m_45048_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", ID.toString());
        json.addProperty("augment", this.augment.getName().toString());
        if (this.level != 1) {
            json.addProperty("level", (Number)this.level);
        }
        return json;
    }

    public static AugmentPredicate deserialize(JsonObject json) {
        IAugment augment = AugmentUtil.getAugment(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"augment")));
        int level = 1;
        if (json.has("level")) {
            level = GsonHelper.m_13927_((JsonObject)json, (String)"level");
        }
        return new AugmentPredicate(augment, level);
    }
}

