/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.util;

import com.google.gson.JsonObject;
import com.rekindled.embers.util.Misc;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidOutput {
    public static final FluidOutput EMPTY = new FluidOutput((TagKey<Fluid>)FluidTags.create((ResourceLocation)new ResourceLocation("empty")), -1);
    public FluidStack stack = FluidStack.EMPTY;
    public TagKey<Fluid> tag;
    public int amount = 0;

    public FluidOutput(FluidStack stack) {
        this.stack = stack;
    }

    public FluidOutput(TagKey<Fluid> tag, int amount) {
        this.tag = tag;
        this.amount = amount;
    }

    public boolean isEmpty() {
        return this.amount < 0;
    }

    public FluidStack getStack() {
        if (!this.stack.isEmpty()) {
            return this.stack;
        }
        this.stack = new FluidStack(Misc.getTaggedFluid(this.tag), this.amount);
        return this.stack;
    }

    public static FluidOutput fromJson(JsonObject json) {
        if (json.has("tag")) {
            return new FluidOutput((TagKey<Fluid>)FluidTags.create((ResourceLocation)new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"tag"))), GsonHelper.m_13824_((JsonObject)json, (String)"amount", (int)1));
        }
        return new FluidOutput(Misc.deserializeFluidStack(json));
    }

    public JsonObject toJson() {
        if (this.tag != null) {
            JsonObject json = new JsonObject();
            json.addProperty("tag", this.tag.f_203868_().toString());
            json.addProperty("amount", (Number)this.amount);
            return json;
        }
        return Misc.serializeFluidStack(this.stack);
    }

    public static FluidOutput fromNetwork(FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            return new FluidOutput((TagKey<Fluid>)FluidTags.create((ResourceLocation)buffer.m_130281_()), buffer.readInt());
        }
        return new FluidOutput(FluidStack.readFromPacket((FriendlyByteBuf)buffer));
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        if (this.tag != null) {
            buffer.writeBoolean(true);
            buffer.m_130085_(this.tag.f_203868_());
            buffer.writeInt(this.amount);
        } else {
            buffer.writeBoolean(false);
            this.stack.writeToPacket(buffer);
        }
    }
}

