/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable;

import com.mojang.logging.LogUtils;
import net.bandit.reskillable.Configuration;
import net.bandit.reskillable.client.Overlay;
import net.bandit.reskillable.client.Tooltip;
import net.bandit.reskillable.common.CuriosCompat;
import net.bandit.reskillable.common.EventHandler;
import net.bandit.reskillable.common.commands.Commands;
import net.bandit.reskillable.common.network.NetworkInit;
import net.bandit.reskillable.event.ClientEvents;
import net.bandit.reskillable.event.SkillAttachments;
import net.bandit.reskillable.event.SoundRegistry;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="reskillable")
public class Reskillable {
    public static final String MOD_ID = "reskillable";
    private static final Logger LOGGER = LogUtils.getLogger();

    public Reskillable(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        SkillAttachments.init(modEventBus);
        modEventBus.addListener(NetworkInit::register);
        SoundRegistry.SOUND_EVENTS.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)new EventHandler());
        NeoForge.EVENT_BUS.register((Object)new Commands());
        NeoForge.EVENT_BUS.register((Object)this);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Configuration.CONFIG_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        Configuration.load();
        if (ModList.get().isLoaded("curios")) {
            NeoForge.EVENT_BUS.register((Object)new CuriosCompat());
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from BanditBytes - Reskillable");
    }

    @EventBusSubscriber(modid="reskillable", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("Reskillable Client Setup Successful");
            NeoForge.EVENT_BUS.register((Object)new Tooltip());
            NeoForge.EVENT_BUS.register((Object)new Overlay());
            NeoForge.EVENT_BUS.register(ClientEvents.class);
        }
    }
}

