/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable.client.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bandit.reskillable.Configuration;
import net.bandit.reskillable.client.screen.buttons.SkillButton;
import net.bandit.reskillable.common.capabilities.SkillModel;
import net.bandit.reskillable.common.commands.skills.Skill;
import net.bandit.reskillable.common.commands.skills.SkillAttributeBonus;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class SkillScreen
extends Screen {
    public static final ResourceLocation RESOURCES = ResourceLocation.fromNamespaceAndPath((String)"reskillable", (String)"textures/gui/skills.png");
    public static final ResourceLocation PERKS_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"reskillable", (String)"textures/gui/perks.png");
    private static final int PERK_BOX_X = 12;
    private static final int PERK_BOX_Y = 29;
    private static final int PERK_ROW_HEIGHT = 15;
    private static final int PERK_TEXT_OFFSET_X = 15;
    private final Map<Skill, String> xpCostDisplay = new HashMap<Skill, String>();
    private final Map<Skill, Integer> xpCostColor = new HashMap<Skill, Integer>();
    private int page = 0;
    private Button skillsTab;
    private Button perksTab;

    public SkillScreen() {
        super((Component)Component.empty());
    }

    protected void init() {
        int left = (this.width - 162) / 2;
        int top = (this.height - 128) / 2;
        this.clearWidgets();
        if (this.page == 0) {
            for (int i = 0; i < 8; ++i) {
                int x = left + i % 2 * 83;
                int y = top + i / 2 * 36;
                Skill skill = Skill.values()[i];
                this.addRenderableWidget((GuiEventListener)new SkillButton(x, y, skill));
            }
        }
        int guiLeft = (this.width - 176) / 2;
        int guiTop = (this.height - 166) / 2;
        int tabWidth = 45;
        int tabHeight = 17;
        this.skillsTab = new TabButton(guiLeft + 11, guiTop + 4, tabWidth, tabHeight, b -> {
            if (this.page != 0) {
                this.page = 0;
                this.init(this.minecraft, this.width, this.height);
            }
        });
        this.perksTab = new TabButton(guiLeft + 176 - 11 - tabWidth, guiTop + 4, tabWidth, tabHeight, b -> {
            if (this.page != 1) {
                this.page = 1;
                this.init(this.minecraft, this.width, this.height);
            }
        });
        this.addRenderableWidget((GuiEventListener)this.skillsTab);
        this.addRenderableWidget((GuiEventListener)this.perksTab);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int panelWidth = 176;
        int panelHeight = 166;
        int left = (this.width - panelWidth) / 2;
        int top = (this.height - panelHeight) / 2;
    }

    public void render(@NotNull GuiGraphics g, int mouseX, int mouseY, float pt) {
        this.renderTransparentBackground(g);
        int left = (this.width - 176) / 2;
        int top = (this.height - 166) / 2;
        this.renderBackground(g, mouseX, mouseY, pt);
        g.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        ResourceLocation background = this.page == 0 ? RESOURCES : PERKS_TEXTURE;
        g.blit(background, left, top, 0, 0, 176, 166);
        RenderSystem.defaultBlendFunc();
        if (this.page == 0) {
            int i = 0;
            for (Skill skill : Skill.values()) {
                int x = left + i % 2 * 83 + 10;
                int y = top + i / 2 * 36 + 20;
                String xpCost = this.xpCostDisplay.getOrDefault((Object)skill, "N/A");
                int color = this.xpCostColor.getOrDefault((Object)skill, 0xFFFFFF);
                g.drawString(this.font, "XP: " + xpCost, x, y, color, false);
                ++i;
            }
        } else {
            this.renderPerksPage(g, left, top);
        }
        super.render(g, mouseX, mouseY, pt);
        if (this.page == 0) {
            for (Renderable widget : this.renderables) {
                SkillButton button;
                if (!(widget instanceof SkillButton) || !(button = (SkillButton)widget).isMouseOver(mouseX, mouseY)) continue;
                List<Component> lines = button.getTooltipLines((Player)Minecraft.getInstance().player);
                g.renderTooltip(this.font, lines.stream().map(Component::getVisualOrderText).toList(), mouseX, mouseY);
            }
        }
        g.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderPerksPage(GuiGraphics gui, int left, int top) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        SkillModel model = SkillModel.get((Player)player);
        if (model == null) {
            return;
        }
        int row = 0;
        for (Skill skill : Skill.values()) {
            int skillLevel = model.getSkillLevel(skill);
            int boxX = left + 12;
            int boxY = top + 29 + row * 15;
            int textX = boxX + 15;
            int textY = boxY + 5;
            Component line = this.buildSinglePerkLine(skill, skillLevel);
            float scale = 0.85f;
            gui.pose().pushPose();
            gui.pose().translate((float)textX, (float)textY, 0.0f);
            gui.pose().scale(scale, scale, 1.0f);
            gui.drawString(this.font, line, 0, 0, 0xFFFFFF, false);
            gui.pose().popPose();
            ++row;
        }
    }

    private Component buildSinglePerkLine(Skill skill, int skillLevel) {
        MutableComponent effect;
        MutableComponent amount;
        MutableComponent skillName = Component.translatable((String)("skill." + skill.name().toLowerCase())).withStyle(ChatFormatting.GOLD);
        boolean locked = skillLevel < 5;
        switch (skill) {
            case AGILITY: {
                double pct = skillLevel >= 5 ? (double)skillLevel / 5.0 * 25.0 : 0.0;
                amount = Component.literal((String)String.format("+%.0f%%", pct)).withStyle(ChatFormatting.AQUA);
                effect = Component.translatable((String)"tooltip.rereskillable.run_speed").withStyle(ChatFormatting.GRAY);
                break;
            }
            case MINING: {
                SkillAttributeBonus bonus = SkillAttributeBonus.getBySkill(skill);
                double perStep = bonus != null ? bonus.getBonusPerStep() : 0.0;
                double pct = skillLevel >= 5 ? (double)skillLevel / 5.0 * perStep * 100.0 : 0.0;
                amount = Component.literal((String)String.format("+%.0f%%", pct)).withStyle(ChatFormatting.AQUA);
                effect = Component.translatable((String)"tooltip.rereskillable.break_speed").withStyle(ChatFormatting.GRAY);
                break;
            }
            case GATHERING: {
                double pct = skillLevel >= 5 ? (double)skillLevel / 5.0 * (Double)Configuration.GATHERING_XP_BONUS.get() * 100.0 : 0.0;
                amount = Component.literal((String)String.format("+%.0f%%", pct)).withStyle(ChatFormatting.AQUA);
                effect = Component.translatable((String)"tooltip.rereskillable.bonus_xp_orbs").withStyle(ChatFormatting.GRAY);
                break;
            }
            case FARMING: {
                double perStep = (Double)Configuration.CROP_GROWTH_CHANCE.get();
                double pct = skillLevel >= 5 ? (double)skillLevel / 5.0 * perStep * 100.0 : 0.0;
                amount = Component.literal((String)String.format("+%.0f%%", pct)).withStyle(ChatFormatting.AQUA);
                effect = Component.translatable((String)"tooltip.rereskillable.crop_growth").withStyle(ChatFormatting.GRAY);
                break;
            }
            case BUILDING: {
                double perStep = (Double)Configuration.BLOCK_REACH_BONUS.get();
                double blocks = skillLevel >= 5 ? (double)skillLevel / 5.0 * perStep : 0.0;
                amount = Component.literal((String)String.format("+%.1f", blocks)).withStyle(ChatFormatting.AQUA);
                effect = Component.translatable((String)"tooltip.rereskillable.block_reach").withStyle(ChatFormatting.GRAY);
                break;
            }
            default: {
                SkillAttributeBonus bonus = SkillAttributeBonus.getBySkill(skill);
                if (bonus == null) {
                    return Component.empty();
                }
                double perStep = bonus.getBonusPerStep();
                double pct = skillLevel >= 5 ? (double)skillLevel / 5.0 * perStep * 100.0 : 0.0;
                amount = Component.literal((String)String.format("+%.0f%%", pct)).withStyle(ChatFormatting.AQUA);
                Attribute attr = bonus.getAttribute();
                effect = attr != null ? Component.translatable((String)attr.getDescriptionId()).withStyle(ChatFormatting.GRAY) : Component.empty();
            }
        }
        MutableComponent line = Component.literal((String)"").append((Component)skillName).append(": ").append((Component)amount).append(" ").append((Component)effect);
        return line;
    }

    private void renderTotalXPTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            int totalXP = this.calculateTotalXP((Player)player);
            int level = this.getLevelForTotalXP(totalXP);
            MutableComponent totalXPComponent = Component.literal((String)String.valueOf(totalXP)).withStyle(ChatFormatting.GREEN);
            MutableComponent levelComponent = Component.literal((String)String.valueOf(level));
            MutableComponent tooltip = Component.translatable((String)"tooltip.rereskillable.total_xp", (Object[])new Object[]{totalXPComponent, levelComponent});
            ArrayList<MutableComponent> tooltipLines = new ArrayList<MutableComponent>();
            tooltipLines.add(tooltip);
            tooltipLines.add(Component.literal((String)" "));
            SkillModel model = SkillModel.get((Player)player);
            if (model != null) {
                for (Skill skill : Skill.values()) {
                    double amount;
                    Attribute attribute;
                    int skillLevel = model.getSkillLevel(skill);
                    SkillAttributeBonus bonus = SkillAttributeBonus.getBySkill(skill);
                    Attribute attribute2 = attribute = bonus != null ? bonus.getAttribute() : null;
                    if (bonus == null || attribute == null || skillLevel < 5 || !((amount = (double)skillLevel / 5.0 * bonus.getBonusPerStep()) > 0.0)) continue;
                    MutableComponent skillName = Component.translatable((String)("skill." + skill.name().toLowerCase())).withStyle(ChatFormatting.GOLD);
                    MutableComponent attrName = Component.translatable((String)attribute.getDescriptionId()).withStyle(ChatFormatting.GRAY);
                    String percentText = String.format("+%.0f%%", amount * 100.0);
                    MutableComponent bonusLine = Component.literal((String)"").append((Component)skillName).append(": ").append((Component)Component.literal((String)percentText).withStyle(ChatFormatting.AQUA)).append(" ").append((Component)attrName);
                    tooltipLines.add(bonusLine);
                }
            }
            guiGraphics.renderTooltip(Minecraft.getInstance().font, tooltipLines.stream().map(Component::getVisualOrderText).toList(), mouseX, mouseY);
        }
    }

    private int calculateTotalXP(Player player) {
        int level = player.experienceLevel;
        float progress = player.experienceProgress;
        if (level <= 16) {
            return level * level + 6 * level + Math.round(progress * (float)(2 * level + 7));
        }
        if (level <= 31) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0) + Math.round(progress * (float)(5 * level - 38));
        }
        return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0) + Math.round(progress * (float)(9 * level - 158));
    }

    private int getLevelForTotalXP(int totalXP) {
        int level = 0;
        while (this.getCumulativeXPForLevel(level + 1) <= totalXP) {
            ++level;
        }
        return level;
    }

    private int getCumulativeXPForLevel(int level) {
        if (level <= 0) {
            return 0;
        }
        if (level <= 16) {
            return level * (level + 1) + level * 6;
        }
        if (level <= 31) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void tick() {
        super.tick();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        SkillModel skillModel = SkillModel.get((Player)player);
        if (skillModel == null) {
            return;
        }
        for (Skill skill : Skill.values()) {
            int skillLevel = skillModel.getSkillLevel(skill);
            int xpCost = Configuration.calculateCostForLevel(skillLevel + 1);
            boolean hasXP = skillModel.hasSufficientXP((Player)player, skill);
            this.xpCostDisplay.put(skill, String.valueOf(xpCost));
            this.xpCostColor.put(skill, hasXP ? 65280 : 0xFF0000);
        }
    }

    private static class TabButton
    extends Button {
        public TabButton(int x, int y, int width, int height, Button.OnPress onPress) {
            super(x, y, width, height, (Component)Component.empty(), onPress, DEFAULT_NARRATION);
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        }
    }
}

