/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable.common.network.payload;

import net.bandit.reskillable.Configuration;
import net.bandit.reskillable.common.capabilities.SkillModel;
import net.bandit.reskillable.common.commands.skills.Skill;
import net.bandit.reskillable.common.network.payload.SyncToClient;
import net.bandit.reskillable.event.SoundRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;

public record RequestLevelUp(int skillIndex) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"reskillable", (String)"request_levelup");
    public static final CustomPacketPayload.Type<RequestLevelUp> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, RequestLevelUp> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, RequestLevelUp::skillIndex, RequestLevelUp::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(RequestLevelUp msg, ServerPlayer player) {
        if (!Configuration.isSkillLevelingEnabled()) {
            player.sendSystemMessage((Component)Component.translatable((String)"reskillable.server.disabled"));
            return;
        }
        SkillModel model = SkillModel.get((Player)player);
        if (model == null || msg.skillIndex < 0 || msg.skillIndex >= Skill.values().length) {
            return;
        }
        Skill skill = Skill.values()[msg.skillIndex];
        int currentLevel = model.getSkillLevel(skill);
        if (currentLevel >= Configuration.getMaxLevel()) {
            player.sendSystemMessage((Component)Component.translatable((String)"reskillable.maxlevel"));
            return;
        }
        int cost = Configuration.calculateCostForLevel(currentLevel);
        int totalXp = RequestLevelUp.getTotalXp(player);
        if (player.isCreative() || totalXp >= cost) {
            if (!player.isCreative()) {
                RequestLevelUp.deductXp(player, cost);
            }
            model.increaseSkillLevel(skill, (Player)player);
            player.level().playSound(null, player.blockPosition(), (SoundEvent)SoundRegistry.LEVEL_UP_EVENT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            if (model.getSkillLevel(skill) % 5 == 0) {
                player.level().playSound(null, player.blockPosition(), (SoundEvent)SoundRegistry.MILESTONE_EVENT.get(), SoundSource.PLAYERS, 1.0f, 1.2f);
            }
            SyncToClient.send(player);
        } else {
            player.sendSystemMessage((Component)Component.translatable((String)"reskillable.not_enough"));
        }
    }

    private static int getTotalXp(ServerPlayer player) {
        int level = player.experienceLevel;
        float progress = player.experienceProgress;
        int base = RequestLevelUp.getXpForLevel(level);
        int next = RequestLevelUp.getXpForLevel(level + 1);
        return base + Math.round((float)(next - base) * progress);
    }

    private static void deductXp(ServerPlayer player, int cost) {
        int totalXp = RequestLevelUp.getTotalXp(player);
        int newXp = totalXp - cost;
        player.experienceLevel = RequestLevelUp.getLevelForTotalXp(newXp);
        player.experienceProgress = RequestLevelUp.getProgressForLevel(newXp, player.experienceLevel);
        player.totalExperience = newXp;
    }

    private static int getXpForLevel(int level) {
        if (level <= 16) {
            return level * level + 6 * level;
        }
        if (level <= 31) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
    }

    private static int getLevelForTotalXp(int xp) {
        int level = 0;
        while (RequestLevelUp.getXpForLevel(level + 1) <= xp) {
            ++level;
        }
        return level;
    }

    private static float getProgressForLevel(int xp, int level) {
        int base = RequestLevelUp.getXpForLevel(level);
        int next = RequestLevelUp.getXpForLevel(level + 1);
        return (float)(xp - base) / (float)(next - base);
    }

    public static void send(Skill skill) {
        PacketDistributor.sendToServer((CustomPacketPayload)new RequestLevelUp(skill.index), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

