/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ghastscrash.procedures;

import javax.annotation.Nullable;
import net.mcreator.ghastscrash.entity.FallingGhastEntity;
import net.mcreator.ghastscrash.init.GhastscrashModEntities;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

@EventBusSubscriber
public class GhastDiesProcedure {
    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        if (event.getEntity() != null) {
            GhastDiesProcedure.execute((Event)event, (LevelAccessor)event.getEntity().level(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), (Entity)event.getEntity());
        }
    }

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        GhastDiesProcedure.execute(null, world, x, y, z, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        if (entity instanceof Ghast) {
            entity.setInvisible(true);
            if (world instanceof ServerLevel) {
                ServerLevel projectileLevel = (ServerLevel)world;
                AbstractArrow _entityToSpawn = GhastDiesProcedure.initArrowProjectile(new FallingGhastEntity((EntityType<? extends FallingGhastEntity>)((EntityType)GhastscrashModEntities.FALLING_GHAST.get()), 0.0, 0.0, 0.0, (Level)projectileLevel, GhastDiesProcedure.createArrowWeaponItemStack((Level)projectileLevel, 1, (byte)0)), null, 5.0f, true, false, false, AbstractArrow.Pickup.DISALLOWED);
                _entityToSpawn.setPos(x, y, z);
                _entityToSpawn.shoot((double)Mth.nextInt((RandomSource)RandomSource.create(), (int)-1, (int)1), (double)Mth.nextInt((RandomSource)RandomSource.create(), (int)-2, (int)-4), (double)Mth.nextInt((RandomSource)RandomSource.create(), (int)-1, (int)1), 1.0f, 10.0f);
                projectileLevel.addFreshEntity((Entity)_entityToSpawn);
            }
            if (world instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)world;
                _level.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, x, y, z, 50, 1.0, 1.0, 1.0, 0.02);
            }
        }
    }

    private static AbstractArrow initArrowProjectile(AbstractArrow entityToSpawn, Entity shooter, float damage, boolean silent, boolean fire, boolean particles, AbstractArrow.Pickup pickup) {
        entityToSpawn.setOwner(shooter);
        entityToSpawn.setBaseDamage((double)damage);
        if (silent) {
            entityToSpawn.setSilent(true);
        }
        if (fire) {
            entityToSpawn.igniteForSeconds(100.0f);
        }
        if (particles) {
            entityToSpawn.setCritArrow(true);
        }
        entityToSpawn.pickup = pickup;
        return entityToSpawn;
    }

    private static ItemStack createArrowWeaponItemStack(Level level, int knockback, byte piercing) {
        ItemStack weapon = new ItemStack((ItemLike)Items.ARROW);
        if (knockback > 0) {
            weapon.enchant((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.KNOCKBACK), knockback);
        }
        if (piercing > 0) {
            weapon.enchant((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.PIERCING), (int)piercing);
        }
        return weapon;
    }
}

