/*
 * Decompiled with CFR 0.152.
 */
package com.ryankshah.skyrimstamina.mixin;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FoodProperties.class})
public class FoodPropertiesMixin {
    @Inject(method={"onConsume"}, at={@At(value="TAIL")})
    private void addHealingAfterConsume(Level level, LivingEntity entity, ItemStack stack, Consumable consumable, CallbackInfo ci) {
        FoodProperties properties = (FoodProperties)this;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!level.isClientSide()) {
                float healAmount = (float)properties.nutrition() * 0.5f;
                player.heal(healAmount);
            }
        }
    }
}

