/*
 * Decompiled with CFR 0.152.
 */
package com.ryankshah.skyrimstamina.mixin;

import com.ryankshah.skyrimstamina.data.StaminaAccessor;
import com.ryankshah.skyrimstamina.data.StaminaData;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Inject(method={"setSprinting"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventSprintingWithoutStamina(boolean sprinting, CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        if (entity instanceof Player) {
            StaminaData staminaData;
            Player player = (Player)entity;
            if (sprinting && !(staminaData = ((StaminaAccessor)player).skyrimstamina$getStaminaData()).canSprint()) {
                ci.cancel();
            }
        }
    }
}

