/*
 * Decompiled with CFR 0.152.
 */
package orbital_railgun_cataclysm_7xm6d5mb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import orbital_railgun_cataclysm_7xm6d5mb.OrbitalRailgunCataclysm;
import orbital_railgun_cataclysm_7xm6d5mb.network.SequenceStartPayload;

@Environment(value=EnvType.CLIENT)
public class OrbitalRailgunCataclysmClient
implements ClientModInitializer {
    private static final List<ClientEffect> ACTIVE = new ArrayList<ClientEffect>();
    private static float prevYawOffset = 0.0f;
    private static float prevPitchOffset = 0.0f;
    private static int chargeTicksClient = 0;
    private static int lastSelectedSlot = -1;

    public void onInitializeClient() {
        PayloadTypeRegistry.playS2C().register(SequenceStartPayload.ID, SequenceStartPayload.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(SequenceStartPayload.ID, (payload, context) -> context.client().execute(() -> ACTIVE.add(new ClientEffect(payload.center(), payload.durationTicks()))));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            boolean using;
            if (client.field_1724 == null) {
                return;
            }
            int sel = client.field_1724.method_31548().method_67532();
            if (lastSelectedSlot == -1) {
                lastSelectedSlot = sel;
            }
            if (sel != lastSelectedSlot) {
                chargeTicksClient = 0;
                lastSelectedSlot = sel;
            }
            try {
                OrbitalRailgunCataclysmClient.clientParticlesTick(client);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            client.field_1724.method_36456(client.field_1724.method_36454() - prevYawOffset);
            client.field_1724.method_36457(client.field_1724.method_36455() - prevPitchOffset);
            prevYawOffset = 0.0f;
            prevPitchOffset = 0.0f;
            Iterator<ClientEffect> it = ACTIVE.iterator();
            while (it.hasNext()) {
                ClientEffect e = it.next();
                ++e.age;
                if (e.age < e.duration) continue;
                it.remove();
            }
            if (!ACTIVE.isEmpty()) {
                float total = 0.0f;
                for (ClientEffect e : ACTIVE) {
                    float t = Math.min(1.0f, (float)e.age / (float)e.duration);
                    float intensity = 0.1f * (1.0f + (float)Math.sin(62.83185307179586 * (double)t));
                    total += intensity;
                }
                total = Math.min(0.8f, total);
                prevYawOffset = (client.field_1687.field_9229.method_43057() - 0.5f) * total;
                prevPitchOffset = (client.field_1687.field_9229.method_43057() - 0.5f) * total;
                client.field_1724.method_36456(client.field_1724.method_36454() + prevYawOffset);
                client.field_1724.method_36457(client.field_1724.method_36455() + prevPitchOffset);
            }
            class_1799 main = client.field_1724.method_5998(class_1268.field_5808);
            boolean bl = using = client.field_1724.method_6115() && main.method_31574(OrbitalRailgunCataclysm.OrbitalRailgunCataclysm_ITEM);
            if (using) {
                ++chargeTicksClient;
                if (client.field_1724.method_7357().method_7904(main)) {
                    chargeTicksClient = 0;
                }
            } else {
                chargeTicksClient = 0;
            }
            if (using) {
                float ct2 = Math.min(1.0f, (float)chargeTicksClient / 40.0f);
                float intensity2 = 0.1f * (ct2 * ct2);
                float addYaw = (client.field_1687.field_9229.method_43057() - 0.5f) * intensity2;
                float addPitch = (client.field_1687.field_9229.method_43057() - 0.5f) * intensity2;
                prevYawOffset += addYaw;
                prevPitchOffset += addPitch;
                client.field_1724.method_36456(client.field_1724.method_36454() + addYaw);
                client.field_1724.method_36457(client.field_1724.method_36455() + addPitch);
            }
        });
        HudRenderCallback.EVENT.register((draw, tickCounter) -> {
            float prog;
            boolean scoping;
            class_310 client = class_310.method_1551();
            if (client.field_1724 == null) {
                return;
            }
            int sel = client.field_1724.method_31548().method_67532();
            if (lastSelectedSlot == -1) {
                lastSelectedSlot = sel;
            }
            if (sel != lastSelectedSlot) {
                chargeTicksClient = 0;
                lastSelectedSlot = sel;
            }
            int w = draw.method_51421();
            int h = draw.method_51443();
            class_1799 main = client.field_1724.method_5998(class_1268.field_5808);
            boolean bl = scoping = client.field_1724.method_6115() && main.method_31574(OrbitalRailgunCataclysm.OrbitalRailgunCataclysm_ITEM);
            if (scoping) {
                int frame = -1275068416;
                int bar = Math.min(w, h) / 8;
                draw.method_25294(0, 0, w, bar, frame);
                draw.method_25294(0, h - bar, w, h, frame);
                draw.method_25294(0, 0, bar, h, frame);
                draw.method_25294(w - bar, 0, w, h, frame);
                int cx = w / 2;
                int cy = h / 2;
                int len = Math.min(w, h) / 10;
                int green = -603914425;
                draw.method_25294(cx - len, cy - 1, cx + len, cy + 1, green);
                draw.method_25294(cx - 1, cy - len, cx + 1, cy + len, green);
                draw.method_25294(0, 0, w, h, 0x2200FF00);
                float pwr = Math.min(1.0f, (float)chargeTicksClient / 40.0f);
                int pw = Math.min(w, h) / 6;
                int ph = 3;
                int px = cx - pw / 2;
                int py = cy + len + 6;
                int pc = -939458816;
                draw.method_25294(px, py, px + (int)((float)pw * pwr), py + ph, pc);
                class_3965 bhr = client.field_1687.method_17742(new class_3959(client.field_1724.method_33571(), client.field_1724.method_33571().method_1019(client.field_1724.method_5720().method_1021(100.0)), class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)client.field_1724));
                double dist = 0.0;
                int tx = 0;
                int ty = 0;
                int tz = 0;
                if (bhr.method_17783() == class_239.class_240.field_1332) {
                    class_2338 bp = bhr.method_17777();
                    tx = bp.method_10263();
                    ty = bp.method_10264();
                    tz = bp.method_10260();
                    dist = bp.method_46558().method_1022(client.field_1724.method_33571());
                }
                class_327 tr = client.field_1772;
                int textC = 65351;
                draw.method_51439(tr, (class_2561)class_2561.method_43470((String)String.format("X:%d Y:%d Z:%d", tx, ty, tz)), bar + 6, h - bar + 6, textC, true);
                class_5250 class_52502 = class_2561.method_43470((String)String.format("D:%.1f", dist));
                Objects.requireNonNull(tr);
                draw.method_51439(tr, (class_2561)class_52502, bar + 6, h - bar + 6 + 9 + 2, textC, true);
                String radius = "R:30";
                draw.method_51439(tr, (class_2561)class_2561.method_43470((String)radius), w - bar - 6 - tr.method_1727(radius), h - bar + 6, textC, true);
            }
            int selIdx = client.field_1724.method_31548().method_67532();
            class_1799 selStack = client.field_1724.method_31548().method_5438(selIdx);
            if (!selStack.method_7960() && selStack.method_31574(OrbitalRailgunCataclysm.OrbitalRailgunCataclysm_ITEM) && (prog = client.field_1724.method_7357().method_7905(selStack, 0.0f)) > 0.0f) {
                int g;
                int r;
                int baseX = w / 2 - 91;
                int baseY = h - 22;
                int sx = baseX + selIdx * 20;
                int sy = baseY;
                int bw = 20;
                int th = 2;
                if (prog < 0.5f) {
                    r = (int)(prog * 2.0f * 255.0f);
                    g = 255;
                } else {
                    r = 255;
                    g = (int)((1.0f - (prog - 0.5f) * 2.0f) * 255.0f);
                }
                int barColor = 0xC8000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8;
                int lenPx = (int)((float)bw * prog);
                draw.method_25294(sx, sy - th, sx + lenPx, sy, barColor);
            }
        });
    }

    private static void clientParticlesTick(class_310 client) {
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
    }

    private static class_243 fibPoint(int i, int n, double phi) {
        double yi = 1.0 - (2.0 * (double)i + 1.0) / Math.max(1.0, (double)n);
        double r = Math.sqrt(Math.max(0.0, 1.0 - yi * yi));
        double theta = Math.PI * 2 * (double)i / phi;
        double x = Math.cos(theta) * r;
        double z = Math.sin(theta) * r;
        return new class_243(x, yi, z);
    }

    private static class_243 hilbert2DPoint(int index, int order) {
        int n = 1 << order;
        int x = 0;
        int y = 0;
        int t = index;
        for (int s = 1; s < n; s <<= 1) {
            int rx = 1 & t / 2;
            int ry = 1 & (t ^ rx);
            if (ry == 0) {
                if (rx == 1) {
                    x = s - 1 - x;
                    y = s - 1 - y;
                }
                int tmp = x;
                x = y;
                y = tmp;
            }
            x += s * rx;
            y += s * ry;
            t >>= 2;
        }
        double fx = ((double)x + 0.5) / (double)n * 2.0 - 1.0;
        double fz = ((double)y + 0.5) / (double)n * 2.0 - 1.0;
        return new class_243(fx, 0.0, fz);
    }

    private static boolean inFrontOfCamera(class_243 p, class_243 eye, class_243 view) {
        class_243 to = p.method_1020(eye);
        return to.method_1026(view) > 0.0;
    }

    private static boolean isVisibleToPlayer(class_310 client, class_243 p) {
        double pDist;
        if (client.field_1687 == null || client.field_1724 == null) {
            return false;
        }
        if ((client.field_1687.method_8510() + (long)(p.field_1352 * 13.0 + p.field_1351 * 7.0 + p.field_1350 * 3.0)) % 3L != 0L) {
            return true;
        }
        class_243 eye = client.field_1724.method_33571();
        class_3959 ctx = new class_3959(eye, p, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)client.field_1724);
        class_3965 hit = client.field_1687.method_17742(ctx);
        if (hit == null) {
            return true;
        }
        if (hit.method_17783() == class_239.class_240.field_1333) {
            return true;
        }
        double hitDist = hit.method_17784().method_1025(eye);
        return hitDist >= (pDist = p.method_1025(eye)) - 0.25;
    }

    @Environment(value=EnvType.CLIENT)
    private static class ClientEffect {
        final class_243 center;
        final int duration;
        int age;

        ClientEffect(class_243 c, int d) {
            this.center = c;
            this.duration = d;
            this.age = 0;
        }
    }
}

