/*
 * Decompiled with CFR 0.152.
 */
package orbital_railgun_cataclysm_7xm6d5mb.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_239;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3756;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_5743;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.class_8710;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import orbital_railgun_cataclysm_7xm6d5mb.network.SequenceStartPayload;

public class OrbitalRailgunCataclysmItem
extends class_1792 {
    private static final Map<class_3218, List<Sequence>> ACTIVE_SEQUENCES = new WeakHashMap<class_3218, List<Sequence>>();
    private static final class_5321<class_8110> ORBITAL_DAMAGE = class_5321.method_29179((class_5321)class_7924.field_42534, (class_2960)class_2960.method_60655((String)"orbital-railgun-cataclysm-7xm6d5mb", (String)"orbital_strike"));
    private static final int P1_SCAN = 80;
    private static final int P2_IMPACT = 160;
    private static final int P3_SPHERE = 100;
    private static final int P4_IMPLODE = 0;
    private static final int P5_APOCALYPSE = 260;
    private static final Random RAND = new Random();
    private static final class_2390 S_DUST_GREEN = new class_2390(65280, 2.0f);
    private static final class_2390 S_DUST_CYAN = new class_2390(60928, 2.0f);
    private static final class_2390 S_DUST_DARK = new class_2390(26112, 2.0f);
    private static final class_2390 S_DUST_WHITE = new class_2390(0x33CCFF, 2.0f);
    private static final class_2390 S_DUST_BLUE_RING = new class_2390(0x33CCFF, 2.0f);
    private static final class_5743 S_DUST_TRANSITION = new class_5743(43520, 65450, 2.0f);
    private static final String CHARGING_KEY = "Charging";
    private static final String CHARGE_TIME_KEY = "ChargeTime";
    private static final String ACTIVE_KEY = "Active";
    private static final int MAX_USE_TIME = 72000;
    private static final int CHARGE_DURATION = 40;
    private static final float DESTRUCTION_RADIUS = 30.0f;
    private static final int COOLDOWN_TICKS = 240;

    private static void spawnParticlesBudgeted(class_3218 world, class_2394 effect, double x, double y, double z, int count, double ox, double oy, double oz, double speed) {
        BudgetedParticles.spawn(world, effect, x, y, z, count, ox, oy, oz, speed);
    }

    public static void tickSequences(class_3218 world) {
        try {
            BudgetedParticles.beginTick(world);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        List<Sequence> list = ACTIVE_SEQUENCES.get(world);
        if (list == null || list.isEmpty()) {
            return;
        }
        Iterator<Sequence> it = list.iterator();
        while (it.hasNext()) {
            Sequence seq = it.next();
            if (seq.tick(world)) continue;
            it.remove();
        }
    }

    public static void addSequence(class_3218 world, class_243 center) {
        List list = ACTIVE_SEQUENCES.computeIfAbsent(world, w -> new ArrayList());
        Sequence seq = new Sequence(center);
        list.add(seq);
        int totalDuration = 600;
        world.method_18766(player -> player.method_5707(center) < 65536.0).forEach(p -> ServerPlayNetworking.send((class_3222)p, (class_8710)new SequenceStartPayload(center, totalDuration)));
    }

    private static void spawnEndRodOverlay(class_3218 world, double x, double y, double z, int count, double ox, double oy, double oz, double speed) {
        for (int i = 0; i < count; ++i) {
            OrbitalRailgunCataclysmItem.spawnParticlesBudgeted(world, (class_2394)class_2398.field_11207, x, y, z, 1, ox, oy, oz, speed);
        }
    }

    private static void spawnGreenSpark(class_3218 world, double x, double y, double z, int count, double ox, double oy, double oz, double speed) {
        for (int i = 0; i < count; ++i) {
            int roll = RAND.nextInt(100);
            if (roll < 50) {
                OrbitalRailgunCataclysmItem.spawnParticlesBudgeted(world, (class_2394)class_2398.field_11211, x, y, z, 1, ox, oy, oz, speed);
                continue;
            }
            if (roll < 85) {
                OrbitalRailgunCataclysmItem.spawnParticlesBudgeted(world, (class_2394)class_2398.field_28478, x, y, z, 1, ox, oy, oz, speed);
                continue;
            }
            OrbitalRailgunCataclysmItem.spawnParticlesBudgeted(world, (class_2394)class_2398.field_23114, x, y, z, 1, ox, oy, oz, speed);
        }
    }

    private static void spawnCyanMix(class_3218 world, double x, double y, double z, int count, double ox, double oy, double oz, double speed) {
        for (int i = 0; i < count; ++i) {
            BudgetedParticles.spawn(world, (class_2394)class_2398.field_11211, x, y, z, 1, ox, oy, oz, speed);
            BudgetedParticles.spawn(world, (class_2394)class_2398.field_28478, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private static void spawnType(class_3218 world, class_2394 type, double x, double y, double z, int count, double ox, double oy, double oz, double speed) {
        BudgetedParticles.spawn(world, type, x, y, z, Math.max(0, count), ox, oy, oz, speed);
    }

    private static void playInRange(class_3218 world, class_243 at, double maxRange, class_3414 sound, class_3419 cat, float vol, float pitch) {
        for (class_3222 p : world.method_18456()) {
            double d2 = p.method_19538().method_1025(at);
            if (!(d2 <= maxRange * maxRange)) continue;
            world.method_43128(null, p.method_23317(), p.method_23318(), p.method_23321(), sound, cat, vol, pitch);
        }
    }

    private static void playInRange(class_3218 world, class_243 at, double maxRange, class_6880<class_3414> soundRef, class_3419 cat, float vol, float pitch) {
        OrbitalRailgunCataclysmItem.playInRange(world, at, maxRange, (class_3414)soundRef.comp_349(), cat, vol, pitch);
    }

    public OrbitalRailgunCataclysmItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (user.method_7357().method_7904(stack)) {
            return class_1269.field_5814;
        }
        if (this.isActive(stack)) {
            this.setActive(stack, false);
            this.setCharging(stack, false);
            this.setChargeTime(stack, 0);
        }
        this.setActive(stack, true);
        this.setCharging(stack, true);
        this.setChargeTime(stack, 0);
        user.method_6019(hand);
        if (!world.field_9236) {
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_14703, class_3419.field_15248, 0.8f, 0.5f);
        }
        return class_1269.field_21466;
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (!(user instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)user;
        if (player.method_7357().method_7904(stack)) {
            return;
        }
        if (this.isCharging(stack)) {
            int chargeTime = this.getChargeTime(stack) + 1;
            this.setChargeTime(stack, chargeTime);
            float ct = Math.min(1.0f, (float)chargeTime / 40.0f);
            float s = 3.0f * ct * ct - 2.0f * ct * ct * ct;
            if (!world.field_9236 && chargeTime % 10 == 0) {
                float basePitch = 0.5f + 0.5f * s;
                world.method_60511(null, player.method_23317(), player.method_23318(), player.method_23321(), (class_6880)class_3417.field_23792, class_3419.field_15248, 0.4f + 0.3f * s, 0.55f);
                world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15045, class_3419.field_15248, 0.6f + 0.4f * s, basePitch);
                if (chargeTime / 10 % 2 == 0) {
                    world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_26980, class_3419.field_15248, 0.5f + 0.3f * s, 1.25f + 0.2f * s);
                }
            }
            if (chargeTime >= 40) {
                this.setCharging(stack, false);
                if (!world.field_9236) {
                    world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14703, class_3419.field_15248, 0.9f, 1.2f);
                }
            }
        }
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            if (!this.isCharging(stack) && this.isActive(stack)) {
                this.fireOrbitalStrike(world, player, stack);
            }
        }
        return stack;
    }

    public boolean method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            if (!this.isCharging(stack) && this.isActive(stack)) {
                this.fireOrbitalStrike(world, player, stack);
            } else {
                this.setActive(stack, false);
                this.setCharging(stack, false);
                this.setChargeTime(stack, 0);
            }
        }
        return true;
    }

    private void fireOrbitalStrike(class_1937 world, class_1657 player, class_1799 stack) {
        class_3965 hitResult = world.method_17742(new class_3959(player.method_33571(), player.method_33571().method_1019(player.method_5720().method_1021(100.0)), class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player));
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            class_2338 targetPos = hitResult.method_17777();
            if (!world.field_9236) {
                world.method_43128(null, (double)targetPos.method_10263(), (double)targetPos.method_10264(), (double)targetPos.method_10260(), class_3417.field_23116, class_3419.field_15251, 1.3f, 0.6f);
                world.method_43128(null, (double)targetPos.method_10263(), (double)targetPos.method_10264(), (double)targetPos.method_10260(), class_3417.field_14703, class_3419.field_15251, 0.9f, 0.7f);
                this.spawnOrbitalStrikeSequence((class_3218)world, targetPos);
                player.method_7353((class_2561)class_2561.method_43470((String)"Orbital strike inbound!").method_27692(class_124.field_1076), true);
                player.method_7357().method_62835(stack, 240);
                stack.method_7970(10, (class_1309)player, class_1309.method_56079((class_1268)player.method_6058()));
            }
        }
        this.setActive(stack, false);
        this.setCharging(stack, false);
        this.setChargeTime(stack, 0);
    }

    private void spawnOrbitalStrikeSequence(class_3218 world, class_2338 targetPos) {
        OrbitalRailgunCataclysmItem.addSequence(world, new class_243((double)targetPos.method_10263() + 0.5, (double)targetPos.method_10264() + 0.5, (double)targetPos.method_10260() + 0.5));
        world.method_8503().method_3734().method_44252(world.method_8503().method_3739().method_9217(), "advancement grant @a[distance=..64] only orbital-railgun-cataclysm-7xm6d5mb:first_strike");
    }

    private static void createOrbitalExplosion(class_3218 world, class_2338 center) {
        world.method_43128(null, (double)center.method_10263(), (double)center.method_10264(), (double)center.method_10260(), class_3417.field_14981, class_3419.field_15251, 4.6f, 1.05f);
        world.method_60511(null, (double)center.method_10263(), (double)center.method_10264(), (double)center.method_10260(), (class_6880)class_3417.field_23117, class_3419.field_15251, 4.0f, 0.65f);
        world.method_60511(null, (double)center.method_10263(), (double)center.method_10264(), (double)center.method_10260(), (class_6880)class_3417.field_23792, class_3419.field_15251, 3.5f, 0.55f);
        OrbitalRailgunCataclysmItem.spawnGreenSpark(world, center.method_10263(), center.method_10264(), center.method_10260(), 1000, 5.0, 5.0, 5.0, 0.1);
        OrbitalRailgunCataclysmItem.spawnGreenSpark(world, center.method_10263(), center.method_10264(), center.method_10260(), 600, 3.5, 3.5, 3.5, 0.15);
        OrbitalRailgunCataclysmItem.spawnGreenSpark(world, center.method_10263(), center.method_10264(), center.method_10260(), 400, 6.0, 6.0, 6.0, 0.2);
        int rMax = 30;
        int yRange = 45;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int dx = -rMax; dx <= rMax; ++dx) {
            for (int dz = -rMax; dz <= rMax; ++dz) {
                int r2 = dx * dx + dz * dz;
                if (r2 > rMax * rMax) continue;
                for (int dy = -yRange; dy <= yRange; ++dy) {
                    mutable.method_10103(center.method_10263() + dx, center.method_10264() + dy, center.method_10260() + dz);
                    if (!world.method_24794((class_2338)mutable)) continue;
                    int dist = (int)Math.sqrt(r2);
                    if (dist <= 10) {
                        world.method_8652((class_2338)mutable, class_2246.field_10124.method_9564(), 3);
                        continue;
                    }
                    if (dist <= 20) {
                        if (world.method_8320((class_2338)mutable).method_26215()) continue;
                        world.method_8652((class_2338)mutable, class_2246.field_10092.method_9564(), 3);
                        continue;
                    }
                    if (dist <= 26) {
                        if (world.method_8320((class_2338)mutable).method_26215()) continue;
                        world.method_8652((class_2338)mutable, class_2246.field_22423.method_9564(), 3);
                        continue;
                    }
                    if (dist > 30 || world.method_8320((class_2338)mutable).method_26215()) continue;
                    world.method_8652((class_2338)mutable, class_2246.field_10540.method_9564(), 3);
                }
            }
        }
        class_238 aabb = new class_238((double)(center.method_10263() - rMax), (double)(center.method_10264() - yRange), (double)(center.method_10260() - rMax), (double)(center.method_10263() + rMax + 1), (double)(center.method_10264() + yRange + 1), (double)(center.method_10260() + rMax + 1));
        world.method_18467(class_1309.class, aabb).forEach(e -> {
            double dz;
            double dx = e.method_23317() - ((double)center.method_10263() + 0.5);
            double r2e = dx * dx + (dz = e.method_23321() - ((double)center.method_10260() + 0.5)) * dz;
            if (r2e <= (double)(rMax * rMax) && Math.abs(e.method_23318() - ((double)center.method_10264() + 0.5)) <= (double)yRange) {
                e.method_64397(world, world.method_48963().method_48797(ORBITAL_DAMAGE, null, null), Float.MAX_VALUE);
            }
        });
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        return 72000;
    }

    public boolean method_7886(class_1799 stack) {
        return this.isActive(stack);
    }

    public void method_67187(class_1799 stack, class_1792.class_9635 context, class_10712 displayComponent, Consumer<class_2561> textConsumer, class_1836 type) {
        textConsumer.accept((class_2561)class_2561.method_43471((String)"item.orbital-railgun-cataclysm-7xm6d5mb.orbital_railgun_cataclysm_7xm6d5mb.tooltip").method_27692(class_124.field_1064));
        textConsumer.accept((class_2561)class_2561.method_43471((String)"item.orbital-railgun-cataclysm-7xm6d5mb.orbital_railgun_cataclysm_7xm6d5mb.tooltip.charge").method_27692(class_124.field_1080));
        textConsumer.accept((class_2561)class_2561.method_43471((String)"item.orbital-railgun-cataclysm-7xm6d5mb.orbital_railgun_cataclysm_7xm6d5mb.tooltip.warning").method_27692(class_124.field_1061));
        if (type.method_8035()) {
            textConsumer.accept((class_2561)class_2561.method_43470((String)"Destruction Radius: 30.0 blocks").method_27692(class_124.field_1079));
            textConsumer.accept((class_2561)class_2561.method_43470((String)"Charge Time: 2.0 seconds").method_27692(class_124.field_1075));
        }
    }

    private boolean isActive(class_1799 stack) {
        class_9279 customData = (class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
        return customData.method_57463().method_10577(ACTIVE_KEY).orElse(false);
    }

    private void setActive(class_1799 stack, boolean active) {
        class_9279 customData = (class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
        class_2487 nbt = customData.method_57463().method_10553();
        nbt.method_10556(ACTIVE_KEY, active);
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)nbt));
    }

    private boolean isCharging(class_1799 stack) {
        class_9279 customData = (class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
        return customData.method_57463().method_10577(CHARGING_KEY).orElse(false);
    }

    private void setCharging(class_1799 stack, boolean charging) {
        class_9279 customData = (class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
        class_2487 nbt = customData.method_57463().method_10553();
        nbt.method_10556(CHARGING_KEY, charging);
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)nbt));
    }

    private int getChargeTime(class_1799 stack) {
        class_9279 customData = (class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
        return customData.method_57463().method_10550(CHARGE_TIME_KEY).orElse(0);
    }

    private void setChargeTime(class_1799 stack, int time) {
        class_9279 customData = (class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
        class_2487 nbt = customData.method_57463().method_10553();
        nbt.method_10569(CHARGE_TIME_KEY, time);
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)nbt));
    }

    static void applyImpactCrater(class_3218 world, class_2338 center) {
        int d2;
        int dx;
        int r = 20;
        int r2 = r * r;
        class_2338.class_2339 m = new class_2338.class_2339();
        for (dx = -r; dx <= r; ++dx) {
            for (int dy = -r; dy <= r; ++dy) {
                for (int dz = -r; dz <= r; ++dz) {
                    d2 = dx * dx + dy * dy + dz * dz;
                    if (d2 > r2) continue;
                    m.method_10103(center.method_10263() + dx, center.method_10264() + dy, center.method_10260() + dz);
                    if (!world.method_24794((class_2338)m)) continue;
                    world.method_8652((class_2338)m, class_2246.field_10124.method_9564(), 3);
                }
            }
        }
        for (dx = -r - 1; dx <= r + 1; ++dx) {
            for (int dz = -r - 1; dz <= r + 1; ++dz) {
                for (int dy = -r - 1; dy <= r + 1; ++dy) {
                    class_2680 st;
                    d2 = dx * dx + dy * dy + dz * dz;
                    if (Math.abs(Math.sqrt(d2) - (double)r) > 1.5) continue;
                    m.method_10103(center.method_10263() + dx, center.method_10264() + dy, center.method_10260() + dz);
                    if (!world.method_24794((class_2338)m) || (st = world.method_8320((class_2338)m)).method_26215()) continue;
                    if (st.method_27852(class_2246.field_10340) || st.method_27852(class_2246.field_28888) || st.method_27852(class_2246.field_23869) || st.method_27852(class_2246.field_22091)) {
                        world.method_8652((class_2338)m, class_2246.field_10416.method_9564(), 3);
                        continue;
                    }
                    if (!(world.method_8409().method_43057() < 0.2f)) continue;
                    world.method_8652((class_2338)m, class_2246.field_10092.method_9564(), 3);
                }
            }
        }
    }

    private static final class BudgetedParticles {
        private static final int SOFT_LIMIT_PER_TICK = 120000;
        private static final int AVG_LIFETIME_TICKS = 100;
        private static final int MAJOR_THRESHOLD = 60000;
        private static final Map<class_3218, int[]> COUNTS = new WeakHashMap<class_3218, int[]>();
        private static final Map<class_3218, Long> LAST_MAJOR = new WeakHashMap<class_3218, Long>();
        private static final Map<class_3218, Long> ALIVE_EST = new WeakHashMap<class_3218, Long>();

        private BudgetedParticles() {
        }

        /*
         * Exception decompiling
         */
        static void beginTick(class_3218 world) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        private static boolean canSpawn(class_3218 world) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        private static int remaining(class_3218 world) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        private static void add(class_3218 world, int c) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        static void spawn(class_3218 world, class_2394 effect, double x, double y, double z, int count, double ox, double oy, double oz, double speed) {
            if (count <= 0) {
                return;
            }
            if (ALIVE_EST.getOrDefault(world, 0L) >= 800000L) {
                return;
            }
            if (count >= 60000) {
                long last;
                long now = world.method_8510();
                if (now - (last = LAST_MAJOR.getOrDefault(world, -100000L).longValue()) < 2L) {
                    return;
                }
                LAST_MAJOR.put(world, now);
            }
            if (!BudgetedParticles.canSpawn(world)) {
                return;
            }
            int allow = Math.min(count, BudgetedParticles.remaining(world));
            if (allow <= 0) {
                return;
            }
            class_2394 eff = BudgetedParticles.clampEffect(effect);
            world.method_65096(eff, x, y, z, allow, ox, oy, oz, speed);
            BudgetedParticles.add(world, allow);
        }

        private static class_2394 clampEffect(class_2394 eff) {
            if (eff == S_DUST_WHITE || eff == S_DUST_BLUE_RING) {
                return class_2398.field_23114;
            }
            if (eff instanceof class_2390 || eff instanceof class_5743) {
                return class_2398.field_28478;
            }
            if (eff == class_2398.field_29644) {
                return class_2398.field_11211;
            }
            if (eff == class_2398.field_11207) {
                return class_2398.field_11207;
            }
            if (eff instanceof class_2388) {
                return class_2398.field_28803;
            }
            return eff;
        }
    }

    private static class Sequence {
        private final class_243 center;
        private int age;
        private boolean didExplosion;
        private final Random random = new Random();
        private boolean impactFlashed = false;
        private boolean craterApplied = false;
        private boolean singularityPulseDone = false;
        private boolean detonationBangDone = false;
        private int postImpactTicksRemaining = 0;
        private int debrisTicksRemaining = 0;
        private final class_3756 perlin = new class_3756(class_5819.method_43047());
        private int shockStartTick = -1;
        private final double[] waveOffsetsSec = new double[]{0.0, 0.5, 2.0};
        private final double[] waveSpeeds = new double[]{16.0, 16.6667, 30.0};
        private final double[] waveK = new double[]{2.2, 1.2, 0.8};
        private final Map<class_2338, class_2680> p1ReplacedBlocks = new HashMap<class_2338, class_2680>();
        private boolean p1Reverted = false;

        Sequence(class_243 center) {
            this.center = center;
            this.age = 0;
            this.didExplosion = false;
        }

        boolean tick(class_3218 world) {
            boolean hasAudience;
            boolean bl = hasAudience = !world.method_18766(p -> p.method_5707(this.center) <= 640000.0).isEmpty();
            if (!hasAudience) {
                ++this.age;
                return this.age < this.totalDuration();
            }
            int t = this.age;
            int p1End = 80;
            int p2End = p1End + 160;
            int p3End = p2End + 100;
            int p4End = p3End + 0;
            int p5End = p4End + 260;
            if (t < p1End) {
                this.phaseScan(world, (float)t / 80.0f);
            } else if (t < p2End) {
                this.phaseImpact(world, (float)(t - p1End) / 160.0f);
            } else if (t < p3End) {
                this.phaseSphere(world, (float)(t - p2End) / 100.0f);
            } else if (t < p4End) {
                this.phaseImplode(world, 0.0f);
            } else if (t < p5End) {
                this.phaseApocalypse(world, (float)(t - p4End) / 260.0f);
                if (!this.didExplosion) {
                    this.didExplosion = true;
                    class_2338 bp = class_2338.method_49638((class_2374)this.center);
                    OrbitalRailgunCataclysmItem.createOrbitalExplosion(world, bp);
                }
            }
            this.tickPostImpactVisuals(world);
            this.tickShockwaves(world);
            this.soundtrackTick(world);
            ++this.age;
            return this.age < p5End;
        }

        private int totalDuration() {
            return 600;
        }

        private void phaseScan(class_3218 world, float x) {
            int top;
            double sec = Math.max(0.0, Math.min(1.0, (double)x)) * 4.0;
            int topCenter = world.method_8624(class_2902.class_2903.field_13202, class_3532.method_15357((double)this.center.field_1352), class_3532.method_15357((double)this.center.field_1350));
            double yBase = Math.max(this.center.field_1351, (double)topCenter + 2.0);
            long par = world.method_8510();
            if ((par & 1L) == 0L) {
                double theta = Math.PI * sec;
                double[] ringLayers = new double[]{28.0, 30.0, 32.0};
                int ringSamples = 200;
                for (double R : ringLayers) {
                    for (int k = 0; k < ringSamples; ++k) {
                        double ang = theta + Math.PI * 2 * (double)k / (double)ringSamples;
                        double rx = this.center.field_1352 + R * Math.cos(ang);
                        double rz = this.center.field_1350 + R * Math.sin(ang);
                        double localY = yBase + Math.sin(8.0 * ang);
                        OrbitalRailgunCataclysmItem.spawnType(world, (class_2394)class_2398.field_11207, rx, localY, rz, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
            if ((par & 1L) == 0L) {
                for (int i = 0; i < 28; ++i) {
                    double baseDeg = 12.8571428571 * (double)i + 100.0 * (sec % 3.0);
                    double beta = Math.toRadians(baseDeg);
                    for (double r = 0.0; r <= 30.0; r += 0.5) {
                        double px = this.center.field_1352 + r * Math.cos(beta);
                        double pz = this.center.field_1350 + r * Math.sin(beta);
                        int top2 = world.method_8624(class_2902.class_2903.field_13202, class_3532.method_15357((double)px), class_3532.method_15357((double)pz));
                        double py = Math.max((double)top2 + 0.5, 62.0);
                        OrbitalRailgunCataclysmItem.spawnType(world, (class_2394)class_2398.field_28803, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                for (double gx = -30.0; gx <= 30.0; gx += 1.5) {
                    for (double gz = -30.0; gz <= 30.0; gz += 1.5) {
                        double px = this.center.field_1352 + gx;
                        double pz = this.center.field_1350 + gz;
                        top = world.method_8624(class_2902.class_2903.field_13202, class_3532.method_15357((double)px), class_3532.method_15357((double)pz));
                        double py = (double)top + 0.5;
                        OrbitalRailgunCataclysmItem.spawnType(world, (class_2394)class_2398.field_23114, px, py + 0.1, pz, 1, 0.0, -0.01, 0.0, 0.0);
                    }
                }
            } else {
                double yScan = 80.0 - 20.0 * sec;
                for (int bx = -30; bx <= 30; bx += 3) {
                    for (int bz = -30; bz <= 30; bz += 3) {
                        double px = this.center.field_1352 + (double)bx;
                        double pz = this.center.field_1350 + (double)bz;
                        top = world.method_8624(class_2902.class_2903.field_13202, class_3532.method_15357((double)px), class_3532.method_15357((double)pz));
                        double py = Math.max((double)top + 0.5, 62.0);
                        if (!(yScan >= py - 0.25)) continue;
                        OrbitalRailgunCataclysmItem.spawnType(world, (class_2394)class_2398.field_11211, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
                        if ((bx + bz + this.age & 0x1F) != 0) continue;
                        OrbitalRailgunCataclysmItem.spawnType(world, (class_2394)class_2398.field_11211, px, py + 0.02, pz, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                for (int m = -8; m <= 8; ++m) {
                    double px = this.center.field_1352 + 25.0 * Math.sin(5.0 * (sec + 0.002 * (double)m));
                    double pz = this.center.field_1350 + 25.0 * Math.cos(3.0 * (sec + 0.002 * (double)m));
                    OrbitalRailgunCataclysmItem.spawnType(world, (class_2394)class_2398.field_28478, px, yBase + 0.05, pz, 1, 0.0, 0.0, 0.0, 0.0);
                    if ((m & 3) != 0) continue;
                    OrbitalRailgunCataclysmItem.spawnType(world, (class_2394)class_2398.field_28478, px, yBase + 0.05, pz, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            if (this.age % 10 == 0) {
                OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_15045, class_3419.field_15248, 0.7f, 0.9f);
            }
            if (this.age % 5 == 0) {
                OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, (class_3414)class_3417.field_14725.comp_349(), class_3419.field_15248, 0.5f, 1.2f);
            }
            if (this.age % 7 == 0) {
                OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_14572, class_3419.field_15248, 0.3f, 1.6f);
            }
            float humVol = (float)(0.2 + 0.8 * (sec / 4.0));
            if (this.age % 4 == 0) {
                OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, (class_6880<class_3414>)class_3417.field_23792, class_3419.field_15248, humVol, 0.5f);
            }
            if (this.age % 6 == 0) {
                OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, (class_3414)class_3417.field_14622.comp_349(), class_3419.field_15248, 0.4f + (float)(sec / 4.0) * 0.6f, 2.0f);
            }
            if (this.age % 10 == 0) {
                OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, (class_3414)class_3417.field_14725.comp_349(), class_3419.field_15248, 0.6f + (float)(sec / 4.0) * 0.6f, 1.6f);
            }
            if (this.age % 20 == 0) {
                int Rpulse = 5;
                for (int dx = -Rpulse; dx <= Rpulse; ++dx) {
                    for (int dz = -Rpulse; dz <= Rpulse; ++dz) {
                        if (dx * dx + dz * dz > Rpulse * Rpulse) continue;
                        double px = this.center.field_1352 + (double)dx;
                        double pz = this.center.field_1350 + (double)dz;
                        top = world.method_8624(class_2902.class_2903.field_13202, class_3532.method_15357((double)px), class_3532.method_15357((double)pz));
                        class_2338 bpos = new class_2338(class_3532.method_15357((double)px), top, class_3532.method_15357((double)pz));
                        class_2680 st = world.method_8320(bpos);
                        if (!st.method_27852(class_2246.field_10219)) continue;
                        if (!this.p1ReplacedBlocks.containsKey(bpos)) {
                            this.p1ReplacedBlocks.put(bpos, st);
                        }
                        world.method_8652(bpos, class_2246.field_28681.method_9564(), 3);
                        OrbitalRailgunCataclysmItem.spawnGreenSpark(world, px, (double)top + 1.0, pz, 5, 0.5, 0.1, 0.5, 0.02);
                    }
                }
            }
        }

        private void phaseImpact(class_3218 world, float q) {
            int phaseBudget;
            double r;
            double sec = Math.max(0.0, Math.min(1.0, (double)q)) * 8.0;
            if (!this.p1Reverted && !this.p1ReplacedBlocks.isEmpty()) {
                try {
                    for (Map.Entry<class_2338, class_2680> e : this.p1ReplacedBlocks.entrySet()) {
                        if (!world.method_8320(e.getKey()).method_27852(class_2246.field_28681)) continue;
                        world.method_8652(e.getKey(), e.getValue(), 3);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.p1ReplacedBlocks.clear();
                this.p1Reverted = true;
            }
            if (sec < 4.0) {
                u = sec / 4.0;
                r = 2.0 + 18.0 * (u * u * u);
            } else if (sec < 6.0) {
                r = 20.0;
            } else {
                u = (sec - 6.0) / 2.0;
                r = 20.0 - 18.0 * (u * u * u);
            }
            r = Math.max(0.5, Math.min(20.0, r));
            int topCenter = world.method_8624(class_2902.class_2903.field_13202, class_3532.method_15357((double)this.center.field_1352), class_3532.method_15357((double)this.center.field_1350));
            double minY = (double)topCenter + 0.5;
            if (this.age % 2 == 0) {
                world.method_60511(null, this.center.field_1352, this.center.field_1351, this.center.field_1350, class_3417.field_14606, class_3419.field_15248, 0.6f, 0.9f - (float)(sec / 8.0) * 0.4f);
            }
            if (this.age % 1 == 0) {
                world.method_43128(null, this.center.field_1352, this.center.field_1351, this.center.field_1350, class_3417.field_26980, class_3419.field_15248, 0.3f, 1.8f);
            }
            if (this.age % 20 == 0) {
                world.method_43128(null, this.center.field_1352, this.center.field_1351, this.center.field_1350, class_3417.field_14785, class_3419.field_15248, 0.7f, 0.5f);
                world.method_43128(null, this.center.field_1352, this.center.field_1351, this.center.field_1350, class_3417.field_14833, class_3419.field_15248, 0.5f, 1.2f);
                world.method_43128(null, this.center.field_1352, this.center.field_1351, this.center.field_1350, class_3417.field_26979, class_3419.field_15248, 0.6f, 1.8f);
            }
            if (this.age % 7 == 0) {
                float base = (float)Math.max(0.3, 0.3 + sec / 8.0 * 0.9);
                world.method_8396(null, class_2338.method_49638((class_2374)this.center), class_3417.field_15045, class_3419.field_15251, 0.8f, base);
            }
            if (this.age % 13 == 0) {
                world.method_8396(null, class_2338.method_49638((class_2374)this.center), class_3417.field_26980, class_3419.field_15251, 0.4f, 1.7f);
            }
            if ((phaseBudget = Math.min(80000, BudgetedParticles.remaining(world))) > 0) {
                int i;
                int mode = (int)(world.method_8510() % 3L);
                class_2400 shellType = mode == 0 ? class_2398.field_11211 : (mode == 1 ? class_2398.field_28478 : class_2398.field_23114);
                int nSurface = (int)((double)phaseBudget * 0.6);
                int nVolume = phaseBudget - nSurface;
                double golden = Math.PI * (3.0 - Math.sqrt(5.0));
                for (i = 0; i < nSurface; ++i) {
                    double y = 1.0 - 2.0 * (double)i / Math.max(1.0, (double)(nSurface - 1));
                    double rad = Math.sqrt(Math.max(0.0, 1.0 - y * y));
                    double theta = golden * (double)i;
                    double xh = r * Math.cos(theta) * rad;
                    double zh = r * Math.sin(theta) * rad;
                    double yh = r * y;
                    double px = this.center.field_1352 + xh;
                    double py = this.center.field_1351 + yh;
                    double pz = this.center.field_1350 + zh;
                    if (!(py >= minY)) continue;
                    OrbitalRailgunCataclysmItem.spawnType(world, (class_2394)shellType, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
                }
                for (i = 0; i < nVolume; ++i) {
                    double u1 = this.random.nextDouble();
                    double cost = 2.0 * this.random.nextDouble() - 1.0;
                    double sint = Math.sqrt(Math.max(0.0, 1.0 - cost * cost));
                    double phi = Math.PI * 2 * this.random.nextDouble();
                    double rad = r * Math.cbrt(u1);
                    double dx = rad * sint * Math.cos(phi);
                    double dy = rad * cost;
                    double dz = rad * sint * Math.sin(phi);
                    double px = this.center.field_1352 + dx;
                    double py = this.center.field_1351 + dy;
                    double pz = this.center.field_1350 + dz;
                    if (py < minY || Math.abs(py - this.center.field_1351) > 40.0) continue;
                    double rr = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    class_2400 eff = rr < 7.0 ? class_2398.field_23114 : (rr < 13.0 ? class_2398.field_28478 : (rr < 18.0 ? class_2398.field_11211 : class_2398.field_28803));
                    OrbitalRailgunCataclysmItem.spawnType(world, (class_2394)eff, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            if (this.age % 10 == 0 && r > 2.0) {
                for (int a = 0; a < 24; ++a) {
                    double udir = this.random.nextDouble();
                    double phiA = Math.acos(1.0 - 2.0 * udir);
                    double thetaA = Math.PI * 2 * this.random.nextDouble();
                    double nx = Math.sin(phiA) * Math.cos(thetaA);
                    double ny = Math.cos(phiA);
                    double nz = Math.sin(phiA) * Math.sin(thetaA);
                    int segs = 20;
                    for (int s = 0; s <= segs; ++s) {
                        double g = (double)s / (double)segs;
                        double px = this.center.field_1352 + nx * r * g;
                        double py = this.center.field_1351 + ny * r * g;
                        double pz = this.center.field_1350 + nz * r * g;
                        if ((s & 1) != 0) continue;
                        OrbitalRailgunCataclysmItem.spawnGreenSpark(world, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
            double rotInner = Math.toRadians(-30.0) * sec;
            double rotOuter = Math.toRadians(45.0) * sec;
            double[][] bands = new double[][]{{0.0, Math.min(10.0, r)}, {10.0, Math.min(15.0, r)}, {15.0, Math.min(20.0, r)}, {20.0, Math.min(24.0, r)}, {24.0, Math.min(27.0, r)}, {27.0, Math.min(29.5, r)}, {Math.max(29.5, r - 0.5), r}};
            for (int b = 0; b < bands.length; ++b) {
                double rMax = bands[b][1];
                double rMin = bands[b][0];
                if (rMax - rMin <= 0.05) continue;
                int samples = 0;
                for (int s = 0; s < samples; ++s) {
                    double u1 = this.random.nextDouble();
                    double v1 = this.random.nextDouble();
                    double thetaL = Math.PI * 2 * u1 + (b <= 2 ? rotInner : rotOuter);
                    double phiL = Math.acos(1.0 - 2.0 * v1);
                    double rad = rMin + (rMax - rMin) * this.random.nextDouble();
                    double nx = Math.sin(phiL) * Math.cos(thetaL);
                    double ny = Math.cos(phiL);
                    double nz = Math.sin(phiL) * Math.sin(thetaL);
                    double px = this.center.field_1352 + rad * nx;
                    double py = this.center.field_1351 + rad * ny;
                    double pz = this.center.field_1350 + rad * nz;
                    int top = world.method_8624(class_2902.class_2903.field_13202, class_3532.method_15357((double)px), class_3532.method_15357((double)pz));
                    if (py < (double)top + 0.5 || Math.abs(py - this.center.field_1351) > 40.0) continue;
                    if (this.random.nextInt(20) == 0) {
                        OrbitalRailgunCataclysmItem.spawnGreenSpark(world, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
                        continue;
                    }
                    OrbitalRailgunCataclysmItem.spawnGreenSpark(world, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            double minDist = Double.MAX_VALUE;
            for (class_3222 p : world.method_18456()) {
                double d = p.method_19538().method_1022(this.center);
                if (!(d < minDist)) continue;
                minDist = d;
            }
            int rho = minDist < 50.0 ? 12 : (minDist < 150.0 ? 8 : 4);
            class_2400 shellType = (world.method_8510() & 1L) == 0L ? class_2398.field_11211 : class_2398.field_28478;
            this.spawnFibonacciShellNatural(world, r, rho, (class_2394)shellType);
        }

        private void phaseSphere(class_3218 world, float q) {
            double pz;
            double px;
            int j;
            double sec = Math.max(0.0, Math.min(1.0, (double)q)) * 5.0;
            double tnorm = sec / 5.0;
            double r = 30.0 * (1.0 - Math.pow(tnorm, 4.0));
            double yMin = -40.0;
            double yMax = 40.0;
            int layers = 160;
            double dy = (yMax - yMin) / (double)layers;
            int Ni = 600;
            long time = world.method_8510();
            boolean even = (time & 1L) == 0L;
            boolean odd = !even;
            boolean third = time % 3L == 0L;
            for (int li = 0; li < layers; ++li) {
                double pz2;
                double px2;
                double th;
                int k;
                double yLocal = yMin + (double)li * dy;
                double py = this.center.field_1351 + yLocal;
                int top = world.method_8624(class_2902.class_2903.field_13202, class_3532.method_15357((double)this.center.field_1352), class_3532.method_15357((double)this.center.field_1350));
                if (py < (double)top + 0.5) {
                    py = (double)top + 0.5;
                }
                if (even) {
                    for (j = 0; j < Ni; ++j) {
                        double th2 = Math.PI * 2 * (double)j / (double)Ni;
                        px = this.center.field_1352 + r * Math.cos(th2);
                        pz = this.center.field_1350 + r * Math.sin(th2);
                        OrbitalRailgunCataclysmItem.spawnType(world, (class_2394)class_2398.field_28803, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                if (even) {
                    double rho = 0.85 * r;
                    for (k = 0; k < Ni; ++k) {
                        th = Math.PI * 2 * (double)k / (double)Ni;
                        px2 = this.center.field_1352 + rho * Math.cos(th);
                        pz2 = this.center.field_1350 + rho * Math.sin(th);
                        OrbitalRailgunCataclysmItem.spawnType(world, (class_2394)class_2398.field_11211, px2, py, pz2, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                if (odd) {
                    double rho = 0.7 * r;
                    for (k = 0; k < Ni; ++k) {
                        th = Math.PI * 2 * (double)k / (double)Ni;
                        px2 = this.center.field_1352 + rho * Math.cos(th);
                        pz2 = this.center.field_1350 + rho * Math.sin(th);
                        OrbitalRailgunCataclysmItem.spawnType(world, (class_2394)class_2398.field_28478, px2, py, pz2, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                if (third) {
                    double rho = 0.5 * r;
                    for (k = 0; k < Ni; ++k) {
                        th = Math.PI * 2 * (double)k / (double)Ni;
                        px2 = this.center.field_1352 + rho * Math.cos(th);
                        pz2 = this.center.field_1350 + rho * Math.sin(th);
                        OrbitalRailgunCataclysmItem.spawnType(world, (class_2394)class_2398.field_23114, px2, py, pz2, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                if (!third) continue;
                double rho = 0.25 * r;
                for (k = 0; k < Ni; ++k) {
                    th = Math.PI * 2 * (double)k / (double)Ni;
                    px2 = this.center.field_1352 + rho * Math.cos(th);
                    pz2 = this.center.field_1350 + rho * Math.sin(th);
                    OrbitalRailgunCataclysmItem.spawnType(world, (class_2394)class_2398.field_23114, px2, py, pz2, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            for (double y = -40.0; y <= 40.0; y += 0.5) {
                double py = this.center.field_1351 + y;
                int top = world.method_8624(class_2902.class_2903.field_13202, class_3532.method_15357((double)this.center.field_1352), class_3532.method_15357((double)this.center.field_1350));
                if (py < (double)top + 0.5) {
                    py = (double)top + 0.5;
                }
                OrbitalRailgunCataclysmItem.spawnType(world, (class_2394)class_2398.field_23114, this.center.field_1352, py, this.center.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (sec >= 3.0) {
                double t2 = (sec - 3.0) / 2.0;
                double rSpiral = 30.0 * (1.0 - Math.pow(t2, 3.0));
                int bands = 20;
                for (int b = 0; b < bands; ++b) {
                    for (j = 0; j < 180; ++j) {
                        double ang = (double)j / 180.0 * 10.0 * Math.PI * t2 + (double)b * 0.3141592653589793;
                        px = this.center.field_1352 + rSpiral * Math.cos(ang);
                        pz = this.center.field_1350 + rSpiral * Math.sin(ang);
                        int top = world.method_8624(class_2902.class_2903.field_13202, class_3532.method_15357((double)px), class_3532.method_15357((double)pz));
                        double py = Math.max(this.center.field_1351, (double)top + 0.5);
                        OrbitalRailgunCataclysmItem.spawnType(world, (class_2394)class_2398.field_11211, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
                        if ((j & 0xF) != 0) continue;
                        OrbitalRailgunCataclysmItem.spawnType(world, (class_2394)class_2398.field_11211, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
        }

        private void phaseImplode(class_3218 world, float q) {
            if (this.random.nextInt(20) == 0) {
                world.method_60511(null, this.center.field_1352, this.center.field_1351, this.center.field_1350, (class_6880)class_3417.field_23117, class_3419.field_15251, 0.5f, 0.8f);
            }
        }

        private void phaseApocalypse(class_3218 world, float q) {
            double py;
            int i;
            double sec = Math.max(0.0, Math.min(1.0, (double)q)) * 13.0;
            if (!this.craterApplied) {
                this.craterApplied = true;
                this.applyImpactCrater(world, class_2338.method_49638((class_2374)this.center));
            }
            if (sec < 2.0) {
                if (this.age % 2 == 0) {
                    world.method_43128(null, this.center.field_1352, this.center.field_1351, this.center.field_1350, class_3417.field_14946, class_3419.field_15248, 0.6f, 0.5f);
                }
                if (this.age % 2 == 0) {
                    world.method_43128(null, this.center.field_1352, this.center.field_1351, this.center.field_1350, class_3417.field_38831, class_3419.field_15248, 0.7f, 0.5f);
                }
                double r = 55.0 * (sec / 2.0);
                double[] shells = new double[]{Math.min(r, 15.0), Math.max(0.0, Math.min(r, 35.0)), Math.max(0.0, Math.min(r, 45.0))};
                for (int s = 0; s < 3; ++s) {
                    double rr = shells[s];
                    if (rr <= 0.1) continue;
                    int N = s == 0 ? (int)(1500.0 * Math.pow(rr / 15.0, 2.0)) : (s == 1 ? (int)(5000.0 * Math.pow((rr - 15.0) / 20.0, 2.0)) : (int)(3000.0 * Math.pow((rr - 35.0) / 10.0, 2.0)));
                    N = Math.max(0, N);
                    for (int i2 = 0; i2 < N; ++i2) {
                        double u = ((double)i2 + 0.5) / (double)Math.max(1, N);
                        double phi = Math.acos(1.0 - 2.0 * u);
                        double theta = Math.PI * (3.0 - Math.sqrt(5.0)) * (double)i2;
                        double nx = Math.sin(phi) * Math.cos(theta);
                        double ny = Math.cos(phi);
                        double nz = Math.sin(phi) * Math.sin(theta);
                        double px = this.center.field_1352 + rr * nx;
                        double py2 = this.center.field_1351 + rr * ny;
                        double pz = this.center.field_1350 + rr * nz;
                        int top = world.method_8624(class_2902.class_2903.field_13202, class_3532.method_15357((double)px), class_3532.method_15357((double)pz));
                        py2 = Math.max(py2, (double)top + 0.5);
                        if (s == 0) {
                            OrbitalRailgunCataclysmItem.spawnGreenSpark(world, px, py2, pz, 1, 0.0, 0.0, 0.0, 0.0);
                            continue;
                        }
                        if (s == 1) {
                            if ((i2 & 1) == 0) {
                                OrbitalRailgunCataclysmItem.spawnGreenSpark(world, px, py2, pz, 1, 0.0, 0.0, 0.0, 0.0);
                                continue;
                            }
                            OrbitalRailgunCataclysmItem.spawnGreenSpark(world, px, py2, pz, 1, 0.0, 0.0, 0.0, 0.0);
                            continue;
                        }
                        OrbitalRailgunCataclysmItem.spawnGreenSpark(world, px, py2, pz, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                return;
            }
            double local = sec - 2.0;
            if (local < 0.6) {
                double x = local / 0.6;
                x = Math.max(0.0, Math.min(1.0, x));
                double smooth2 = x * x * (3.0 - 2.0 * x);
                double rCore = 35.0 * smooth2;
                int N = Math.max(800, (int)(Math.PI * 4 * rCore * rCore * 6.0));
                double[] layers = new double[]{rCore, Math.max(0.1, rCore * 0.85), Math.max(0.1, rCore * 0.65), Math.max(0.1, rCore * 0.45)};
                class_2394[] fx = new class_2394[]{class_2398.field_28478, class_2398.field_11211, class_2398.field_23114, class_2398.field_28803};
                for (int L = 0; L < layers.length; ++L) {
                    double rad = layers[L];
                    if (rad <= 0.2) continue;
                    int n = (int)((double)N * Math.pow(rad / rCore, 2.0));
                    this.fibonacciLayer(world, fx[L], rad, n);
                }
                return;
            }
            double u = Math.max(0.0, Math.min(1.0, (local - 3.0) / 8.0));
            double R = 20.0;
            double rMinor = 8.0;
            for (double uu = 0.0; uu < Math.PI * 2; uu += 0.10471975511965977) {
                for (double vv = 0.0; vv < Math.PI * 2; vv += 0.10471975511965977) {
                    double xh = (R + rMinor * Math.cos(vv)) * Math.cos(uu);
                    double yh = 30.0 + rMinor * Math.sin(vv);
                    double zh = (R + rMinor * Math.cos(vv)) * Math.sin(uu);
                    double px = this.center.field_1352 + xh;
                    double py3 = this.center.field_1351 + yh;
                    double pz = this.center.field_1350 + zh;
                    OrbitalRailgunCataclysmItem.spawnGreenSpark(world, px, py3, pz, 1, 0.15, 0.02, 0.15, 0.01);
                    if (((int)(uu * 1000.0) + (int)(vv * 1000.0) + this.age) % 7 != 0) continue;
                    OrbitalRailgunCataclysmItem.spawnGreenSpark(world, px, py3 + 0.03, pz, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            for (i = 0; i < 4000; ++i) {
                double uu = Math.PI * 2 * this.random.nextDouble();
                double vv = Math.PI * 2 * this.random.nextDouble();
                double xh = (R + rMinor * Math.cos(vv)) * Math.cos(uu);
                double yh = 30.0 + rMinor * Math.sin(vv);
                double zh = (R + rMinor * Math.cos(vv)) * Math.sin(uu);
                double px = this.center.field_1352 + xh;
                double py4 = this.center.field_1351 + yh;
                double pz = this.center.field_1350 + zh;
                OrbitalRailgunCataclysmItem.spawnGreenSpark(world, px, py4, pz, 1, 0.2, 0.02, 0.2, 0.01);
            }
            for (i = 0; i < 4000; ++i) {
                double ry = this.random.nextDouble() * 30.0;
                double ang = Math.PI * 2 * this.random.nextDouble();
                double rad = 4.0 * Math.sqrt(this.random.nextDouble());
                double px = this.center.field_1352 + rad * Math.cos(ang);
                double pz = this.center.field_1350 + rad * Math.sin(ang);
                py = this.center.field_1351 + ry;
                OrbitalRailgunCataclysmItem.spawnGreenSpark(world, px, py, pz, 1, 0.15, 0.05, 0.15, 0.015);
            }
            for (int m = 0; m < 12; ++m) {
                for (double tt = 0.0; tt <= 1.0; tt += 0.1) {
                    double xh = 30.0 * tt * Math.cos(Math.PI * 4 * tt + (double)m * Math.PI / 6.0);
                    double yh = 20.0 * tt;
                    double zh = 30.0 * tt * Math.sin(Math.PI * 4 * tt + (double)m * Math.PI / 6.0);
                    double px = this.center.field_1352 + xh;
                    py = this.center.field_1351 + yh;
                    double pz = this.center.field_1350 + zh;
                    OrbitalRailgunCataclysmItem.spawnGreenSpark(world, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
                    if ((int)(tt * 100.0) % 3 != 0) continue;
                    OrbitalRailgunCataclysmItem.spawnGreenSpark(world, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }

        private void tickPostImpactVisuals(class_3218 world) {
            if (this.postImpactTicksRemaining > 0) {
                double frac = (double)this.postImpactTicksRemaining / 50.0;
                double rMax = 80.0;
                double r = rMax * (1.0 - Math.cos(Math.PI * (1.0 - frac))) * 0.5;
                int pts = 4000;
                for (int i = 0; i < pts; ++i) {
                    double ang = (double)i / (double)pts * Math.PI * 2.0;
                    double x = this.center.field_1352 + r * Math.cos(ang);
                    double z = this.center.field_1350 + r * Math.sin(ang);
                    int top = world.method_8624(class_2902.class_2903.field_13202, class_3532.method_15357((double)x), class_3532.method_15357((double)z));
                    double y = Math.max(this.center.field_1351, (double)top + 0.5);
                    if ((i & 1) == 0) {
                        OrbitalRailgunCataclysmItem.spawnGreenSpark(world, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
                        continue;
                    }
                    OrbitalRailgunCataclysmItem.spawnGreenSpark(world, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
                }
                OrbitalRailgunCataclysmItem.spawnGreenSpark(world, this.center.field_1352, this.center.field_1351, this.center.field_1350, 1500, 6.0, 4.0, 6.0, 0.2);
                OrbitalRailgunCataclysmItem.spawnGreenSpark(world, this.center.field_1352, this.center.field_1351 + 0.2, this.center.field_1350, 1200, 5.2, 3.5, 5.2, 0.18);
                OrbitalRailgunCataclysmItem.spawnGreenSpark(world, this.center.field_1352, this.center.field_1351 + 0.5, this.center.field_1350, 800, 8.0, 5.0, 8.0, 0.25);
                --this.postImpactTicksRemaining;
            }
            if (this.debrisTicksRemaining > 0) {
                int count = 600;
                for (int i = 0; i < count; ++i) {
                    double r = 20.0 * Math.sqrt(this.random.nextDouble());
                    double ang = this.random.nextDouble() * Math.PI * 2.0;
                    double x = this.center.field_1352 + r * Math.cos(ang);
                    double z = this.center.field_1350 + r * Math.sin(ang);
                    int top = world.method_8624(class_2902.class_2903.field_13202, class_3532.method_15357((double)x), class_3532.method_15357((double)z));
                    double y = (double)top + 10.0 + this.random.nextDouble() * 8.0;
                    if ((i & 7) == 0) {
                        OrbitalRailgunCataclysmItem.spawnGreenSpark(world, x, y, z, 1, 0.0, -0.05, 0.0, 0.0);
                    }
                    OrbitalRailgunCataclysmItem.spawnGreenSpark(world, x, y, z, 1, 0.0, -0.06, 0.0, 0.0);
                    class_2338 fp = class_2338.method_49637((double)x, (double)y, (double)z);
                    class_2680 fs = world.method_8320(fp.method_10074());
                    if (fs.method_26215()) continue;
                    OrbitalRailgunCataclysmItem.spawnParticlesBudgeted(world, (class_2394)class_2398.field_28803, x, y, z, 1, 0.0, -0.02, 0.0, 0.0);
                }
                --this.debrisTicksRemaining;
            }
        }

        private void tickShockwaves(class_3218 world) {
            if (this.shockStartTick < 0) {
                return;
            }
            int ticksFromImpact = this.age - this.shockStartTick;
            if (ticksFromImpact < 0) {
                return;
            }
            double currentSec = (double)ticksFromImpact / 20.0;
            for (int w = 0; w < 3; ++w) {
                double c;
                double r;
                double t0 = this.waveOffsetsSec[w];
                double local = currentSec - t0;
                if (local < 0.0 || (r = (c = this.waveSpeeds[w]) * local) <= 0.1) continue;
                double A = Math.exp(-this.waveK[w] * local);
                double[] lats = new double[]{-1.0471975511965976, -0.5235987755982988, 0.0, 0.5235987755982988, 1.0471975511965976};
                for (double phi : lats) {
                    double ringR = r * Math.cos(phi);
                    double yOff = r * Math.sin(phi);
                    int pts = Math.max(2000, (int)(ringR * 300.0));
                    for (int i = 0; i < pts; ++i) {
                        double ang = (double)i / (double)pts * Math.PI * 2.0;
                        double px = this.center.field_1352 + ringR * Math.cos(ang);
                        double pz = this.center.field_1350 + ringR * Math.sin(ang);
                        double py = this.center.field_1351 + yOff;
                        int top = world.method_8624(class_2902.class_2903.field_13202, class_3532.method_15357((double)px), class_3532.method_15357((double)pz));
                        py = Math.max(py, (double)top + 0.5);
                        if (w == 0) {
                            if ((i & 1) == 0) {
                                OrbitalRailgunCataclysmItem.spawnGreenSpark(world, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
                            }
                            OrbitalRailgunCataclysmItem.spawnGreenSpark(world, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
                            continue;
                        }
                        if (w == 1) {
                            OrbitalRailgunCataclysmItem.spawnGreenSpark(world, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
                            if ((i & 3) != 0) continue;
                            OrbitalRailgunCataclysmItem.spawnGreenSpark(world, px, py + 0.02, pz, 1, 0.0, 0.0, 0.0, 0.0);
                            continue;
                        }
                        OrbitalRailgunCataclysmItem.spawnGreenSpark(world, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
                        if ((i & 7) != 0) continue;
                        OrbitalRailgunCataclysmItem.spawnGreenSpark(world, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                Object object = world.method_18456().iterator();
                while (object.hasNext()) {
                    class_3222 p = (class_3222)object.next();
                    double dx = p.method_23317() - this.center.field_1352;
                    double dz = p.method_23321() - this.center.field_1350;
                    double d = Math.sqrt(dx * dx + dz * dz);
                    double t_delay = d / c;
                    double window = 0.1;
                    double diff = local - t_delay;
                    if (!(diff >= 0.0) || !(diff < window)) continue;
                    float baseVol = (float)Math.max(0.1, Math.min(1.0, 4.0 / Math.max(4.0, d * d)));
                    float vol = (float)((double)baseVol * Math.max(0.2, Math.min(1.0, A)));
                    double vr_sec = p.method_18798().method_37267() * 20.0;
                    double doppler = (c + vr_sec) / c;
                    float pitch = w == 0 ? (float)(1.6 * doppler) : (w == 1 ? (float)(1.0 * doppler) : (float)(0.6 * doppler));
                    double panX = p.method_23317() - dx * 0.05;
                    double panZ = p.method_23321() - dz * 0.05;
                    if (w == 0) {
                        world.method_43128(null, panX, p.method_23318(), panZ, class_3417.field_38830, class_3419.field_15248, vol * 1.3f, pitch);
                        continue;
                    }
                    if (w == 1) {
                        world.method_43128(null, panX, p.method_23318(), panZ, class_3417.field_14865, class_3419.field_15248, vol * 1.1f, pitch * 0.85f);
                        continue;
                    }
                    world.method_60511(null, panX, p.method_23318(), panZ, (class_6880)class_3417.field_23792, class_3419.field_15248, vol, pitch * 0.7f);
                }
            }
        }

        private void soundtrackTick(class_3218 world) {
            double gs = (double)this.age / 20.0;
            if (gs >= 11.85 && gs < 12.0) {
                return;
            }
            if (gs >= 0.0 && gs < 4.0) {
                double t = gs / 4.0;
                float baseRumbleVol = (float)(0.6 + 0.4 * t);
                if (this.age % 6 == 0) {
                    OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, (class_6880<class_3414>)class_3417.field_23792, class_3419.field_15248, baseRumbleVol, 0.5f);
                }
                if (this.age % 25 == 0) {
                    OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_38068, class_3419.field_15248, 0.7f, 0.9f);
                }
                if (this.age % 10 == 0) {
                    OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_15045, class_3419.field_15248, 0.6f, (float)(0.8 + 0.1 * t));
                }
                if (this.age % 8 == 0) {
                    OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_14632, class_3419.field_15248, 0.45f, 1.5f);
                }
                if (this.age % 10 == 0) {
                    double sweep = (double)(this.age % 13) / 13.0 * (Math.PI * 2);
                    double rx = this.center.field_1352 + 30.0 * Math.cos(sweep);
                    double rz = this.center.field_1350 + 30.0 * Math.sin(sweep);
                    world.method_43128(null, rx, this.center.field_1351 + 2.0, rz, (class_3414)class_3417.field_14622.comp_349(), class_3419.field_15248, 0.9f, 2.0f);
                }
                if (this.age % 2 == 0) {
                    world.method_43128(null, this.center.field_1352, this.center.field_1351 + 2.0, this.center.field_1350, class_3417.field_26980, class_3419.field_15248, 0.2f, 2.0f);
                }
                if (this.age % 7 == 0) {
                    OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_14946, class_3419.field_15248, 0.35f, (float)(1.2 + 0.6 * t));
                }
                if (this.age % (7 + this.age % 11) == 0) {
                    world.method_43128(null, this.center.field_1352, this.center.field_1351, this.center.field_1350, class_3417.field_14833, class_3419.field_15248, 0.3f, 1.6f);
                }
                return;
            }
            if (gs >= 4.0 && gs < 12.0) {
                double t2 = gs - 4.0;
                if (t2 < 2.0) {
                    double u = t2 / 2.0;
                    if (this.age % 3 == 0) {
                        OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, (class_6880<class_3414>)class_3417.field_23792, class_3419.field_15248, 0.9f, (float)(0.4 + 0.5 * Math.pow(2.0, u)));
                    }
                    if (this.age % 6 == 0) {
                        OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_14785, class_3419.field_15248, 0.35f, 1.2f);
                    }
                    if (this.age % 5 == 0) {
                        OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_15045, class_3419.field_15248, 0.5f, 1.0f);
                    }
                    if (this.age % 4 == 0) {
                        OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_26980, class_3419.field_15248, 0.35f, 1.8f);
                    }
                } else if (t2 < 6.0) {
                    if (this.age % 2 == 0) {
                        OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, (class_6880<class_3414>)class_3417.field_23792, class_3419.field_15248, 1.0f, 0.5f);
                    }
                    if (this.age % 4 == 0) {
                        OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_38831, class_3419.field_15248, 0.8f, 0.9f);
                    }
                    if (this.age % 2 == 0) {
                        OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_14917, class_3419.field_15248, 0.2f, 2.0f);
                    }
                    if (this.age % 4 == 0) {
                        OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_15045, class_3419.field_15248, 0.8f, 0.6f);
                    }
                } else if (t2 < 7.5) {
                    if (this.age % 5 == 0) {
                        OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_38068, class_3419.field_15248, 0.9f, 0.8f);
                    }
                    if (this.age % 8 == 0) {
                        OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_14632, class_3419.field_15248, 0.5f, 0.9f);
                    }
                    if (this.age % 7 == 0) {
                        OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_14946, class_3419.field_15248, 0.2f, 1.1f);
                    }
                } else {
                    double u = (t2 - 7.5) / 4.5;
                    if (t2 < 9.0) {
                        double w = (t2 - 7.5) / 1.5;
                        w = Math.max(0.0, Math.min(1.0, w));
                        world.method_43128(null, this.center.field_1352, this.center.field_1351, this.center.field_1350, class_3417.field_14572, class_3419.field_15248, 0.9f, (float)(1.8 - 1.2 * w));
                    }
                    if (this.age % 6 == 0) {
                        OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, (class_6880<class_3414>)class_3417.field_23792, class_3419.field_15248, 0.9f, 0.4f);
                    }
                    if (this.age % 13 == 0) {
                        OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_38060, class_3419.field_15248, 0.8f, 0.7f);
                    }
                }
                return;
            }
            if (gs >= 12.0 && gs < 17.0) {
                double t3 = gs - 12.0;
                if (t3 < 2.7) {
                    if (this.age % 3 == 0) {
                        OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, (class_6880<class_3414>)class_3417.field_23792, class_3419.field_15248, 1.0f, 0.45f);
                    }
                    if (this.age % 4 == 0) {
                        OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_14946, class_3419.field_15248, 0.8f, 1.0f);
                    }
                    if (this.age % 6 == 0) {
                        OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_16865, class_3419.field_15248, 0.6f, 0.8f);
                    }
                } else if (t3 < 4.5) {
                    if (this.age % 20 == 0) {
                        OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, (class_6880<class_3414>)class_3417.field_23792, class_3419.field_15248, 0.25f, 0.5f);
                    }
                    if (this.age % 24 == 0) {
                        OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_38068, class_3419.field_15248, 0.3f, 1.0f);
                    }
                    if (this.age % 30 == 0) {
                        world.method_43128(null, this.center.field_1352, this.center.field_1351 + 8.0, this.center.field_1350, class_3417.field_15119, class_3419.field_15248, 0.05f, 2.0f);
                    }
                } else if (t3 < 4.88) {
                    double w = (t3 - 4.5) / 0.38;
                    world.method_43128(null, this.center.field_1352, this.center.field_1351, this.center.field_1350, class_3417.field_14572, class_3419.field_15248, 1.0f, (float)(0.8 + 1.2 * w));
                    if (this.age % 2 == 0) {
                        OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_14958, class_3419.field_15248, 0.6f, (float)(1.2 + 0.6 * w));
                    }
                } else if (!this.singularityPulseDone) {
                    this.singularityPulseDone = true;
                    world.method_43128(null, this.center.field_1352, this.center.field_1351, this.center.field_1350, class_3417.field_38830, class_3419.field_15248, 3.0f, 0.7f);
                }
                return;
            }
            if (gs >= 17.0 && gs < 30.0) {
                double t4 = gs - 17.0;
                if (t4 < 0.08) {
                    if (!this.detonationBangDone) {
                        this.detonationBangDone = true;
                        world.method_43128(null, this.center.field_1352, this.center.field_1351, this.center.field_1350, class_3417.field_38830, class_3419.field_15248, 4.0f, 0.6f);
                        world.method_43128(null, this.center.field_1352, this.center.field_1351, this.center.field_1350, class_3417.field_14981, class_3419.field_15248, 2.6f, 1.05f);
                        world.method_43128(null, this.center.field_1352, this.center.field_1351, this.center.field_1350, class_3417.field_14946, class_3419.field_15248, 1.2f, 1.9f);
                    }
                    return;
                }
                if (t4 < 2.0) {
                    if (this.age % 2 == 0) {
                        OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_14865, class_3419.field_15248, 1.0f, 0.8f);
                    }
                    if (this.age % 3 == 0) {
                        OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_15081, class_3419.field_15248, 0.8f, 1.8f);
                    }
                    if (this.age % 4 == 0) {
                        OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_14833, class_3419.field_15248, 0.6f, 0.9f);
                    }
                } else if (t4 < 4.0) {
                    if (this.age % 2 == 0) {
                        OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_14993, class_3419.field_15248, 1.0f, 1.1f);
                    }
                    if (this.age % 3 == 0) {
                        OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_19198, class_3419.field_15248, 0.7f, 1.6f);
                    }
                    if (this.age % 5 == 0) {
                        OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_14970, class_3419.field_15248, 0.6f, 1.3f);
                    }
                } else if (t4 < 7.0) {
                    if (this.age % 4 == 0) {
                        OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_14865, class_3419.field_15248, 0.9f, 0.7f);
                    }
                    if (this.age % 3 == 0) {
                        OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_14946, class_3419.field_15248, 0.5f, 1.35f);
                    }
                    if (this.age % 6 == 0) {
                        OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_15026, class_3419.field_15248, 0.6f, 1.1f);
                    }
                } else if (t4 < 10.0) {
                    if (this.age % 3 == 0) {
                        OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_14956, class_3419.field_15248, 0.9f, 1.2f);
                    }
                    if (this.age % 2 == 0) {
                        OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_15090, class_3419.field_15248, 0.7f, 1.8f);
                    }
                    if (this.age % 5 == 0) {
                        OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_15045, class_3419.field_15248, 0.6f, 0.9f);
                    }
                } else if (t4 < 13.0) {
                    double u = (t4 - 10.0) / 3.0;
                    float vol = (float)(1.0 - 0.8 * u);
                    OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_14946, class_3419.field_15248, 0.3f * vol, 1.1f);
                    if (this.age % 10 == 0) {
                        OrbitalRailgunCataclysmItem.playInRange(world, this.center, 400.0, class_3417.field_14865, class_3419.field_15248, 0.5f * vol, 0.9f);
                    }
                    if (this.age % 6 == 0) {
                        world.method_43128(null, this.center.field_1352, this.center.field_1351 + 20.0, this.center.field_1350, class_3417.field_15119, class_3419.field_15248, 0.05f * vol, 2.0f);
                    }
                }
            }
        }

        private void spawnFibonacciShells(class_3218 world, double r, int rhoPerM2) {
            if (r <= 0.1) {
                return;
            }
            int Nbase = (int)Math.ceil(Math.PI * 4 * r * r * (double)rhoPerM2);
            double golden = Math.PI * (3.0 - Math.sqrt(5.0));
            for (int i = 0; i < Nbase; ++i) {
                double y = 1.0 - 2.0 * (double)i / Math.max(1.0, (double)(Nbase - 1));
                double rad = Math.sqrt(Math.max(0.0, 1.0 - y * y));
                double theta = golden * (double)i;
                double x = Math.cos(theta) * rad * r;
                double z = Math.sin(theta) * rad * r;
                double yy = y * r;
                if ((i & 1) == 0) {
                    OrbitalRailgunCataclysmItem.spawnType(world, (class_2394)class_2398.field_28478, this.center.field_1352 + x, this.center.field_1351 + yy, this.center.field_1350 + z, 1, 0.0, 0.0, 0.0, 0.0);
                    continue;
                }
                OrbitalRailgunCataclysmItem.spawnType(world, (class_2394)class_2398.field_11211, this.center.field_1352 + x, this.center.field_1351 + yy, this.center.field_1350 + z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }

        private void spawnFibonacciShellNatural(class_3218 world, double r, int rhoPerM2, class_2394 type) {
            if (r <= 0.1) {
                return;
            }
            int Nbase = (int)Math.ceil(Math.PI * 4 * r * r * (double)rhoPerM2);
            double golden = Math.PI * (3.0 - Math.sqrt(5.0));
            for (int i = 0; i < Nbase; ++i) {
                double y = 1.0 - 2.0 * (double)i / Math.max(1.0, (double)(Nbase - 1));
                double rad = Math.sqrt(Math.max(0.0, 1.0 - y * y));
                double theta = golden * (double)i;
                double x = Math.cos(theta) * rad * r;
                double z = Math.sin(theta) * rad * r;
                double yy = y * r;
                OrbitalRailgunCataclysmItem.spawnType(world, type, this.center.field_1352 + x, this.center.field_1351 + yy, this.center.field_1350 + z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }

        private void fibonacciLayer(class_3218 world, class_2394 particle, double radius, int n) {
            for (int i = 0; i < n; ++i) {
                double u = ((double)i + 0.5) / (double)n;
                double phi = Math.acos(1.0 - 2.0 * u);
                double theta = Math.PI * (1.0 + Math.sqrt(5.0)) * (double)i;
                double nx = Math.sin(phi) * Math.cos(theta);
                double ny = Math.cos(phi);
                double nz = Math.sin(phi) * Math.sin(theta);
                double x = this.center.field_1352 + radius * nx;
                double y = this.center.field_1351 + radius * ny;
                double z = this.center.field_1350 + radius * nz;
                OrbitalRailgunCataclysmItem.spawnParticlesBudgeted(world, particle, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }

        private void applyImpactCrater(class_3218 world, class_2338 center) {
            OrbitalRailgunCataclysmItem.applyImpactCrater(world, center);
        }
    }
}

