/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore;

import dev.tazer.clutternomore.CNMConfig;
import dev.tazer.clutternomore.Platform;
import dev.tazer.clutternomore.client.assets.AssetGenerator;
import dev.tazer.clutternomore.client.assets.StepGenerator;
import dev.tazer.clutternomore.client.assets.VerticalSlabGenerator;
import dev.tazer.clutternomore.common.blocks.StepBlock;
import dev.tazer.clutternomore.common.blocks.VerticalSlabBlock;
import dev.tazer.clutternomore.common.blocks.WeatheringStepBlock;
import dev.tazer.clutternomore.common.blocks.WeatheringVerticalSlabBlock;
import dev.tazer.clutternomore.common.data.CNMPackResources;
import dev.tazer.clutternomore.common.data.DataGenerator;
import dev.tazer.clutternomore.common.mixin.access.BlockBehaviorAccessor;
import dev.tazer.clutternomore.common.registry.CBlocks;
import dev.tazer.clutternomore.common.shape_map.ShapeMap;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WeatheringCopperSlabBlock;
import net.minecraft.world.level.block.WeatheringCopperStairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.registries.RegistryManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClutterNoMore {
    public static final String MODID = "clutternomore";
    public static final Logger LOGGER = LogManager.getLogger((String)"ClutterNoMore");
    public static final CNMConfig.StartupConfig STARTUP_CONFIG = (CNMConfig.StartupConfig)CNMConfig.StartupConfig.createToml((Path)Platform.INSTANCE.configPath(), (String)"clutternomore", (String)"startup", CNMConfig.StartupConfig.class);
    private static final String PACK_INFO = "clutternomore-runtime";
    public static final CNMPackResources RESOURCES = new CNMPackResources("clutternomore-runtime");
    public static LinkedHashMap<ResourceLocation, ResourceLocation> COPPER_BLOCKS = new LinkedHashMap();
    public static ArrayList<ResourceLocation> WAXED_COPPER_BLOCKS = new ArrayList();
    public static final Path pack = Platform.INSTANCE.getResourcePack().resolve("clutternomore");

    public static void init() {
        LOGGER.info("Initializing {} on {}", (Object)MODID, (Object)Platform.INSTANCE.loader());
    }

    public static Pack createPack(PackType type) {
        return Pack.m_245429_((String)PACK_INFO, (Component)Component.m_237113_((String)"ClutterNoMore"), (boolean)true, (Pack.ResourcesSupplier)new PackResourcesSupplier(), (PackType)type, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10528_);
    }

    public static ResourceLocation location(String path) {
        return ClutterNoMore.location(MODID, path);
    }

    public static ResourceLocation location(String namespace, String path) {
        return new ResourceLocation(namespace, path);
    }

    public static ResourceLocation parse(String id) {
        return new ResourceLocation(id);
    }

    public static void modifyRecipes(RegistryAccess registries, RecipeManager recipeManager) {
        boolean changed = false;
        Collection originalRecipes = recipeManager.m_44051_();
        ArrayList<Recipe> newRecipes = new ArrayList<Recipe>();
        for (Recipe recipe : originalRecipes) {
            Item result = recipe.m_8043_(registries).m_41720_();
            if (ShapeMap.isShape(result)) continue;
            NonNullList ingredients = recipe.m_7527_();
            for (Ingredient ingredient : new ArrayList(ingredients)) {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (ItemStack stack : ingredient.m_43908_()) {
                    Item item = stack.m_41720_();
                    if (ShapeMap.isShape(item)) {
                        ItemStack originalStack = ShapeMap.getParent(item).m_7968_();
                        originalStack.m_41764_(stack.m_41613_());
                        stacks.add(originalStack);
                        changed = true;
                        continue;
                    }
                    stacks.add(stack);
                }
                Stream newStacks = stacks.stream();
                if (!changed) continue;
                try {
                    int index = ingredients.indexOf((Object)ingredient);
                    ingredients.set(index, (Object)Ingredient.m_43921_(newStacks));
                }
                catch (Exception exception) {}
            }
            newRecipes.add(recipe);
        }
        if (changed) {
            recipeManager.m_44024_(newRecipes);
        }
    }

    public static void registerVariants() {
        RegistryManager.ACTIVE.getRegistry(BuiltInRegistries.f_256975_.m_123023_()).unfreeze();
        RegistryManager.ACTIVE.getRegistry(BuiltInRegistries.f_257033_.m_123023_()).unfreeze();
        if (((Boolean)ClutterNoMore.STARTUP_CONFIG.VERTICAL_SLABS.value()).booleanValue() || ((Boolean)ClutterNoMore.STARTUP_CONFIG.STEPS.value()).booleanValue()) {
            LinkedHashMap<Object, Supplier> toRegister = new LinkedHashMap<Object, Supplier>();
            ArrayList<ResourceLocation> slabs = new ArrayList<ResourceLocation>();
            ArrayList<ResourceLocation> stairs = new ArrayList<ResourceLocation>();
            List<SoundType> woodenSoundTypes = List.of(SoundType.f_56736_, SoundType.f_243772_, SoundType.f_271497_, SoundType.f_244244_);
            List<SoundType> shovelSoundTypes = List.of(SoundType.f_56739_, SoundType.f_56740_);
            for (Map.Entry resourceKeyItemEntry : BuiltInRegistries.f_257033_.m_6579_()) {
                StairBlock stairBlock;
                SoundType soundType;
                ResourceLocation shapeId;
                Supplier<Block> block;
                String path;
                Object shortPath;
                SlabBlock slabBlock;
                Block block2;
                Item item = ((Item)resourceKeyItemEntry.getValue()).m_5456_();
                if (!(item instanceof BlockItem)) continue;
                BlockItem blockItem = (BlockItem)item;
                ResourceLocation blockId = ((ResourceKey)resourceKeyItemEntry.getKey()).m_135782_();
                Object blockNamespace = blockId.m_135827_() + "/";
                if (blockId.m_135827_().equals("minecraft")) {
                    blockNamespace = "";
                }
                if ((block2 = blockItem.m_40614_()) instanceof SlabBlock && (slabBlock = (SlabBlock)block2).m_49966_().m_61148_().size() == 2 && ((Boolean)ClutterNoMore.STARTUP_CONFIG.VERTICAL_SLABS.value()).booleanValue()) {
                    shortPath = "vertical_" + blockId.m_135815_();
                    path = (String)blockNamespace + (String)shortPath;
                    if (slabBlock instanceof WeatheringCopperSlabBlock) {
                        WeatheringCopperSlabBlock weatheringSlabBlock = (WeatheringCopperSlabBlock)slabBlock;
                        block = () -> new WeatheringVerticalSlabBlock(ClutterNoMore.copy((Block)slabBlock), weatheringSlabBlock.m_142297_());
                        toRegister.put(path, block);
                        ClutterNoMore.matchCopperBlock(ClutterNoMore.location(path));
                    } else {
                        toRegister.put(path, () -> new VerticalSlabBlock(ClutterNoMore.copy((Block)slabBlock)));
                        if (path.contains("waxed")) {
                            WAXED_COPPER_BLOCKS.add(ClutterNoMore.location(path));
                        }
                    }
                    slabs.add(blockId);
                    shapeId = ClutterNoMore.location(path);
                    DataGenerator.addLootTable(blockId, shapeId);
                    soundType = ((BlockBehaviorAccessor)slabBlock).getSoundType();
                    if (woodenSoundTypes.contains(soundType)) {
                        DataGenerator.woodenVerticalSlabsArray.add(ClutterNoMore.location(path).toString());
                    } else {
                        DataGenerator.addToTag(path, DataGenerator.verticalSlabsArray);
                        if (shovelSoundTypes.contains(soundType)) {
                            DataGenerator.addToTag(path, DataGenerator.shovelMineableArray);
                        } else {
                            DataGenerator.addToTag(path, DataGenerator.pickaxeMineableArray);
                        }
                    }
                }
                if (!((shortPath = blockItem.m_40614_()) instanceof StairBlock) || (stairBlock = (StairBlock)shortPath).m_49966_().m_61148_().size() != 4 || !((Boolean)ClutterNoMore.STARTUP_CONFIG.STEPS.value()).booleanValue()) continue;
                shortPath = blockId.m_135815_().replace("stairs", "step");
                path = (String)blockNamespace + (String)shortPath;
                if (stairBlock instanceof WeatheringCopperStairBlock) {
                    WeatheringCopperStairBlock weatheringCopperStairBlock = (WeatheringCopperStairBlock)stairBlock;
                    block = () -> new WeatheringStepBlock(ClutterNoMore.copy((Block)stairBlock), weatheringCopperStairBlock.m_142297_());
                    toRegister.put(path, block);
                    ClutterNoMore.matchCopperBlock(ClutterNoMore.location(path));
                } else {
                    toRegister.put(path, () -> new StepBlock(ClutterNoMore.copy((Block)stairBlock)));
                    if (path.contains("waxed")) {
                        WAXED_COPPER_BLOCKS.add(ClutterNoMore.location(path));
                    }
                }
                stairs.add(blockId);
                shapeId = ClutterNoMore.location(path);
                DataGenerator.addLootTable(blockId, shapeId);
                soundType = ((BlockBehaviorAccessor)stairBlock).getSoundType();
                if (woodenSoundTypes.contains(soundType)) {
                    DataGenerator.addToTag(shapeId, DataGenerator.woodenStepsArray);
                    continue;
                }
                DataGenerator.addToTag(shapeId, DataGenerator.stepsArray);
                if (shovelSoundTypes.contains(soundType)) {
                    DataGenerator.addToTag(path, DataGenerator.shovelMineableArray);
                    continue;
                }
                DataGenerator.addToTag(path, DataGenerator.pickaxeMineableArray);
            }
            toRegister.forEach(CBlocks::register);
            AssetGenerator.keys = toRegister.keySet();
            VerticalSlabGenerator.SLABS = slabs;
            StepGenerator.STAIRS = stairs;
            DataGenerator.generate();
            Platform.INSTANCE.finalizeCopperBlockRegistration();
        }
    }

    private static void matchCopperBlock(ResourceLocation id) {
        if (id.m_135815_().contains("oxidized")) {
            ResourceLocation weatheredPath = ClutterNoMore.location(id.m_135827_(), id.m_135815_().replace("oxidized", "weathered"));
            COPPER_BLOCKS.put(weatheredPath, id);
        }
        if (id.m_135815_().contains("weathered")) {
            ResourceLocation exposed = ClutterNoMore.location(id.m_135827_(), id.m_135815_().replace("weathered", "exposed"));
            COPPER_BLOCKS.put(exposed, id);
        }
        if (id.m_135815_().contains("exposed")) {
            ResourceLocation unaffected = ClutterNoMore.location(id.m_135827_(), id.m_135815_().replace("exposed_", ""));
            COPPER_BLOCKS.put(unaffected, id);
        }
    }

    public static void writeFile(Path path, Path filePath, String contents) {
        try {
            path.toFile().mkdirs();
            FileWriter langWriter = new FileWriter(filePath.toFile());
            langWriter.write(contents);
            langWriter.close();
            LOGGER.debug("Successfully wrote to {}", (Object)filePath);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write dynamic data. %s".formatted(e));
        }
    }

    public static BlockBehaviour.Properties copy(Block block) {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)block);
    }

    private static class PackResourcesSupplier
    implements Pack.ResourcesSupplier {
        private PackResourcesSupplier() {
        }

        public PackResources m_247679_(String s) {
            return RESOURCES;
        }
    }
}

