/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.client;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tazer.clutternomore.ClutterNoMore;
import dev.tazer.clutternomore.ClutterNoMoreClient;
import dev.tazer.clutternomore.common.shape_map.ShapeMap;
import dev.tazer.clutternomore.forge.networking.ChangeStackPacket;
import dev.tazer.clutternomore.forge.networking.ForgeNetworking;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ShapeSwitcherOverlay {
    public final Minecraft minecraft;
    public final boolean render;
    public final int selected;
    public int count;
    public final List<Item> shapes;
    public int selectedIndex;
    public float currentIndex;

    public ShapeSwitcherOverlay(Minecraft minecraft, ItemStack heldStack, boolean render) {
        this.minecraft = minecraft;
        this.render = render;
        this.selected = minecraft.f_91074_.m_150109_().f_35977_;
        Item item = ShapeMap.getParent(heldStack.m_41720_());
        this.count = heldStack.m_41613_();
        this.shapes = new ArrayList<Item>(ShapeMap.getShapes(item));
        this.shapes.add(0, item);
        this.selectedIndex = this.shapes.indexOf(heldStack.m_41720_());
        this.currentIndex = this.selectedIndex;
    }

    public void render(GuiGraphics guiGraphics, float partialTick) {
        ResourceLocation background = ClutterNoMore.location("textures/gui/shape_background.png");
        ResourceLocation selected = ClutterNoMore.location("textures/gui/selected_shape.png");
        int y = guiGraphics.m_280206_() / 2 + 20;
        int centreX = guiGraphics.m_280182_() / 2 - 8;
        int spacing = 22;
        float smoothing = 1.0f - (float)Math.exp(-5.0f * partialTick);
        this.currentIndex = Mth.m_14179_((float)smoothing, (float)this.currentIndex, (float)this.selectedIndex);
        if (((Boolean)ClutterNoMoreClient.CLIENT_CONFIG.SCROLLING.value()).booleanValue()) {
            int startX = Mth.m_14143_((float)((float)centreX - this.currentIndex * (float)spacing));
            RenderSystem.enableBlend();
            guiGraphics.m_280163_(selected, centreX - 3, y - 3, 0.0f, 0.0f, 22, 22, 22, 22);
            for (int index = 0; index < this.shapes.size(); ++index) {
                int x = startX + index * spacing;
                RenderSystem.enableBlend();
                guiGraphics.m_280163_(background, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
                guiGraphics.m_280480_(this.shapes.get(index).m_7968_(), x, y);
            }
        } else {
            int startX = Mth.m_14143_((float)((float)centreX - (float)this.shapes.size() / 2.0f * (float)spacing)) + spacing / 2;
            for (int index = 0; index < this.shapes.size(); ++index) {
                int x = startX + index * spacing;
                RenderSystem.enableBlend();
                guiGraphics.m_280163_(background, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
                guiGraphics.m_280480_(this.shapes.get(index).m_7968_(), x, y);
            }
            RenderSystem.enableBlend();
            guiGraphics.m_280163_(selected, Mth.m_14143_((float)((float)startX + this.currentIndex * (float)spacing)) - 3, y - 3, 0.0f, 0.0f, 22, 22, 22, 22);
        }
        RenderSystem.disableBlend();
    }

    public void onMouseScrolled(int direction) {
        this.changeSlot(this.selectedIndex - direction);
    }

    public void changeSlot(int newIndex) {
        int maxIndex = this.shapes.size() - 1;
        this.selectedIndex = newIndex;
        if (((Boolean)ClutterNoMoreClient.CLIENT_CONFIG.WRAP_SCROLLING.value()).booleanValue()) {
            if (this.selectedIndex < 0) {
                this.selectedIndex = maxIndex;
            }
            if (this.selectedIndex > maxIndex) {
                this.selectedIndex = 0;
            }
        } else {
            if (this.selectedIndex < 0) {
                this.selectedIndex = 0;
            }
            if (this.selectedIndex > maxIndex) {
                this.selectedIndex = maxIndex;
            }
        }
        Item nextItem = this.shapes.get(this.selectedIndex);
        ItemStack next = nextItem.m_7968_();
        next.m_41764_(this.count);
        Player player = (Player)Objects.requireNonNull(this.minecraft.f_91074_);
        player.m_5496_((SoundEvent)SoundEvents.f_12490_.m_203334_(), 0.3f, 1.5f);
        player.m_21008_(InteractionHand.MAIN_HAND, next);
        ForgeNetworking.sendToServer(new ChangeStackPacket(-1, -1, next));
    }

    public boolean shouldStayOpenThisTick() {
        int selected = this.minecraft.f_91074_.m_150109_().f_35977_;
        ItemStack heldStack = this.minecraft.f_91074_.m_21120_(InteractionHand.MAIN_HAND);
        this.count = heldStack.m_41613_();
        return this.shapes.contains(heldStack.m_41720_()) && selected == this.selected;
    }
}

