/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.forge;

import dev.tazer.clutternomore.ClutterNoMore;
import dev.tazer.clutternomore.ClutterNoMoreClient;
import dev.tazer.clutternomore.client.ClientShapeTooltip;
import dev.tazer.clutternomore.common.networking.ShapeTooltip;
import dev.tazer.clutternomore.common.shape_map.ShapeMap;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="clutternomore", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeClientEvents {
    public static final Lazy<KeyMapping> SHAPE_KEY = Lazy.of(() -> new KeyMapping("key.clutternomore.change_block_shape", 342, "key.categories.inventory"));

    @SubscribeEvent
    public static void onItemTooltips(ItemTooltipEvent event) {
        ClutterNoMoreClient.onItemTooltips(event.getItemStack(), null, event.getFlags(), event.getToolTip());
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        ClutterNoMoreClient.onKeyInput(event.getKey(), event.getAction());
    }

    @SubscribeEvent
    public static void onKeyInputPost(InputEvent.MouseButton.Post event) {
        ClutterNoMoreClient.onKeyInput(event.getButton(), event.getAction());
    }

    @SubscribeEvent
    public static void onMouseScrolling(InputEvent.MouseScrollingEvent event) {
        event.setCanceled(ClutterNoMoreClient.onMouseScrolling(event.getScrollDelta()));
    }

    @SubscribeEvent
    public static void onScreenScroll(ScreenEvent.MouseScrolled.Post event) {
        Screen screen;
        if (ClutterNoMoreClient.showTooltip && (screen = event.getScreen()) instanceof AbstractContainerScreen) {
            ItemStack heldStack;
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            Slot slot = screen2.getSlotUnderMouse();
            LocalPlayer player = screen2.getMinecraft().f_91074_;
            if (slot != null && slot.m_150651_((Player)player) && ShapeMap.contains((heldStack = slot.m_7993_()).m_41720_())) {
                ClutterNoMoreClient.switchShapeInSlot((Player)player, screen2.m_6262_().f_38840_, slot.getSlotIndex(), heldStack, (int)event.getScrollDelta());
            }
        }
    }

    @SubscribeEvent
    public static void onScreenKeyPressedPost(ScreenEvent.KeyPressed.Post event) {
        ClutterNoMoreClient.onKeyPress(event.getScreen(), event.getKeyCode());
    }

    @SubscribeEvent
    public static void onScreenMouseButtonPressedPost(ScreenEvent.MouseButtonPressed.Post event) {
        ClutterNoMoreClient.onKeyPress(event.getScreen(), event.getButton());
    }

    @SubscribeEvent
    public static void onScreenKeyReleasedPost(ScreenEvent.KeyReleased.Post event) {
        ClutterNoMoreClient.onKeyReleased(event.getKeyCode());
    }

    @SubscribeEvent
    public static void onScreenMouseButtonReleasedPost(ScreenEvent.MouseButtonReleased.Post event) {
        ClutterNoMoreClient.onKeyReleased(event.getButton());
    }

    @SubscribeEvent
    public static void onRenderGui(RenderGuiEvent.Post event) {
        if (ClutterNoMoreClient.OVERLAY != null && ClutterNoMoreClient.OVERLAY.render) {
            ClutterNoMoreClient.OVERLAY.render(event.getGuiGraphics(), event.getPartialTick());
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ClutterNoMoreClient.onPlayerTick(Minecraft.m_91087_());
    }

    @Mod.EventBusSubscriber(modid="clutternomore", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEventBus {
        @SubscribeEvent
        public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
            event.register((KeyMapping)SHAPE_KEY.get());
        }

        @SubscribeEvent
        public static void registerTooltipComponent(RegisterClientTooltipComponentFactoriesEvent event) {
            ClutterNoMore.LOGGER.info("Registering tooltip component factory");
            event.register(ShapeTooltip.class, ClientShapeTooltip::new);
        }

        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
            ClutterNoMoreClient.clientStarted(Minecraft.m_91087_());
        }
    }
}

