/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.forge.networking;

import dev.tazer.clutternomore.common.shape_map.ShapeMap;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public record ChangeStackPacket(int containerId, int slot, ItemStack stack) {
    public static void encode(ChangeStackPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.containerId);
        buf.writeInt(packet.slot);
        buf.m_130055_(packet.stack);
    }

    public static ChangeStackPacket decode(FriendlyByteBuf buf) {
        return new ChangeStackPacket(buf.readInt(), buf.readInt(), buf.m_130267_());
    }

    public static void handle(ChangeStackPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null && ShapeMap.contains(packet.stack.m_41720_())) {
                Item main = ShapeMap.getParent(packet.stack.m_41720_());
                if (packet.slot == -1) {
                    Item item = player.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
                    if (ShapeMap.isParentOfShape(main, item)) {
                        player.m_21008_(InteractionHand.MAIN_HAND, packet.stack);
                    }
                } else {
                    InventoryMenu inventory = player.f_36095_;
                    Slot slot = inventory.m_38853_(packet.slot);
                    Item item = slot.m_7993_().m_41720_();
                    if (ShapeMap.isParentOfShape(main, item)) {
                        slot.m_269060_(packet.stack);
                        inventory.m_150429_();
                    }
                }
            }
        });
        context.setPacketHandled(true);
    }
}

