/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.forge.networking;

import dev.tazer.clutternomore.ClutterNoMore;
import dev.tazer.clutternomore.common.shape_map.ShapeMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public record ShapeMapPacket(Map<ItemStack, List<ItemStack>> shapes, Map<ItemStack, ItemStack> inverseShapes) {
    public static void encode(ShapeMapPacket packet, FriendlyByteBuf buf) {
        buf.m_236831_(packet.shapes, FriendlyByteBuf::m_130055_, (friendlyByteBuf, itemStacks) -> friendlyByteBuf.m_236828_((Collection)itemStacks, FriendlyByteBuf::m_130055_));
        buf.m_236831_(packet.inverseShapes, FriendlyByteBuf::m_130055_, FriendlyByteBuf::m_130055_);
    }

    public static ShapeMapPacket decode(FriendlyByteBuf buf) {
        return new ShapeMapPacket(buf.m_236847_(FriendlyByteBuf::m_130267_, friendlyByteBuf -> friendlyByteBuf.m_236845_(FriendlyByteBuf::m_130267_)), buf.m_236847_(FriendlyByteBuf::m_130267_, FriendlyByteBuf::m_130267_));
    }

    public static void handle(ShapeMapPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        ClutterNoMore.LOGGER.info("Recieved shape map!");
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            HashMap<Item, List<Item>> SHAPES_DATAMAP = new HashMap<Item, List<Item>>();
            packet.shapes.forEach((item, items) -> {
                ArrayList objects = new ArrayList();
                items.forEach(stack -> objects.add(stack.m_41720_()));
                SHAPES_DATAMAP.put(item.m_41720_(), objects);
            });
            HashMap<Item, Item> INVERSE_SHAPES_DATAMAP = new HashMap<Item, Item>();
            packet.inverseShapes.forEach((item, items) -> INVERSE_SHAPES_DATAMAP.put(item.m_41720_(), items.m_41720_()));
            ShapeMap.setShapeMaps(SHAPES_DATAMAP, INVERSE_SHAPES_DATAMAP);
        }));
        context.setPacketHandled(true);
    }
}

