/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part.aspect;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.cyclopscore.helper.CyclopsCoreInstance;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.advancement.criterion.ValuePredicate;
import org.cyclops.integrateddynamics.api.advancement.criterion.VariableFacadePredicate;
import org.cyclops.integrateddynamics.api.advancement.criterion.VariablePredicate;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.item.IAspectVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectRead;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectRegistry;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectVariable;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectWrite;
import org.cyclops.integrateddynamics.core.item.AspectVariableFacade;
import org.cyclops.integrateddynamics.core.part.aspect.AspectRegistryClient;

public final class AspectRegistry
implements IAspectRegistry {
    private static AspectRegistry INSTANCE = new AspectRegistry();
    private static final IAspectVariableFacade INVALID_FACADE = new AspectVariableFacade(false, -1, null);
    private final Map<IPartType, Set<IAspect<?, ?>>> partAspects = new IdentityHashMap();
    private final Map<IPartType, Set<IAspectRead<?, ?>>> partReadAspects = new IdentityHashMap();
    private final Map<IPartType, Set<IAspectWrite<?, ?>>> partWriteAspects = new IdentityHashMap();
    private final Map<IPartType, List<IAspectRead<?, ?>>> partReadAspectsListTransform = new IdentityHashMap();
    private final Map<IPartType, List<IAspectWrite<?, ?>>> partWriteAspectsListTransform = new IdentityHashMap();
    private final Map<String, IAspect<?, ?>> unlocalizedAspects = Maps.newHashMap();
    private final Map<String, IAspectRead<?, ?>> unlocalizedReadAspects = Maps.newHashMap();
    private final Map<String, IAspectWrite<?, ?>> unlocalizedWriteAspects = Maps.newHashMap();
    private AspectRegistryClient client;

    private AspectRegistry() {
        ((IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class)).registerHandler(this);
        if ((CyclopsCoreInstance.MOD != null ? CyclopsCoreInstance.MOD : IntegratedDynamics._instance).getModHelpers().getMinecraftHelpers().isClientSide()) {
            this.client = new AspectRegistryClient();
        }
    }

    public static AspectRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public AspectRegistryClient getClient() {
        return this.client;
    }

    @Override
    public IAspect register(IPartType partType, IAspect aspect) {
        this.registerSubAspectType(partType, aspect, this.partAspects, this.unlocalizedAspects);
        if (aspect instanceof IAspectRead) {
            this.registerSubAspectType(partType, (IAspectRead)aspect, this.partReadAspects, this.unlocalizedReadAspects);
            this.partReadAspectsListTransform.put(partType, Lists.newArrayList((Iterable)this.partReadAspects.get(partType)));
        }
        if (aspect instanceof IAspectWrite) {
            this.registerSubAspectType(partType, (IAspectWrite)aspect, this.partWriteAspects, this.unlocalizedWriteAspects);
            this.partWriteAspectsListTransform.put(partType, Lists.newArrayList((Iterable)this.partWriteAspects.get(partType)));
        }
        return aspect;
    }

    protected <T extends IAspect<?, ?>> void registerSubAspectType(IPartType partType, T aspect, Map<IPartType, Set<T>> partAspects, Map<String, T> unlocalizedAspects) {
        LinkedHashSet aspects = partAspects.get(partType);
        if (aspects == null) {
            aspects = Sets.newLinkedHashSet();
            partAspects.put(partType, aspects);
        }
        aspects.add(aspect);
        unlocalizedAspects.put(aspect.getUniqueName().toString(), aspect);
    }

    @Override
    public void register(IPartType partType, Collection<IAspect> aspects) {
        for (IAspect aspect : aspects) {
            this.register(partType, aspect);
        }
    }

    @Override
    public Set<IAspect> getAspects(IPartType partType) {
        Set<IAspect<?, ?>> aspects = this.partAspects.get(partType);
        if (aspects == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(aspects);
    }

    @Override
    public List<IAspectRead<?, ?>> getReadAspects(IPartType partType) {
        List<IAspectRead<?, ?>> aspects = this.partReadAspectsListTransform.get(partType);
        if (aspects == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(aspects);
    }

    @Override
    public List<IAspectWrite<?, ?>> getWriteAspects(IPartType partType) {
        List<IAspectWrite<?, ?>> aspects = this.partWriteAspectsListTransform.get(partType);
        if (aspects == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(aspects);
    }

    @Override
    public Set<IAspect> getAspects() {
        return ImmutableSet.copyOf(this.unlocalizedAspects.values());
    }

    @Override
    public Set<IAspectRead> getReadAspects() {
        return ImmutableSet.copyOf(this.unlocalizedReadAspects.values());
    }

    @Override
    public Set<IAspectWrite> getWriteAspects() {
        return ImmutableSet.copyOf(this.unlocalizedWriteAspects.values());
    }

    @Override
    public IAspect getAspect(ResourceLocation name) {
        return this.unlocalizedAspects.get(name.toString());
    }

    @Override
    public ResourceLocation getUniqueName() {
        return ResourceLocation.fromNamespaceAndPath((String)"integrateddynamics", (String)"aspect");
    }

    @Override
    public IAspectVariableFacade getVariableFacade(ValueDeseralizationContext valueDeseralizationContext, int id, CompoundTag tag) {
        if (!tag.contains("partId") && !tag.contains("partId") || !tag.contains("aspectName")) {
            return INVALID_FACADE;
        }
        int partId = (Integer)tag.getInt("partId").orElseThrow();
        IAspect aspect = this.getAspect(ResourceLocation.parse((String)((String)tag.getString("aspectName").orElseThrow())));
        if (aspect == null) {
            return INVALID_FACADE;
        }
        return new AspectVariableFacade(id, partId, aspect);
    }

    @Override
    public void setVariableFacade(ValueDeseralizationContext valueDeseralizationContext, CompoundTag tag, IAspectVariableFacade variableFacade) {
        tag.putInt("partId", variableFacade.getPartId());
        tag.putString("aspectName", variableFacade.getAspect().getUniqueName().toString());
    }

    @Override
    public boolean isInstance(IVariableFacade variableFacade) {
        return variableFacade instanceof IAspectVariableFacade;
    }

    @Override
    public boolean isInstance(IVariable<?> variable) {
        return variable instanceof IAspectVariable;
    }

    public static class AspectVariableFacadePredicate
    extends VariableFacadePredicate<IAspectVariableFacade> {
        private final Optional<IAspect> aspect;

        public AspectVariableFacadePredicate(Optional<IAspect> aspect) {
            super(IAspectVariableFacade.class);
            this.aspect = aspect;
        }

        public Optional<IAspect> getAspect() {
            return this.aspect;
        }

        @Override
        protected boolean testTyped(IAspectVariableFacade variableFacade) {
            return super.testTyped(variableFacade) && (this.aspect.isEmpty() || variableFacade.getAspect() == this.aspect.get());
        }
    }

    public static class AspectVariablePredicate
    extends VariablePredicate<IAspectVariable> {
        private final Optional<IAspect> aspect;

        public AspectVariablePredicate(Optional<IValueType> valueType, Optional<ValuePredicate> valuePredicate, Optional<IAspect> aspect) {
            super(IAspectVariable.class, valueType, valuePredicate);
            this.aspect = aspect;
        }

        public Optional<IAspect> getAspect() {
            return this.aspect;
        }

        @Override
        protected boolean testTyped(IAspectVariable variable) {
            return super.testTyped(variable) && (this.aspect.isEmpty() || variable.getAspect() == this.aspect.get());
        }
    }
}

