/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.network.packet;

import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.TeleportTransition;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;

public class PlayerTeleportPacket
extends PacketCodec {
    public static final CustomPacketPayload.Type<PlayerTeleportPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"integrateddynamics", (String)"player_teleport"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PlayerTeleportPacket> CODEC = PlayerTeleportPacket.getCodec(PlayerTeleportPacket::new);
    @CodecField
    private String dimension;
    @CodecField
    private double x;
    @CodecField
    private double y;
    @CodecField
    private double z;
    @CodecField
    private float yaw;
    @CodecField
    private float pitch;

    public PlayerTeleportPacket() {
        super(ID);
    }

    public PlayerTeleportPacket(ResourceKey<Level> dimension, double x, double y, double z, float yaw, float pitch) {
        super(ID);
        this.dimension = dimension.location().toString();
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public boolean isAsync() {
        return false;
    }

    public void actionClient(Level world, Player player) {
    }

    public void actionServer(Level world, ServerPlayer player) {
        ResourceKey dimensionType = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)this.dimension));
        if (!dimensionType.location().equals((Object)player.level().dimension().location())) {
            player.teleport(new TeleportTransition(ServerLifecycleHooks.getCurrentServer().getLevel(dimensionType), (Entity)player, TeleportTransition.DO_NOTHING));
        }
        player.connection.teleport(this.x + 0.5, this.y + 0.5, this.z + 0.5, this.yaw, this.pitch);
    }
}

