/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.part;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.cyclopscore.persist.world.GlobalCounters;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartRenderPosition;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.path.ISidedPathElement;
import org.cyclops.integrateddynamics.capability.path.SidedPathElement;
import org.cyclops.integrateddynamics.core.block.IgnoredBlock;
import org.cyclops.integrateddynamics.core.block.IgnoredBlockStatus;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.part.PartTypes;
import org.cyclops.integrateddynamics.part.PartTypeConnector;

public class PartTypeConnectorOmniDirectional
extends PartTypeConnector<PartTypeConnectorOmniDirectional, State> {
    public static LoadedGroups LOADED_GROUPS = new LoadedGroups();

    public PartTypeConnectorOmniDirectional(String name) {
        super(name, new PartRenderPosition(0.25f, 0.3125f, 0.625f, 0.625f));
    }

    @Override
    public int getConsumptionRate(State state) {
        return GeneralConfig.connectorOmniDirectionalBaseConsumption;
    }

    @Override
    public State constructDefaultState() {
        return new State();
    }

    @Override
    public ItemStack getItemStack(ValueDeseralizationContext valueDeseralizationContext, ProblemReporter.PathElement problemPath, State state, boolean saveState) {
        ItemStack itemStack = super.getItemStack(valueDeseralizationContext, problemPath, state, saveState);
        if (state.hasConnectorId()) {
            itemStack.set(RegistryEntries.DATACOMPONENT_OMNIDIRECTIONAL_GROUP, (Object)state.getGroupId());
        }
        return itemStack;
    }

    @Override
    public State getState(ValueDeseralizationContext valueDeseralizationContext, ProblemReporter.PathElement problemPath, ItemStack itemStack) {
        State state = (State)super.getState(valueDeseralizationContext, problemPath, itemStack);
        if (itemStack.has(RegistryEntries.DATACOMPONENT_OMNIDIRECTIONAL_GROUP)) {
            state.setGroupId((Integer)itemStack.get(RegistryEntries.DATACOMPONENT_OMNIDIRECTIONAL_GROUP));
        } else {
            state.setGroupId(PartTypeConnectorOmniDirectional.generateGroupId());
        }
        return state;
    }

    @Override
    public void onNetworkAddition(INetwork network, IPartNetwork partNetwork, PartTarget target, State state) {
        super.onNetworkAddition(network, partNetwork, target, state);
        this.addPosition(network, state, target.getCenter());
    }

    @Override
    public void onPostRemoved(INetwork network, IPartNetwork partNetwork, PartTarget target, State state) {
        super.onPostRemoved(network, partNetwork, target, state);
        this.removePosition(network, state, target.getCenter());
    }

    protected void addPosition(INetwork network, State state, PartPos pos) {
        if (!LOADED_GROUPS.isModifyingPositions() && !state.isAddedToGroup()) {
            state.setAddedToGroup(true);
            LOADED_GROUPS.addPosition(state.getGroupId(), pos, network.isInitialized());
        }
    }

    protected void removePosition(INetwork network, State state, PartPos pos) {
        if (!LOADED_GROUPS.isModifyingPositions() && state.isAddedToGroup() && state.hasConnectorId()) {
            state.setAddedToGroup(false);
            LOADED_GROUPS.removePosition(state.getGroupId(), pos, network.isInitialized());
        }
    }

    public static int generateGroupId() {
        return ((GlobalCounters)IntegratedDynamics.globalCounters.get()).getNext("omnidir-connectors");
    }

    @Override
    public void loadTooltip(State state, List<Component> lines) {
        super.loadTooltip(state, lines);
        lines.add((Component)Component.translatable((String)"parttype.integrateddynamics.tooltip.monodirectionalconnector.group", (Object[])new Object[]{state.getGroupId()}));
    }

    @Override
    public void loadTooltip(ItemStack itemStack, Consumer<Component> tooltipAdder) {
        super.loadTooltip(itemStack, tooltipAdder);
        if (itemStack.has(RegistryEntries.DATACOMPONENT_OMNIDIRECTIONAL_GROUP)) {
            tooltipAdder.accept((Component)Component.translatable((String)"parttype.integrateddynamics.tooltip.monodirectionalconnector.group", (Object[])new Object[]{itemStack.get(RegistryEntries.DATACOMPONENT_OMNIDIRECTIONAL_GROUP)}));
        }
    }

    protected IgnoredBlockStatus.Status getStatus(State state) {
        return state != null && state.hasConnectorId() ? IgnoredBlockStatus.Status.ACTIVE : IgnoredBlockStatus.Status.INACTIVE;
    }

    @Override
    public BlockState getBlockState(IPartContainer partContainer, Direction side) {
        IgnoredBlockStatus.Status status = this.getStatus(partContainer != null ? (State)partContainer.getPartState(side) : null);
        return (BlockState)((BlockState)super.getBlockState(partContainer, side).setValue(IgnoredBlock.FACING, (Comparable)side)).setValue(IgnoredBlockStatus.STATUS, (Comparable)((Object)status));
    }

    public static ItemStack transformCraftingOutput(CraftingInput inventory, ItemStack staticOutput) {
        int groupId = -1;
        int stackCount = 0;
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack slotStack = inventory.getItem(i);
            if (slotStack.isEmpty()) continue;
            ++stackCount;
            if (groupId != -1 || slotStack.getItem() != PartTypes.CONNECTOR_OMNI.getItem() || !slotStack.has(RegistryEntries.DATACOMPONENT_OMNIDIRECTIONAL_GROUP)) continue;
            groupId = (Integer)slotStack.get(RegistryEntries.DATACOMPONENT_OMNIDIRECTIONAL_GROUP);
        }
        if (stackCount == 1) {
            groupId = -1;
        }
        if (groupId < 0) {
            groupId = PartTypeConnectorOmniDirectional.generateGroupId();
        }
        staticOutput = staticOutput.copy();
        staticOutput.set(RegistryEntries.DATACOMPONENT_OMNIDIRECTIONAL_GROUP, (Object)groupId);
        return staticOutput;
    }

    @Override
    public InteractionResult onPartActivated(State partState, BlockPos pos, Level world, Player player, InteractionHand hand, ItemStack heldItem, BlockHitResult hit) {
        if (player.isSecondaryUseActive() || !partState.isEnabled()) {
            return InteractionResult.PASS;
        }
        if (world.isClientSide()) {
            player.displayClientMessage((Component)Component.translatable((String)"parttype.integrateddynamics.tooltip.monodirectionalconnector.group", (Object[])new Object[]{partState.getGroupId()}), true);
        }
        return InteractionResult.SUCCESS;
    }

    public static class State
    extends PartTypeConnector.State<PartTypeConnectorOmniDirectional> {
        private int groupId = -1;
        private boolean addedToGroup = false;

        @Override
        public void serialize(ValueOutput valueOutput) {
            super.serialize(valueOutput);
            valueOutput.putInt("groupId", this.groupId);
        }

        @Override
        public void deserialize(ValueInput valueInput) {
            super.deserialize(valueInput);
            this.groupId = valueInput.getIntOr("groupId", -1);
        }

        @Override
        public Set<ISidedPathElement> getReachableElements() {
            if (this.hasConnectorId()) {
                TreeSet pathElements = Sets.newTreeSet();
                for (PartPos pos : LOADED_GROUPS.getPositions(this.getGroupId())) {
                    if (pos.equals(this.getPartPos())) continue;
                    IModHelpersNeoForge.get().getCapabilityHelpers().getCapability(pos.getPos(), (Object)pos.getSide(), Capabilities.PathElement.BLOCK).ifPresent(pathElement -> pathElements.add(SidedPathElement.of(pathElement, pos.getSide())));
                }
                return pathElements;
            }
            return Collections.emptySet();
        }

        public int getGroupId() {
            return this.groupId;
        }

        public void setGroupId(int groupId) {
            this.groupId = groupId;
            this.sendUpdate();
        }

        public boolean hasConnectorId() {
            return this.groupId >= 0;
        }

        public boolean isAddedToGroup() {
            return this.addedToGroup;
        }

        public void setAddedToGroup(boolean addedToGroup) {
            this.addedToGroup = addedToGroup;
        }
    }

    public static class LoadedGroups {
        private Int2ObjectMap<Set<PartPos>> groupPositions = new Int2ObjectOpenHashMap();
        private boolean modifyingPositions = false;

        public void onStartedEvent(ServerStartedEvent event) {
            this.groupPositions.clear();
        }

        public Set<PartPos> getPositions(int group) {
            Set<PartPos> positions = (Set<PartPos>)this.groupPositions.get(group);
            return positions != null ? positions : Collections.emptySet();
        }

        protected void initNetworkGroup(Set<PartPos> positions) {
            for (PartPos position : positions) {
                if (!position.getPos().isLoaded()) continue;
                NetworkHelpers.initNetwork((ILevelExtension)position.getPos().getLevel(true), position.getPos().getBlockPos(), position.getSide());
            }
        }

        public void addPosition(int group, PartPos pos, boolean initNetwork) {
            Set positions = (Set)this.groupPositions.get(group);
            if (positions == null) {
                positions = Sets.newTreeSet();
                this.groupPositions.put(group, (Object)positions);
            }
            positions.add(pos);
            if (initNetwork) {
                this.modifyingPositions = true;
                this.initNetworkGroup(positions);
                this.modifyingPositions = false;
            }
        }

        public void removePosition(int group, PartPos pos, boolean initNetwork) {
            Set positions = (Set)this.groupPositions.get(group);
            if (positions == null) {
                positions = Sets.newTreeSet();
                this.groupPositions.put(group, (Object)positions);
            }
            positions.remove(pos);
            if (initNetwork) {
                this.modifyingPositions = true;
                this.initNetworkGroup(positions);
                if (pos.getPos().isLoaded()) {
                    NetworkHelpers.initNetwork((ILevelExtension)pos.getPos().getLevel(true), pos.getPos().getBlockPos(), pos.getSide());
                }
                this.modifyingPositions = false;
            }
        }

        public boolean isModifyingPositions() {
            return this.modifyingPositions;
        }
    }
}

