/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.part.aspect.write;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectWrite;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.api.part.write.IPartTypeWriter;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.part.aspect.AspectBase;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public abstract class AspectWriteBase<V extends IValue, T extends IValueType<V>>
extends AspectBase<V, T>
implements IAspectWrite<V, T> {
    protected final String unlocalizedTypeSuffix;

    public AspectWriteBase(String modId, String unlocalizedTypeSuffix, IAspectProperties defaultProperties) {
        super(modId, defaultProperties);
        if (unlocalizedTypeSuffix == null) {
            unlocalizedTypeSuffix = "";
        }
        this.unlocalizedTypeSuffix = unlocalizedTypeSuffix;
        if (IModHelpers.get().getMinecraftHelpers().isClientSide()) {
            this.registerModelResourceLocation();
        }
    }

    @Override
    public <P extends IPartType<P, S>, S extends IPartState<P>> void update(INetwork network, IPartNetwork partNetwork, P partType, PartTarget target, S state) {
        IPartTypeWriter partTypeWriter = (IPartTypeWriter)partType;
        IPartStateWriter writerState = (IPartStateWriter)state;
        IVariable variable = partTypeWriter.getActiveVariable(network, partNetwork, target, writerState);
        if (variable != null && writerState.getErrors(this).isEmpty()) {
            if (ValueHelpers.correspondsTo(variable, this.getValueType())) {
                if (writerState.isDeactivated() || writerState.checkAndResetFirstTick()) {
                    this.onActivate(partTypeWriter, target, writerState);
                }
                try {
                    this.write(partTypeWriter, target, writerState, variable);
                }
                catch (EvaluationException e) {
                    writerState.addError(this, e.getErrorMessage());
                    writerState.setDeactivated(true);
                    e.addResolutionListeners(() -> writerState.onVariableContentsUpdated(partTypeWriter, target));
                }
            } else {
                try {
                    writerState.addError(this, Component.translatable((String)"aspect.integrateddynamics.error.invalid_type", (Object[])new Object[]{Component.translatable((String)this.getValueType().getTranslationKey()), Component.translatable((String)variable.getValue().getType().getTranslationKey())}));
                }
                catch (EvaluationException e) {
                    writerState.addError(this, Component.translatable((String)"aspect.integrateddynamics.error.invalid_type", (Object[])new Object[]{Component.translatable((String)this.getValueType().getTranslationKey()), Component.translatable((String)variable.getType().getTranslationKey())}));
                }
                writerState.setDeactivated(true);
            }
        } else if (!writerState.isDeactivated()) {
            this.onDeactivate(partTypeWriter, target, writerState);
        }
    }

    @Override
    public <P extends IPartTypeWriter<P, S>, S extends IPartStateWriter<P>> void onActivate(P partType, PartTarget target, S state) {
        state.setDeactivated(false);
    }

    @Override
    public <P extends IPartTypeWriter<P, S>, S extends IPartStateWriter<P>> void onDeactivate(P partType, PartTarget target, S state) {
        state.setDeactivated(true);
    }

    @Override
    public <P extends IPartType<P, S>, S extends IPartState<P>> void setProperties(P partType, PartTarget target, S state, IAspectProperties properties) {
        this.onDeactivate((IPartTypeWriter)partType, target, (IPartStateWriter)state);
        super.setProperties(partType, target, state, properties);
        this.onActivate((IPartTypeWriter)partType, target, (IPartStateWriter)state);
    }

    @Override
    protected String getUnlocalizedType() {
        return "write" + this.unlocalizedTypeSuffix;
    }

    protected void registerModelResourceLocation() {
        Aspects.REGISTRY.getClient().registerAspectModel(this, ResourceLocation.parse((String)(this.getModId() + ":aspect/" + this.getUnlocalizedType().replaceAll("\\.", "/"))));
    }
}

