/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.recipe;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.core.persist.world.LabelsWorldStorage;
import org.cyclops.integrateddynamics.item.ItemVariable;

public class ItemVariableCopyRecipe
extends CustomRecipe {
    private ValueDeseralizationContext lastValueDeseralizationContext;

    public ItemVariableCopyRecipe(CraftingBookCategory craftingBookCategory) {
        super(craftingBookCategory);
    }

    public boolean matches(CraftingInput inv, Level worldIn) {
        this.lastValueDeseralizationContext = ValueDeseralizationContext.of(worldIn);
        return !this.assemble(inv, (HolderLookup.Provider)worldIn.registryAccess()).isEmpty();
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registryAccess) {
        ItemStack withData = ItemStack.EMPTY;
        ItemStack withoutData = ItemStack.EMPTY;
        int count = 0;
        for (int j = 0; j < inv.size(); ++j) {
            ItemStack element = inv.getItem(j);
            if (element.isEmpty() || !(element.getItem() instanceof ItemVariable)) continue;
            ++count;
            IVariableFacade facade = ((ItemVariable)((Object)RegistryEntries.ITEM_VARIABLE.get())).getVariableFacade(this.lastValueDeseralizationContext, element);
            if (!facade.isValid() && withoutData.isEmpty()) {
                withoutData = element;
            }
            if (!facade.isValid() || !withData.isEmpty() || element.getCount() != 1) continue;
            withData = element.copy();
        }
        if (count == 2 && !withoutData.isEmpty() && !withData.isEmpty()) {
            return withData;
        }
        return ItemStack.EMPTY;
    }

    public ItemStack getResultItem() {
        return new ItemStack(RegistryEntries.ITEM_VARIABLE, 1);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        NonNullList ret = NonNullList.withSize((int)inv.size(), (Object)ItemStack.EMPTY);
        for (int j = 0; j < inv.size(); ++j) {
            IVariableFacade facadeCopy;
            IVariableFacade facade;
            ItemStack element = inv.getItem(j);
            if (element.isEmpty() || !(element.getItem() instanceof ItemVariable) || !(facade = ((ItemVariable)((Object)RegistryEntries.ITEM_VARIABLE.get())).getVariableFacade(this.lastValueDeseralizationContext, element)).isValid()) continue;
            ItemStack copy = ((IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class)).copy(!IModHelpers.get().getMinecraftHelpers().isClientSideThread(), element);
            String label = LabelsWorldStorage.Access.getInstance(IntegratedDynamics._instance).get().getLabel(facade.getId());
            if (label != null && (facadeCopy = ((ItemVariable)((Object)RegistryEntries.ITEM_VARIABLE.get())).getVariableFacade(this.lastValueDeseralizationContext, copy)) != null) {
                LabelsWorldStorage.Access.getInstance(IntegratedDynamics._instance).get().put(facadeCopy.getId(), label);
            }
            ret.set(j, (Object)copy);
        }
        return ret;
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return (RecipeSerializer)RegistryEntries.RECIPESERIALIZER_VARIABLE_COPY.get();
    }
}

