/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.rei.logicprogrammer;

import com.google.common.collect.Lists;
import dev.architectury.fluid.FluidStack;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElement;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenLogicProgrammerBase;
import org.cyclops.integrateddynamics.core.ingredient.ItemMatchProperties;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeRecipeLPElement;
import org.cyclops.integrateddynamics.core.logicprogrammer.client.RenderPattern;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integrateddynamicscompat.GeneralConfig;
import org.cyclops.integrateddynamicscompat.IntegratedDynamicsCompat;
import org.cyclops.integrateddynamicscompat.modcompat.common.JeiReiHelpers;
import org.cyclops.integrateddynamicscompat.network.packet.CPacketValueTypeRecipeLPElementSetRecipe;

public class ReiLogicProgrammerTransferHandler
implements TransferHandler {
    public TransferHandler.Result handle(TransferHandler.Context context) {
        ContainerLogicProgrammerBase container;
        ILogicProgrammerElement<RenderPattern, ContainerScreenLogicProgrammerBase<?>, ContainerLogicProgrammerBase, ?> element;
        AbstractContainerMenu abstractContainerMenu = context.getMenu();
        if (abstractContainerMenu instanceof ContainerLogicProgrammerBase && (element = (container = (ContainerLogicProgrammerBase)abstractContainerMenu).getActiveElement()) instanceof ValueTypeRecipeLPElement) {
            return this.handleRecipeElement((ValueTypeRecipeLPElement)element, container, context.getDisplay(), context.isActuallyCrafting());
        }
        return TransferHandler.Result.createNotApplicable();
    }

    private TransferHandler.Result handleRecipeElement(ValueTypeRecipeLPElement element, ContainerLogicProgrammerBase container, Display display, boolean doTransfer) {
        ArrayList itemInputs = Lists.newArrayList();
        ArrayList fluidInputs = Lists.newArrayList();
        ArrayList itemOutputs = Lists.newArrayList();
        ArrayList fluidOutputs = Lists.newArrayList();
        for (EntryIngredient entry : display.getInputEntries()) {
            this.handleEntry(entry, true, itemInputs, fluidInputs, itemOutputs, fluidOutputs);
        }
        for (EntryIngredient entry : display.getOutputEntries()) {
            this.handleEntry(entry, false, itemInputs, fluidInputs, itemOutputs, fluidOutputs);
        }
        if (!element.isValidForRecipeGrid(itemInputs, fluidInputs, itemOutputs, fluidOutputs)) {
            return TransferHandler.Result.createFailed((Component)Component.translatable((String)"error.jei.integrateddynamics.recipetransfer.recipe.toobig.desc"));
        }
        if (doTransfer) {
            element.setRecipeGrid(container, itemInputs, fluidInputs, itemOutputs, fluidOutputs);
            IntegratedDynamicsCompat._instance.getPacketHandler().sendToServer((PacketBase)new CPacketValueTypeRecipeLPElementSetRecipe(container.containerId, itemInputs, fluidInputs, itemOutputs, fluidOutputs));
        }
        return TransferHandler.Result.createSuccessful().blocksFurtherHandling();
    }

    private void handleEntry(EntryIngredient entry, boolean input, List<ItemMatchProperties> itemInputs, List<net.neoforged.neoforge.fluids.FluidStack> fluidInputs, List<ItemStack> itemOutputs, List<net.neoforged.neoforge.fluids.FluidStack> fluidOutputs) {
        if (entry.isEmpty()) {
            itemInputs.add(new ItemMatchProperties(ItemStack.EMPTY));
        } else {
            EntryStack typedIngredient = (EntryStack)entry.stream().findFirst().get();
            if (typedIngredient.getType() == VanillaEntryTypes.ITEM) {
                if (input) {
                    ResourceLocation heuristicTag = this.getHeuristicItemsTag(entry);
                    if (heuristicTag != null) {
                        itemInputs.add(new ItemMatchProperties(ItemStack.EMPTY, false, heuristicTag.toString(), ((ItemStack)typedIngredient.castValue()).getCount()));
                    } else {
                        itemInputs.add(new ItemMatchProperties(((ItemStack)typedIngredient.castValue()).copy()));
                    }
                } else {
                    itemOutputs.add(((ItemStack)typedIngredient.castValue()).copy());
                }
            } else if (typedIngredient.getType() == VanillaEntryTypes.FLUID) {
                FluidStack fluidStack = (FluidStack)typedIngredient.castValue();
                net.neoforged.neoforge.fluids.FluidStack fluidStackForge = new net.neoforged.neoforge.fluids.FluidStack(fluidStack.getFluid(), (int)fluidStack.getAmount());
                if (input) {
                    fluidInputs.add(fluidStackForge);
                } else {
                    fluidOutputs.add(fluidStackForge);
                }
            }
        }
    }

    @Nullable
    protected ResourceLocation getHeuristicItemsTag(EntryIngredient jeiIngredient) {
        if (!GeneralConfig.reiHeuristicTags) {
            return null;
        }
        List<Item> items = jeiIngredient.stream().map(typedIngredient -> (ItemStack)typedIngredient.castValue()).map(ItemStack::getItem).collect(Collectors.toList());
        if (items.size() > 1) {
            return JeiReiHelpers.itemsToTag(items);
        }
        return null;
    }
}

