/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.fluid;

import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerCapacity;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerMutable;

public class Tank
extends FluidTank
implements IFluidHandlerCapacity,
IFluidHandlerMutable {
    public Tank(int capacity) {
        super(capacity);
    }

    public boolean isEmpty() {
        return this.getFluid().isEmpty() || this.getFluid().getAmount() <= 0;
    }

    public boolean isFull() {
        return !this.getFluid().isEmpty() && this.getFluid().getAmount() >= this.getCapacity();
    }

    public Fluid getFluidType() {
        return !this.getFluid().isEmpty() ? this.getFluid().getFluid() : null;
    }

    protected boolean replaceInnerFluid() {
        return true;
    }

    public void serialize(ValueOutput output) {
        if (this.replaceInnerFluid()) {
            super.serialize(output);
        }
        this.serializeTank(output);
    }

    public void serialize(ValueOutput output, String tag) {
        this.serialize(output.child(tag));
    }

    public void deserialize(ValueInput input) {
        if (this.replaceInnerFluid()) {
            if (input.child("Empty").isPresent()) {
                this.setFluid(null);
            }
            super.deserialize(input);
        }
        this.deserializeTank(input);
    }

    public void deserialize(ValueInput input, String tag) {
        this.deserialize((ValueInput)input.child(tag).orElseThrow());
    }

    public void serializeTank(ValueOutput output) {
        output.putInt("capacity", this.getCapacity());
    }

    public void deserializeTank(ValueInput input) {
        this.setCapacity((Integer)input.getInt("capacity").orElseThrow());
    }

    @Override
    public void setFluidInTank(int tank, FluidStack fluidStack) {
        if (tank == 0) {
            this.setFluid(fluidStack);
        }
    }

    @Override
    public void setTankCapacity(int tank, int capacity) {
        if (tank == 0) {
            this.setCapacity(capacity);
        }
    }

    @Override
    public int getTankCapacity(int tank) {
        if (tank == 0) {
            return this.getCapacity();
        }
        return 0;
    }
}

