/*
 * Decompiled with CFR 0.152.
 */
package com.barlinc.unusual_prehistory.datagen;

import com.barlinc.unusual_prehistory.UnusualPrehistory2;
import com.barlinc.unusual_prehistory.registry.UP2Blocks;
import com.barlinc.unusual_prehistory.registry.UP2CriteriaTriggers;
import com.barlinc.unusual_prehistory.registry.UP2Criterion;
import com.barlinc.unusual_prehistory.registry.UP2Entities;
import com.barlinc.unusual_prehistory.registry.UP2Items;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.SummonedEntityTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class UP2AdvancementProvider
implements ForgeAdvancementProvider.AdvancementGenerator {
    private static final EntityType<?>[] REVIVABLE_MOBS = new EntityType[]{(EntityType)UP2Entities.CARNOTAURUS.get(), (EntityType)UP2Entities.DIPLOCAULUS.get(), (EntityType)UP2Entities.DROMAEOSAURUS.get(), (EntityType)UP2Entities.DUNKLEOSTEUS.get(), (EntityType)UP2Entities.JAWLESS_FISH.get(), (EntityType)UP2Entities.KENTROSAURUS.get(), (EntityType)UP2Entities.KIMMERIDGEBRACHYPTERAESCHNIDIUM_NYMPH.get(), (EntityType)UP2Entities.MAJUNGASAURUS.get(), (EntityType)UP2Entities.MEGALANIA.get(), (EntityType)UP2Entities.ONCHOPRISTIS.get(), (EntityType)UP2Entities.STETHACANTHUS.get(), (EntityType)UP2Entities.TALPANAS.get(), (EntityType)UP2Entities.TELECREX.get()};
    private static final ItemLike[] ROOT = new ItemLike[]{(ItemLike)UP2Items.MACHINE_PARTS.get(), (ItemLike)UP2Items.AGED_FEATHER.get(), (ItemLike)UP2Items.FURY_FOSSIL.get(), (ItemLike)UP2Items.BOOMERANG_FOSSIL.get(), (ItemLike)UP2Items.RUNNER_FOSSIL.get(), (ItemLike)UP2Items.GUILLOTINE_FOSSIL.get(), (ItemLike)UP2Items.JAWLESS_FOSSIL.get(), (ItemLike)UP2Items.PRICKLY_FOSSIL.get(), (ItemLike)UP2Items.IMPERATIVE_FOSSIL.get(), (ItemLike)UP2Items.RUGOSE_FOSSIL.get(), (ItemLike)UP2Items.THERMAL_FOSSIL.get(), (ItemLike)UP2Items.SAW_FOSSIL.get(), (ItemLike)UP2Items.ANVIL_FOSSIL.get(), (ItemLike)UP2Items.PLUMAGE_FOSSIL.get(), (ItemLike)UP2Items.BENNETTITALES_FOSSIL.get(), (ItemLike)UP2Items.CALAMOPHYTON_FOSSIL.get(), (ItemLike)UP2Items.CLADOPHEBIS_FOSSIL.get(), (ItemLike)UP2Items.COOKSONIA_FOSSIL.get(), (ItemLike)UP2Items.HORSETAIL_FOSSIL.get(), (ItemLike)UP2Items.LEEFRUCTUS_FOSSIL.get(), (ItemLike)UP2Items.QUILLWORT_FOSSIL.get(), (ItemLike)UP2Items.RAIGUENRAYUN_FOSSIL.get(), (ItemLike)UP2Items.RHYNIA_FOSSIL.get(), (ItemLike)UP2Items.GINKGO_FOSSIL.get(), (ItemLike)UP2Items.LEPIDODENDRON_FOSSIL.get()};
    private static final ItemLike[] FOSSILS = new ItemLike[]{(ItemLike)UP2Items.FURY_FOSSIL.get(), (ItemLike)UP2Items.BOOMERANG_FOSSIL.get(), (ItemLike)UP2Items.RUNNER_FOSSIL.get(), (ItemLike)UP2Items.GUILLOTINE_FOSSIL.get(), (ItemLike)UP2Items.JAWLESS_FOSSIL.get(), (ItemLike)UP2Items.PRICKLY_FOSSIL.get(), (ItemLike)UP2Items.IMPERATIVE_FOSSIL.get(), (ItemLike)UP2Items.RUGOSE_FOSSIL.get(), (ItemLike)UP2Items.THERMAL_FOSSIL.get(), (ItemLike)UP2Items.SAW_FOSSIL.get(), (ItemLike)UP2Items.ANVIL_FOSSIL.get(), (ItemLike)UP2Items.PLUMAGE_FOSSIL.get(), (ItemLike)UP2Items.BENNETTITALES_FOSSIL.get(), (ItemLike)UP2Items.CALAMOPHYTON_FOSSIL.get(), (ItemLike)UP2Items.CLADOPHEBIS_FOSSIL.get(), (ItemLike)UP2Items.COOKSONIA_FOSSIL.get(), (ItemLike)UP2Items.HORSETAIL_FOSSIL.get(), (ItemLike)UP2Items.LEEFRUCTUS_FOSSIL.get(), (ItemLike)UP2Items.QUILLWORT_FOSSIL.get(), (ItemLike)UP2Items.RAIGUENRAYUN_FOSSIL.get(), (ItemLike)UP2Items.RHYNIA_FOSSIL.get(), (ItemLike)UP2Items.GINKGO_FOSSIL.get(), (ItemLike)UP2Items.LEPIDODENDRON_FOSSIL.get()};
    private static final ItemLike[] HOLOCENE_REMAINS = new ItemLike[]{(ItemLike)UP2Items.AGED_FEATHER.get()};
    private static final ItemLike[] EGGS = new ItemLike[]{(ItemLike)UP2Blocks.CARNOTAURUS_EGG.get(), (ItemLike)UP2Blocks.DIPLOCAULUS_EGGS.get(), (ItemLike)UP2Items.DROMAEOSAURUS_EGG.get(), (ItemLike)UP2Blocks.DUNKLEOSTEUS_SAC.get(), (ItemLike)UP2Blocks.JAWLESS_FISH_ROE.get(), (ItemLike)UP2Blocks.KENTROSAURUS_EGG.get(), (ItemLike)UP2Blocks.KIMMERIDGEBRACHYPTERAESCHNIDIUM_EGGS.get(), (ItemLike)UP2Blocks.MAJUNGASAURUS_EGG.get(), (ItemLike)UP2Blocks.MEGALANIA_EGG.get(), (ItemLike)UP2Blocks.ONCHOPRISTIS_SAC.get(), (ItemLike)UP2Blocks.STETHACANTHUS_SAC.get(), (ItemLike)UP2Items.TALPANAS_EGG.get(), (ItemLike)UP2Items.TELECREX_EGG.get()};

    public static ForgeAdvancementProvider register(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, ExistingFileHelper helper) {
        return new ForgeAdvancementProvider(output, provider, helper, List.of(new UP2AdvancementProvider()));
    }

    public void generate(@NotNull HolderLookup.Provider provider, @NotNull Consumer<Advancement> consumer, @NotNull ExistingFileHelper helper) {
        Advancement root = this.addItemList(ROOT, Advancement.Builder.m_138353_().m_138371_((ItemLike)UP2Items.UNUSUAL_PREHISTORY.get(), (Component)Component.m_237115_((String)"advancement.unusual_prehistory.root"), (Component)Component.m_237115_((String)"advancement.unusual_prehistory.root.desc"), UnusualPrehistory2.modPrefix("textures/block/mossy_dirt_top.png"), FrameType.TASK, false, false, false).m_138360_(RequirementsStrategy.f_15979_)).save(consumer, UnusualPrehistory2.modPrefix("root"), helper);
        Advancement fossils = this.addItemList(FOSSILS, Advancement.Builder.m_138353_().m_138398_(root).m_138371_((ItemLike)UP2Items.RUGOSE_FOSSIL.get(), (Component)Component.m_237115_((String)"advancement.unusual_prehistory.obtain_fossil"), (Component)Component.m_237115_((String)"advancement.unusual_prehistory.obtain_fossil.desc"), null, FrameType.TASK, true, true, false).m_138360_(RequirementsStrategy.f_15979_)).save(consumer, UnusualPrehistory2.modPrefix("obtain_fossil"), helper);
        Advancement holoceneRemains = this.addItemList(HOLOCENE_REMAINS, Advancement.Builder.m_138353_().m_138398_(fossils).m_138371_((ItemLike)UP2Items.AGED_FEATHER.get(), (Component)Component.m_237115_((String)"advancement.unusual_prehistory.obtain_holocene_remains"), (Component)Component.m_237115_((String)"advancement.unusual_prehistory.obtain_holocene_remains.desc"), null, FrameType.TASK, true, true, false).m_138360_(RequirementsStrategy.f_15979_)).save(consumer, UnusualPrehistory2.modPrefix("obtain_holocene_remains"), helper);
        Advancement machineParts = Advancement.Builder.m_138353_().m_138398_(holoceneRemains).m_138371_((ItemLike)UP2Items.MACHINE_PARTS.get(), (Component)Component.m_237115_((String)"advancement.unusual_prehistory.obtain_machine_parts"), (Component)Component.m_237115_((String)"advancement.unusual_prehistory.obtain_machine_parts.desc"), null, FrameType.TASK, true, true, false).m_138386_("machine_parts", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)UP2Items.MACHINE_PARTS.get()})).save(consumer, UnusualPrehistory2.modPrefix("obtain_machine_parts"), helper);
        Advancement transmogrifier = Advancement.Builder.m_138353_().m_138398_(machineParts).m_138371_((ItemLike)UP2Blocks.TRANSMOGRIFIER.get(), (Component)Component.m_237115_((String)"advancement.unusual_prehistory.obtain_transmogrifier"), (Component)Component.m_237115_((String)"advancement.unusual_prehistory.obtain_transmogrifier.desc"), null, FrameType.GOAL, true, true, false).m_138386_("transmogrifier", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)UP2Blocks.TRANSMOGRIFIER.get()})).save(consumer, UnusualPrehistory2.modPrefix("obtain_transmogrifier"), helper);
        Advancement organicOoze = Advancement.Builder.m_138353_().m_138398_(transmogrifier).m_138371_((ItemLike)UP2Items.ORGANIC_OOZE.get(), (Component)Component.m_237115_((String)"advancement.unusual_prehistory.obtain_organic_ooze"), (Component)Component.m_237115_((String)"advancement.unusual_prehistory.obtain_organic_ooze.desc"), null, FrameType.TASK, true, true, false).m_138386_("organic_ooze", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)UP2Items.ORGANIC_OOZE.get()})).save(consumer, UnusualPrehistory2.modPrefix("obtain_organic_ooze"), helper);
        Advancement eggs = this.addItemList(EGGS, Advancement.Builder.m_138353_().m_138398_(organicOoze).m_138371_((ItemLike)UP2Blocks.MAJUNGASAURUS_EGG.get(), (Component)Component.m_237115_((String)"advancement.unusual_prehistory.obtain_egg"), (Component)Component.m_237115_((String)"advancement.unusual_prehistory.obtain_egg.desc"), null, FrameType.GOAL, true, true, false).m_138360_(RequirementsStrategy.f_15979_)).save(consumer, UnusualPrehistory2.modPrefix("obtain_egg"), helper);
        Advancement ginkgo = Advancement.Builder.m_138353_().m_138398_(organicOoze).m_138371_((ItemLike)UP2Blocks.GINKGO_SAPLING.get(), (Component)Component.m_237115_((String)"advancement.unusual_prehistory.revive_ginkgo"), (Component)Component.m_237115_((String)"advancement.unusual_prehistory.revive_ginkgo.desc"), null, FrameType.TASK, true, true, false).m_138386_("ginkgo_sapling", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)UP2Blocks.GINKGO_SAPLING.get()})).m_138386_("golden_ginkgo_sapling", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)UP2Blocks.GOLDEN_GINKGO_SAPLING.get()})).m_138360_(RequirementsStrategy.f_15979_).save(consumer, UnusualPrehistory2.modPrefix("revive_ginkgo"), helper);
        Advancement lepidodendron = Advancement.Builder.m_138353_().m_138398_(organicOoze).m_138371_((ItemLike)UP2Blocks.LEPIDODENDRON_CONE.get(), (Component)Component.m_237115_((String)"advancement.unusual_prehistory.revive_lepidodendron"), (Component)Component.m_237115_((String)"advancement.unusual_prehistory.revive_lepidodendron.desc"), null, FrameType.TASK, true, true, false).m_138386_("lepidodendron_cone", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)UP2Blocks.LEPIDODENDRON_CONE.get()})).save(consumer, UnusualPrehistory2.modPrefix("revive_lepidodendron"), helper);
        Advancement carnotaurus = Advancement.Builder.m_138353_().m_138398_(eggs).m_138371_((ItemLike)UP2Blocks.CARNOTAURUS_EGG.get(), (Component)Component.m_237115_((String)"advancement.unusual_prehistory.hatch_carnotaurus"), (Component)Component.m_237115_((String)"advancement.unusual_prehistory.hatch_carnotaurus.desc"), null, FrameType.TASK, true, true, false).m_138386_("hatch_carnotaurus", (CriterionTriggerInstance)SummonedEntityTrigger.TriggerInstance.m_68275_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)UP2Entities.CARNOTAURUS.get()))).save(consumer, UnusualPrehistory2.modPrefix("hatch_carnotaurus"), helper);
        Advancement talpanas = Advancement.Builder.m_138353_().m_138398_(eggs).m_138371_((ItemLike)UP2Items.TALPANAS_EGG.get(), (Component)Component.m_237115_((String)"advancement.unusual_prehistory.hatch_talpanas"), (Component)Component.m_237115_((String)"advancement.unusual_prehistory.hatch_talpanas.desc"), null, FrameType.TASK, true, true, false).m_138386_("hatch_talpanas", (CriterionTriggerInstance)SummonedEntityTrigger.TriggerInstance.m_68275_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)UP2Entities.TALPANAS.get()))).save(consumer, UnusualPrehistory2.modPrefix("hatch_talpanas"), helper);
        this.hatchEggAdvancement(eggs, (ItemLike)UP2Blocks.DIPLOCAULUS_EGGS.get(), "hatch_diplocaulus", (EntityType)UP2Entities.DIPLOCAULUS.get(), consumer, helper);
        this.hatchEggAdvancement(eggs, (ItemLike)UP2Items.DROMAEOSAURUS_EGG.get(), "hatch_dromaeosaurus", (EntityType)UP2Entities.DROMAEOSAURUS.get(), consumer, helper);
        this.hatchEggAdvancement(eggs, (ItemLike)UP2Blocks.DUNKLEOSTEUS_SAC.get(), "hatch_dunkleosteus", (EntityType)UP2Entities.DUNKLEOSTEUS.get(), consumer, helper);
        this.hatchEggAdvancement(eggs, (ItemLike)UP2Blocks.JAWLESS_FISH_ROE.get(), "hatch_jawless_fish", (EntityType)UP2Entities.JAWLESS_FISH.get(), consumer, helper);
        this.hatchEggAdvancement(eggs, (ItemLike)UP2Blocks.KENTROSAURUS_EGG.get(), "hatch_kentrosaurus", (EntityType)UP2Entities.KENTROSAURUS.get(), consumer, helper);
        this.hatchEggAdvancement(eggs, (ItemLike)UP2Blocks.KIMMERIDGEBRACHYPTERAESCHNIDIUM_EGGS.get(), "hatch_kimmeridgebrachypteraeschnidium", (EntityType)UP2Entities.KIMMERIDGEBRACHYPTERAESCHNIDIUM_NYMPH.get(), consumer, helper);
        this.hatchEggAdvancement(eggs, (ItemLike)UP2Blocks.MAJUNGASAURUS_EGG.get(), "hatch_majungasaurus", (EntityType)UP2Entities.MAJUNGASAURUS.get(), consumer, helper);
        this.hatchEggAdvancement(eggs, (ItemLike)UP2Blocks.MEGALANIA_EGG.get(), "hatch_megalania", (EntityType)UP2Entities.MEGALANIA.get(), consumer, helper);
        this.hatchEggAdvancement(eggs, (ItemLike)UP2Blocks.ONCHOPRISTIS_SAC.get(), "hatch_onchopristis", (EntityType)UP2Entities.ONCHOPRISTIS.get(), consumer, helper);
        this.hatchEggAdvancement(eggs, (ItemLike)UP2Blocks.STETHACANTHUS_SAC.get(), "hatch_stethacanthus", (EntityType)UP2Entities.STETHACANTHUS.get(), consumer, helper);
        this.hatchEggAdvancement(eggs, (ItemLike)UP2Items.TELECREX_EGG.get(), "hatch_telecrex", (EntityType)UP2Entities.TELECREX.get(), consumer, helper);
        this.addMobList(REVIVABLE_MOBS, Advancement.Builder.m_138353_().m_138398_(eggs).m_138371_((ItemLike)Items.f_271356_, (Component)Component.m_237115_((String)"advancement.unusual_prehistory.hatch_all_mobs"), (Component)Component.m_237115_((String)"advancement.unusual_prehistory.hatch_all_mobs.desc"), null, FrameType.CHALLENGE, true, true, true).m_138360_(RequirementsStrategy.f_15978_)).m_138354_(AdvancementRewards.Builder.m_10005_((int)100)).save(consumer, UnusualPrehistory2.modPrefix("hatch_all_mobs"), helper);
        Advancement.Builder.m_138353_().m_138398_(talpanas).m_138371_((ItemLike)Items.f_151017_, (Component)Component.m_237115_((String)"advancement.unusual_prehistory.breed_holocene_mobs"), (Component)Component.m_237115_((String)"advancement.unusual_prehistory.breed_holocene_mobs.desc"), null, FrameType.TASK, true, true, false).m_138386_("breed_holocene_mobs", (CriterionTriggerInstance)new UP2CriteriaTriggers.TriggerInstance(UP2Criterion.BREED_HOLOCENE_MOBS.m_7295_(), ContextAwarePredicate.f_285567_)).save(consumer, UnusualPrehistory2.modPrefix("breed_holocene_mobs"), helper);
        Advancement.Builder.m_138353_().m_138398_(carnotaurus).m_138371_((ItemLike)Items.f_42437_, (Component)Component.m_237115_((String)"advancement.unusual_prehistory.pacify_mob"), (Component)Component.m_237115_((String)"advancement.unusual_prehistory.pacify_mob.desc"), null, FrameType.CHALLENGE, true, true, false).m_138386_("pacify_mob", (CriterionTriggerInstance)new UP2CriteriaTriggers.TriggerInstance(UP2Criterion.PACIFY_MOB.m_7295_(), ContextAwarePredicate.f_285567_)).m_138354_(AdvancementRewards.Builder.m_10005_((int)50)).save(consumer, UnusualPrehistory2.modPrefix("pacify_mob"), helper);
    }

    private void hatchEggAdvancement(Advancement parent, ItemLike displayItem, String translationKey, EntityType<?> entityType, Consumer<Advancement> consumer, ExistingFileHelper helper) {
        Advancement.Builder.m_138353_().m_138398_(parent).m_138371_(displayItem, (Component)Component.m_237115_((String)("advancement.unusual_prehistory." + translationKey)), (Component)Component.m_237115_((String)("advancement.unusual_prehistory." + translationKey + ".desc")), null, FrameType.TASK, true, true, false).m_138386_(translationKey, (CriterionTriggerInstance)SummonedEntityTrigger.TriggerInstance.m_68275_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_(entityType))).save(consumer, UnusualPrehistory2.modPrefix(translationKey), helper);
    }

    private Advancement.Builder addItemList(ItemLike[] itemLikes, Advancement.Builder builder) {
        for (ItemLike dendrologistBlock : itemLikes) {
            builder.m_138386_(ForgeRegistries.ITEMS.getKey((Object)dendrologistBlock.m_5456_()).m_135815_(), (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{dendrologistBlock}));
        }
        return builder;
    }

    private Advancement.Builder addMobList(EntityType<?>[] entityTypes, Advancement.Builder builder) {
        for (EntityType<?> entity : entityTypes) {
            builder.m_138386_(EntityType.m_20613_(entity).m_135815_(), (CriterionTriggerInstance)SummonedEntityTrigger.TriggerInstance.m_68275_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_(entity)));
        }
        return builder;
    }
}

