/*
 * Decompiled with CFR 0.152.
 */
package com.barlinc.unusual_prehistory.datagen;

import com.barlinc.unusual_prehistory.UnusualPrehistory2Tab;
import com.barlinc.unusual_prehistory.registry.UP2Blocks;
import com.barlinc.unusual_prehistory.registry.UP2DamageTypes;
import com.barlinc.unusual_prehistory.registry.UP2Entities;
import com.barlinc.unusual_prehistory.registry.UP2Items;
import com.barlinc.unusual_prehistory.registry.UP2SoundEvents;
import com.barlinc.unusual_prehistory.utils.UP2TextUtils;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.text.WordUtils;

public class UP2LanguageProvider
extends LanguageProvider {
    public UP2LanguageProvider(GatherDataEvent event) {
        super(event.getGenerator().getPackOutput(), "unusual_prehistory", "en_us");
    }

    protected void addTranslations() {
        this.creativeTab((CreativeModeTab)UnusualPrehistory2Tab.UNUSUAL_PREHISTORY_2_TAB.get(), "Unusual Prehistory 2");
        UP2Blocks.BLOCK_TRANSLATIONS.forEach(this::forBlock);
        UP2Items.ITEM_TRANSLATIONS.forEach(this::forItem);
        this.forEntity((Supplier<? extends EntityType<?>>)UP2Entities.CARNOTAURUS);
        this.forEntity((Supplier<? extends EntityType<?>>)UP2Entities.DIPLOCAULUS);
        this.forEntity((Supplier<? extends EntityType<?>>)UP2Entities.DROMAEOSAURUS);
        this.forEntity((Supplier<? extends EntityType<?>>)UP2Entities.DUNKLEOSTEUS);
        this.forEntity((Supplier<? extends EntityType<?>>)UP2Entities.JAWLESS_FISH);
        this.forEntity((Supplier<? extends EntityType<?>>)UP2Entities.KENTROSAURUS);
        this.forEntity((Supplier<? extends EntityType<?>>)UP2Entities.KIMMERIDGEBRACHYPTERAESCHNIDIUM);
        this.forEntity((Supplier<? extends EntityType<?>>)UP2Entities.KIMMERIDGEBRACHYPTERAESCHNIDIUM_NYMPH);
        this.forEntity((Supplier<? extends EntityType<?>>)UP2Entities.MAJUNGASAURUS);
        this.forEntity((Supplier<? extends EntityType<?>>)UP2Entities.MEGALANIA);
        this.forEntity((Supplier<? extends EntityType<?>>)UP2Entities.ONCHOPRISTIS);
        this.forEntity((Supplier<? extends EntityType<?>>)UP2Entities.STETHACANTHUS);
        this.forEntity((Supplier<? extends EntityType<?>>)UP2Entities.UNICORN);
        this.forEntity((Supplier<? extends EntityType<?>>)UP2Entities.TELECREX);
        this.forEntity((Supplier<? extends EntityType<?>>)UP2Entities.TALPANAS);
        this.forEntity((Supplier<? extends EntityType<?>>)UP2Entities.BOAT);
        this.addEntityType((Supplier)UP2Entities.CHEST_BOAT, "Boat with Chest");
        this.addItem((Supplier)UP2Items.GINKGO_CHEST_BOAT, "Ginkgo Boat with Chest");
        this.addItem((Supplier)UP2Items.LEPIDODENDRON_CHEST_BOAT, "Lepidodendron Boat with Chest");
        this.addItem((Supplier)UP2Items.KIMMERIDGEBRACHYPTERAESCHNIDIUM_BOTTLE, "Bottle of Kimmeridgebrachypteraeschnidium");
        this.addItem((Supplier)UP2Items.KIMMERIDGEBRACHYPTERAESCHNIDIUM_NYMPH_BUCKET, "Bucket of Kimmeridgebrachypteraeschnidium Nymph");
        this.addItem((Supplier)UP2Items.JAWLESS_FISH_BUCKET, "Bucket of Jawless Fish");
        this.addItem((Supplier)UP2Items.STETHACANTHUS_BUCKET, "Bucket of Stethacanthus");
        this.addItem((Supplier)UP2Items.DIPLOCAULUS_BUCKET, "Bucket of Diplocaulus");
        this.addItem((Supplier)UP2Items.DUNKLEOSTEUS_BUCKET, "Bucket of Dunkleosteus");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.TAR_POP, "Tar pops");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.CARNOTAURUS_STEP, "Carnotaurus steps");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.CARNOTAURUS_HURT, "Carnotaurus hurts");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.CARNOTAURUS_DEATH, "Carnotaurus dies");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.CARNOTAURUS_IDLE, "Carnotaurus grumbles");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.CARNOTAURUS_SNIFF, "Carnotaurus sniffs");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.CARNOTAURUS_BITE, "Carnotaurus bites");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.CARNOTAURUS_CHARGE, "Carnotaurus charges");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.CARNOTAURUS_HEADBUTT, "Carnotaurus headbutts");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.DIPLOCAULUS_HURT, "Diplocaulus hurts");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.DIPLOCAULUS_DEATH, "Diplocaulus dies");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.DIPLOCAULUS_IDLE, "Diplocaulus croaks");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.DROMAEOSAURUS_HURT, "Dromaeosaurus hurts");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.DROMAEOSAURUS_DEATH, "Dromaeosaurus dies");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.DROMAEOSAURUS_IDLE, "Dromaeosaurus chatters");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.DROMAEOSAURUS_EEPY, "Dromaeosaurus snores");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.DUNKLEOSTEUS_HURT, "Dunkleosteus hurts");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.DUNKLEOSTEUS_DEATH, "Dunkleosteus dies");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.DUNKLEOSTEUS_FLOP, "Dunkleosteus flops");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.SMALL_DUNKLEOSTEUS_BITE, "Dunkleosteus nibbles");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.MEDIUM_DUNKLEOSTEUS_BITE, "Dunkleosteus chomps");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.LARGE_DUNKLEOSTEUS_BITE, "Dunkleosteus crushes");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.JAWLESS_FISH_HURT, "Jawless Fish hurts");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.JAWLESS_FISH_DEATH, "Jawless Fish dies");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.JAWLESS_FISH_FLOP, "Jawless Fish flops");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.KENTROSAURUS_HURT, "Kentrosaurus hurts");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.KENTROSAURUS_DEATH, "Kentrosaurus dies");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.KENTROSAURUS_IDLE, "Kentrosaurus groans");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.KENTROSAURUS_STEP, "Kentrosaurus steps");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.KENTROSAURUS_EAT, "Kentrosaurus eats");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.KIMMERIDGEBRACHYPTERAESCHNIDIUM_HURT, "Kimmeridgebrachypteraeschnidium hurts");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.KIMMERIDGEBRACHYPTERAESCHNIDIUM_DEATH, "Kimmeridgebrachypteraeschnidium dies");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.KIMMERIDGEBRACHYPTERAESCHNIDIUM_LOOP, "Kimmeridgebrachypteraeschnidium buzzes");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.KIMMERIDGEBRACHYPTERAESCHNIDIUM_NYMPH_HURT, "Kimmeridgebrachypteraeschnidium Nymph hurts");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.KIMMERIDGEBRACHYPTERAESCHNIDIUM_NYMPH_DEATH, "Kimmeridgebrachypteraeschnidium Nymph dies");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.MAJUNGASAURUS_HURT, "Majungasaurus hurts");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.MAJUNGASAURUS_DEATH, "Majungasaurus dies");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.MAJUNGASAURUS_IDLE, "Majungasaurus groans");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.MAJUNGASAURUS_BITE, "Majungasaurus bites");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.MEGALANIA_HURT, "Megalania hurts");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.MEGALANIA_DEATH, "Megalania dies");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.MEGALANIA_IDLE, "Megalania hisses");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.MEGALANIA_ROAR, "Megalania roars");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.MEGALANIA_STEP, "Megalania steps");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.ONCHOPRISTIS_HURT, "Onchopristis hurts");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.ONCHOPRISTIS_DEATH, "Onchopristis dies");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.ONCHOPRISTIS_FLOP, "Onchopristis flops");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.STETHACANTHUS_HURT, "Stethacanthus hurts");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.STETHACANTHUS_DEATH, "Stethacanthus dies");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.STETHACANTHUS_FLOP, "Stethacanthus flops");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.TALPANAS_HURT, "Talpanas hurts");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.TALPANAS_DEATH, "Talpanas dies");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.TALPANAS_IDLE, "Talpanas quacks");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.TELECREX_HURT, "Telecrex hurts");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.TELECREX_DEATH, "Telecrex dies");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.TELECREX_IDLE, "Telecrex squawks");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.UNICORN_HURT, "Unicorn hurts");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.UNICORN_DEATH, "Unicorn dies");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.UNICORN_IDLE, "Unicorn grunts");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.TRANSMOGRIFIER_LOOP, "Transmogrifying");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.TRANSMOGRIFIER_START, "Transmogrifier starts");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.TRANSMOGRIFIER_STOP, "Transmogrifier stops");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.DOOMSURF_DISC, "Music Disc");
        this.musicDisc((Supplier<? extends Item>)UP2Items.DOOMSURF_DISC, "ChipsTheCat - Doomsurf");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.MEGALANIA_DISC, "Music Disc");
        this.musicDisc((Supplier<? extends Item>)UP2Items.MEGALANIA_DISC, "ValiantEnvoy - MEGALANIA");
        this.sound((Supplier<? extends SoundEvent>)UP2SoundEvents.TARIFYING_DISC, "Music Disc");
        this.musicDisc((Supplier<? extends Item>)UP2Items.TARIFYING_DISC, "Dylanvhs - Tarifying");
        this.translateAdvancement("root", "Unusual Prehistory 2", "Revive creatures from the ancient past!");
        this.translateAdvancement("hatch_carnotaurus", "Endless Fury", "Revive a Carnotaurus");
        this.translateAdvancement("hatch_diplocaulus", "Comes Right Back", "Revive a Diplocaulus");
        this.translateAdvancement("hatch_dromaeosaurus", "Dino Run", "Revive a Dromaeosaurus");
        this.translateAdvancement("hatch_dunkleosteus", "Definitely Not a Shark", "Revive a Dunkleosteus");
        this.translateAdvancement("hatch_jawless_fish", "No Chewing For You", "Revive a Jawless Fish");
        this.translateAdvancement("hatch_kentrosaurus", "Extra Pointy!", "Revive a Kentrosaurus");
        this.translateAdvancement("hatch_kimmeridgebrachypteraeschnidium", "The man on the street will not be able to remember this.", "Revive a Kimmeridgebrachypteraeschnidium");
        this.translateAdvancement("hatch_majungasaurus", "Camouflaging Cannibal", "Revive a Majungasaurus");
        this.translateAdvancement("hatch_megalania", "The Giant Goanna", "Revive a Megalania");
        this.translateAdvancement("hatch_onchopristis", "Cretaceous Chainsaw Massacre", "Revive an Onchopristis");
        this.translateAdvancement("hatch_stethacanthus", "Not Quite a Shark", "Revive a Stethacanthus");
        this.translateAdvancement("hatch_talpanas", "Blind as a Duck", "Revive a Talpanas");
        this.translateAdvancement("hatch_telecrex", "From a Singular Femur", "Revive a Telecrex");
        this.translateAdvancement("hatch_all_mobs", "Unusual Prehistorian", "Revive all known prehistoric creatures");
        this.translateAdvancement("revive_ginkgo", "Priest of Hiroshima", "Revive a Ginkgo Tree");
        this.translateAdvancement("revive_lepidodendron", "Have You Seen This Tree?", "Revive a Lepidodendron");
        this.translateAdvancement("pacify_mob", "Chill Pill", "Feed an Enchanted Golden Apple to an aggressive creature to make it permanently neutral");
        this.translateAdvancement("breed_holocene_mobs", "Repopulation!", "Breed a pair of Holocene animals");
        this.translateAdvancement("obtain_fossil", "Rock and Bone", "Use a Brush to uncover fossils at a Fossil Site or Tar Pit");
        this.translateAdvancement("obtain_holocene_remains", "Not So Ancient", "Find the remains of a recently extinct creature");
        this.translateAdvancement("obtain_machine_parts", "Electrical Doodads", "Find some Machine Parts in a loot chest");
        this.translateAdvancement("obtain_transmogrifier", "Jesse, We Have to Cook", "Craft a Transmogrifier, the key component in creature revival");
        this.translateAdvancement("obtain_organic_ooze", "It's Looking at Me...", "Craft some Organic Ooze to fuel the revival process");
        this.translateAdvancement("obtain_egg", "E G G S", "Recreate your first prehistoric egg or embryo");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.base_color_0", "Black Body");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.base_color_1", "Blue Body");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.base_color_2", "Brown Body");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.base_color_3", "Cyan Body");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.base_color_4", "Gray Body");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.base_color_5", "Green Body");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.base_color_6", "Light Blue Body");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.base_color_7", "Light Gray Body");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.base_color_8", "Lime Body");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.base_color_9", "Magenta Body");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.base_color_10", "Orange Body");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.base_color_11", "Pink Body");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.base_color_12", "Purple Body");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.base_color_13", "Red Body");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.base_color_14", "White Body");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.base_color_15", "Yellow Body");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.wing_color_0", "Black Wings");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.wing_color_1", "Blue Wings");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.wing_color_2", "Brown Wings");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.wing_color_3", "Cyan Wings");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.wing_color_4", "Gray Wings");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.wing_color_5", "Green Wings");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.wing_color_6", "Light Blue Wings");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.wing_color_7", "Light Gray Wings");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.wing_color_8", "Lime Wings");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.wing_color_9", "Magenta Wings");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.wing_color_10", "Orange Wings");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.wing_color_11", "Pink Wings");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.wing_color_12", "Purple Wings");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.wing_color_13", "Red Wings");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.wing_color_14", "White Wings");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.wing_color_15", "Yellow Wings");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.pattern_color_0", "Black");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.pattern_color_1", "Blue");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.pattern_color_2", "Brown");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.pattern_color_3", "Cyan");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.pattern_color_4", "Gray");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.pattern_color_5", "Green");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.pattern_color_6", "Light Blue");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.pattern_color_7", "Light Gray");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.pattern_color_8", "Lime");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.pattern_color_9", "Magenta");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.pattern_color_10", "Orange");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.pattern_color_11", "Pink");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.pattern_color_12", "Purple");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.pattern_color_13", "Red");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.pattern_color_14", "White");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.pattern_color_15", "Yellow");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.pattern_stripe", "Stripes");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.pattern_tailshade", "Tail");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.pattern_topshade", "Back");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.pattern_halfshade", "Duality");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.pattern_large_stripe", "Large Stripes");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.pattern_racing_stripe", "Racing Stripe");
        this.add("entity.unusual_prehistory.kimmeridgebrachypteraeschnidium.pattern_large_racing_stripe", "Large Racing Stripe");
        this.add("entity.unusual_prehistory.jawless_fish.variant_arandaspis", "Arandaspis");
        this.add("entity.unusual_prehistory.jawless_fish.variant_cephalaspis", "Cephalaspis");
        this.add("entity.unusual_prehistory.jawless_fish.variant_doryaspis", "Doryaspis");
        this.add("entity.unusual_prehistory.jawless_fish.variant_furcacauda", "Furcacauda");
        this.add("entity.unusual_prehistory.jawless_fish.variant_sacabambaspis", "Sacabambaspis");
        this.add("entity.unusual_prehistory.diplocaulus.variant_brevirostris", "D. brevirostris");
        this.add("entity.unusual_prehistory.diplocaulus.variant_magnicornis", "D. magnicornis");
        this.add("entity.unusual_prehistory.diplocaulus.variant_recurvatis", "D. recurvatis");
        this.add("entity.unusual_prehistory.diplocaulus.variant_salamandroides", "D. salamandroides");
        this.add("unusual_prehistory.jei.transmogrification", "Transmogrification");
        this.add("unusual_prehistory.jei.chiseling", "Chiseling");
        this.add("entity.unusual_prehistory.all.command_0", "%s is wandering");
        this.add("entity.unusual_prehistory.all.command_1", "%s is staying");
        this.add("entity.unusual_prehistory.all.command_2", "%s is following");
        this.add("item.unusual_prehistory.fossil_explorer_map", "Fossil Site Map");
        this.add("unusual_prehistory.patchouli.book.name", "Paleopedia");
        this.add("unusual_prehistory.patchouli.book.landing", "This book acts as a guide to the revival process of various ancient plants and animals, along with any notable traits or uses that they may have.");
        this.translateDamageType(UP2DamageTypes.TAR, player -> player + " suffocated in tar", (player, entity) -> player + " was suffocated in tar by " + entity);
    }

    private void forBlock(Supplier<? extends Block> block) {
        this.addBlock(block, UP2TextUtils.createTranslation(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block.get())).m_135815_()));
    }

    private void forItem(Supplier<? extends Item> item) {
        this.addItem(item, UP2TextUtils.createTranslation(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item.get())).m_135815_()));
    }

    private void forEntity(Supplier<? extends EntityType<?>> entity) {
        this.addEntityType(entity, UP2TextUtils.createTranslation(Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(entity.get())).m_135815_()));
    }

    private void translateDamageType(ResourceKey<DamageType> source, Function<String, String> death, BiFunction<String, String, String> killed) {
        String msgId = source.m_135782_().m_135815_();
        this.add("death.attack." + msgId, death.apply("%1$s"));
        this.add("death.attack." + msgId + ".player", killed.apply("%1$s", "%2$s"));
    }

    private String format(ResourceLocation registryName) {
        return WordUtils.capitalizeFully((String)registryName.m_135815_().replace("_", " "));
    }

    protected void painting(String name, String author) {
        this.add("painting.unusual_prehistory." + name + ".title", UP2TextUtils.createTranslation(name));
        this.add("painting.unusual_prehistory." + name + ".author", author);
    }

    protected void musicDisc(Supplier<? extends Item> item, String description) {
        String disc = item.get().m_5524_();
        this.add(disc, "Music Disc");
        this.add(disc + ".desc", description);
    }

    public void translateAdvancement(String key, String name, String desc) {
        this.add("advancement.unusual_prehistory." + key, name);
        this.add("advancement.unusual_prehistory." + key + ".desc", desc);
    }

    public void creativeTab(CreativeModeTab key, String name) {
        this.add(key.m_40786_().getString(), name);
    }

    public void sound(Supplier<? extends SoundEvent> key, String subtitle) {
        this.add("subtitles." + key.get().m_11660_().m_135815_(), subtitle);
    }
}

