/*
 * Decompiled with CFR 0.152.
 */
package com.barlinc.unusual_prehistory.entity.base;

import com.barlinc.unusual_prehistory.entity.ai.navigation.FlyingPathNavigationNoSpin;
import com.barlinc.unusual_prehistory.entity.ai.navigation.SmoothGroundPathNavigation;
import com.barlinc.unusual_prehistory.entity.base.PrehistoricMob;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class PrehistoricFlyingMob
extends PrehistoricMob
implements FlyingAnimal {
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.m_135353_(PrehistoricFlyingMob.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected float flyProgress;
    protected float prevFlyProgress;
    protected float groundProgress = 5.0f;
    protected float prevGroundProgress = 5.0f;
    public int timeFlying = 0;
    protected float flightPitch = 0.0f;
    protected float prevFlightPitch = 0.0f;
    protected float flightRoll = 0.0f;
    protected float prevFlightRoll = 0.0f;
    public int groundedFor = 0;
    public boolean isLandNavigator;
    public boolean landingFlag;
    public boolean useLowerFluidJumpThreshold = false;

    protected PrehistoricFlyingMob(EntityType<? extends PrehistoricFlyingMob> entityType, Level level) {
        super(entityType, level);
        this.f_21365_ = new FlyingLookControl(this);
        this.m_21530_();
    }

    @Override
    @NotNull
    protected BodyRotationControl m_7560_() {
        return new FlyingBodyRotationControl(this);
    }

    public void switchNavigator(boolean onLand) {
        if (onLand) {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = new SmoothGroundPathNavigation((Mob)this, this.m_9236_());
            this.isLandNavigator = true;
        } else {
            this.f_21342_ = new FlyingMoveController();
            this.f_21344_ = new FlyingPathNavigationNoSpin((Mob)this, this.m_9236_(), 1.0f);
            this.isLandNavigator = false;
        }
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double y, boolean onGround, @NotNull BlockState state, @NotNull BlockPos pos) {
    }

    public boolean canTrample(BlockState state, BlockPos pos, float fallDistance) {
        return false;
    }

    @Override
    public double m_20204_() {
        if (this.useLowerFluidJumpThreshold) {
            return super.m_20204_();
        }
        return 0.6 * (double)this.m_20206_();
    }

    private void setUseLowerFluidJumpThreshold(boolean jumpThreshold) {
        this.useLowerFluidJumpThreshold = jumpThreshold;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_20069_() && this.f_19862_) {
            this.setUseLowerFluidJumpThreshold(true);
        }
        if (this.m_29443_()) {
            this.m_20124_(Pose.FALL_FLYING);
        } else {
            this.m_20124_(Pose.STANDING);
        }
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_20072_() && !this.m_29443_()) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.1, 1.0));
        }
        super.m_7023_(travelVector);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.prevFlyProgress = this.flyProgress;
        this.prevGroundProgress = this.groundProgress;
        this.prevFlightPitch = this.flightPitch;
        this.prevFlightRoll = this.flightRoll;
        this.tickFlight();
        this.tickRotation((float)this.m_20184_().f_82480_ * 2.0f * -57.295776f);
    }

    public void tickFlight() {
        if (this.m_29443_() && this.flyProgress < 5.0f) {
            this.flyProgress += 1.0f;
        }
        if (!this.m_29443_() && this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (this.m_20096_() && this.groundProgress < 5.0f) {
            this.groundProgress += 1.0f;
        }
        if (!this.m_20096_() && this.groundProgress > 0.0f) {
            this.groundProgress -= 1.0f;
        }
        if (this.m_29443_()) {
            ++this.timeFlying;
            this.m_20242_(true);
            if (this.isLandNavigator) {
                this.switchNavigator(false);
            }
            if (this.groundedFor > 0) {
                this.setFlying(false);
            }
        } else {
            this.timeFlying = 0;
            this.m_20242_(false);
            if (!this.isLandNavigator) {
                this.switchNavigator(true);
            }
        }
        if (this.groundedFor > 0) {
            --this.groundedFor;
        }
        if (!this.m_9236_().f_46443_) {
            if (this.m_29443_() && this.m_6084_() && !this.m_20160_()) {
                if (this.landingFlag) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -0.1, 0.0));
                }
                if ((this.f_19862_ || this.m_20072_()) && !this.landingFlag) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, 0.05, 0.0));
                }
            }
            if (this.m_29443_() && this.timeFlying > 40 && this.m_20096_()) {
                this.setFlying(false);
            }
        }
    }

    public void tickRotation(float yMov) {
        this.flightPitch = yMov;
        float threshold = 1.0f;
        boolean flag = false;
        if (this.m_29443_() && this.f_19859_ - this.m_146908_() > threshold) {
            this.flightRoll += 10.0f;
            flag = true;
        }
        if (this.m_29443_() && this.f_19859_ - this.m_146908_() < -threshold) {
            this.flightRoll -= 10.0f;
            flag = true;
        }
        if (!flag) {
            if (this.flightRoll > 0.0f) {
                this.flightRoll = Math.max(this.flightRoll - 5.0f, 0.0f);
            }
            if (this.flightRoll < 0.0f) {
                this.flightRoll = Math.min(this.flightRoll + 5.0f, 0.0f);
            }
        }
        this.flightRoll = Mth.m_14036_((float)this.flightRoll, (float)-60.0f, (float)60.0f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLYING, (Object)false);
    }

    public boolean m_29443_() {
        return (Boolean)this.f_19804_.m_135370_(FLYING);
    }

    public void setFlying(boolean flying) {
        this.f_19804_.m_135381_(FLYING, (Object)flying);
    }

    public float getFlightPitch(float partialTick) {
        return this.prevFlightPitch + (this.flightPitch - this.prevFlightPitch) * partialTick;
    }

    public float getFlightRoll(float partialTick) {
        return this.prevFlightRoll + (this.flightRoll - this.prevFlightRoll) * partialTick;
    }

    public float getFlyProgress(float partialTick) {
        return (this.prevFlyProgress + (this.flyProgress - this.prevFlyProgress) * partialTick) * 0.2f;
    }

    public float getGroundProgress(float partialTick) {
        return (this.prevGroundProgress + (this.groundProgress - this.prevGroundProgress) * partialTick) * 0.2f;
    }

    public static class FlyingLookControl
    extends LookControl {
        protected final PrehistoricFlyingMob f_24937_;

        public FlyingLookControl(PrehistoricFlyingMob mob) {
            super((Mob)mob);
            this.f_24937_ = mob;
        }

        public void m_8128_() {
            if (!this.f_24937_.refuseToMove()) {
                super.m_8128_();
            }
        }
    }

    public static class FlyingBodyRotationControl
    extends BodyRotationControl {
        protected final PrehistoricFlyingMob f_24875_;

        public FlyingBodyRotationControl(PrehistoricFlyingMob mob) {
            super((Mob)mob);
            this.f_24875_ = mob;
        }

        public void m_8121_() {
            if (!this.f_24875_.refuseToMove()) {
                super.m_8121_();
            }
        }
    }

    public class FlyingMoveController
    extends MoveControl {
        private final Mob entity;

        public FlyingMoveController() {
            super((Mob)PrehistoricFlyingMob.this);
            this.entity = PrehistoricFlyingMob.this;
        }

        public void m_8126_() {
            if (!PrehistoricFlyingMob.this.refuseToMove() && this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 vector3d = new Vec3(this.f_24975_ - this.entity.m_20185_(), this.f_24976_ - this.entity.m_20186_(), this.f_24977_ - this.entity.m_20189_());
                double d0 = vector3d.m_82553_();
                double width = this.entity.m_20191_().m_82309_();
                Vec3 vector3d1 = vector3d.m_82490_(this.f_24978_ * 0.05 / d0);
                this.entity.m_20256_(this.entity.m_20184_().m_82549_(vector3d1).m_82490_(0.95).m_82520_(0.0, -0.01, 0.0));
                if (d0 < width) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                } else if (d0 >= width) {
                    float yaw = -((float)Mth.m_14136_((double)vector3d1.f_82479_, (double)vector3d1.f_82481_)) * 57.295776f;
                    this.entity.m_146922_(Mth.m_14148_((float)this.entity.m_146908_(), (float)yaw, (float)8.0f));
                }
            }
        }
    }
}

