/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.client.renderer;

import com.majorbonghits.moderncompanions.client.renderer.CompanionSkinManager;
import com.majorbonghits.moderncompanions.entity.AbstractHumanCompanionEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;

public class CompanionRenderer
extends HumanoidMobRenderer<AbstractHumanCompanionEntity, PlayerModel<AbstractHumanCompanionEntity>> {
    public CompanionRenderer(EntityRendererProvider.Context context) {
        super(context, (HumanoidModel)new PlayerModel(context.bakeLayer(ModelLayers.PLAYER), false), 0.5f);
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER_INNER_ARMOR)), new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR)), context.getModelManager()));
    }

    public void render(AbstractHumanCompanionEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        this.setModelProperties(entity);
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private void setModelProperties(AbstractHumanCompanionEntity companion) {
        PlayerModel model = (PlayerModel)this.getModel();
        HumanoidModel.ArmPose main = CompanionRenderer.armPose(companion, InteractionHand.MAIN_HAND);
        HumanoidModel.ArmPose off = CompanionRenderer.armPose(companion, InteractionHand.OFF_HAND);
        if (companion.getMainArm() == HumanoidArm.RIGHT) {
            model.rightArmPose = main;
            model.leftArmPose = off;
        } else {
            model.rightArmPose = off;
            model.leftArmPose = main;
        }
    }

    private static HumanoidModel.ArmPose armPose(AbstractHumanCompanionEntity companion, InteractionHand hand) {
        ItemStack stack = companion.getItemInHand(hand);
        if (stack.isEmpty()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (companion.getUsedItemHand() == hand && companion.getUseItemRemainingTicks() > 0) {
            UseAnim anim = stack.getUseAnimation();
            if (anim == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (anim == UseAnim.CROSSBOW && hand == companion.getUsedItemHand()) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
        } else if (!companion.swinging && stack.is(Items.CROSSBOW) && CrossbowItem.isCharged((ItemStack)stack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    public ResourceLocation getTextureLocation(AbstractHumanCompanionEntity entity) {
        ResourceLocation fallback = entity.getDefaultSkinTexture();
        return entity.getCustomSkinUrl().map(url -> CompanionSkinManager.getOrCreate(url, fallback)).orElse(fallback);
    }

    protected void scale(AbstractHumanCompanionEntity entity, PoseStack poseStack, float partialTickTime) {
        poseStack.scale(0.9375f, 0.9375f, 0.9375f);
    }
}

