/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.client.renderer;

import com.google.common.hash.Hashing;
import com.majorbonghits.moderncompanions.Constants;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;

public final class CompanionSkinManager {
    private static final Map<String, ResourceLocation> URL_CACHE = new ConcurrentHashMap<String, ResourceLocation>();
    private static final Set<String> IN_FLIGHT = ConcurrentHashMap.newKeySet();

    private CompanionSkinManager() {
    }

    public static ResourceLocation getOrCreate(String url, ResourceLocation fallback) {
        ResourceLocation cached = URL_CACHE.get(url);
        if (cached != null) {
            return cached;
        }
        if (IN_FLIGHT.add(url)) {
            CompletableFuture.runAsync(() -> CompanionSkinManager.downloadAndRegister(url, fallback), Util.backgroundExecutor());
        }
        return fallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadAndRegister(String url, ResourceLocation fallback) {
        String digest = Hashing.sha1().hashString((CharSequence)url, StandardCharsets.UTF_8).toString();
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"modern_companions", (String)("custom_skins/" + digest));
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection(Minecraft.getInstance().getProxy());
            conn.setDoInput(true);
            conn.setInstanceFollowRedirects(true);
            conn.setConnectTimeout(8000);
            conn.setReadTimeout(10000);
            int code = conn.getResponseCode();
            if (code / 100 != 2) {
                Constants.LOG.warn("Custom companion skin download failed (HTTP {}): {}", (Object)code, (Object)url);
                return;
            }
            InputStream in = conn.getInputStream();
            NativeImage image = NativeImage.read((InputStream)in);
            if (image == null) {
                Constants.LOG.warn("Custom companion skin download returned null image: {}", (Object)url);
                URL_CACHE.put(url, fallback);
                return;
            }
            int w = image.getWidth();
            int h = image.getHeight();
            if (w != 64 || h != 64 && h != 32) {
                Constants.LOG.warn("Custom companion skin has invalid size {}x{} (expected 64x64 or 64x32): {}", new Object[]{w, h, url});
                image.close();
                URL_CACHE.put(url, fallback);
                return;
            }
            NativeImage prepared = image;
            if (h == 32) {
                prepared = new NativeImage(64, 64, true);
                prepared.copyFrom(image);
                image.close();
                prepared.fillRect(0, 32, 64, 32, 0);
            }
            NativeImage readyImage = prepared;
            Minecraft.getInstance().execute(() -> {
                try {
                    TextureManager manager = Minecraft.getInstance().getTextureManager();
                    DynamicTexture dyn = new DynamicTexture(readyImage);
                    manager.register(location, (AbstractTexture)dyn);
                    URL_CACHE.put(url, location);
                }
                catch (IllegalStateException ex) {
                    Constants.LOG.warn("Failed to bind custom companion skin (image freed): {}", (Object)url, (Object)ex);
                    readyImage.close();
                    URL_CACHE.put(url, fallback);
                }
            });
        }
        catch (IOException io) {
            Constants.LOG.warn("Failed to download custom companion skin from {}", (Object)url, (Object)io);
            URL_CACHE.put(url, fallback);
        }
        finally {
            IN_FLIGHT.remove(url);
        }
    }
}

