/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.client.screen;

import com.majorbonghits.moderncompanions.entity.AbstractHumanCompanionEntity;
import com.majorbonghits.moderncompanions.menu.CompanionMenu;
import com.majorbonghits.moderncompanions.network.CompanionActionPayload;
import com.majorbonghits.moderncompanions.network.SetPatrolRadiusPayload;
import com.majorbonghits.moderncompanions.network.ToggleFlagPayload;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class CompanionScreen
extends AbstractContainerScreen<CompanionMenu> {
    private static final ResourceLocation BG = ResourceLocation.fromNamespaceAndPath((String)"modern_companions", (String)"textures/inventory_stats.png");
    private static final int BG_WIDTH = 345;
    private static final int BG_HEIGHT = 256;
    private static final ResourceLocation ALERT_BTN = ResourceLocation.fromNamespaceAndPath((String)"modern_companions", (String)"textures/alertbutton.png");
    private static final ResourceLocation HUNT_BTN = ResourceLocation.fromNamespaceAndPath((String)"modern_companions", (String)"textures/huntingbutton.png");
    private static final ResourceLocation PATROL_BTN = ResourceLocation.fromNamespaceAndPath((String)"modern_companions", (String)"textures/patrolbutton.png");
    private static final ResourceLocation CLEAR_BTN = ResourceLocation.fromNamespaceAndPath((String)"modern_companions", (String)"textures/clearbutton.png");
    private static final ResourceLocation PICKUP_BTN = ResourceLocation.fromNamespaceAndPath((String)"modern_companions", (String)"textures/pickupbutton.png");
    private static final ResourceLocation SPRINT_BTN = ResourceLocation.fromNamespaceAndPath((String)"modern_companions", (String)"textures/stationerybutton.png");
    private static final ResourceLocation RELEASE_BTN = ResourceLocation.fromNamespaceAndPath((String)"modern_companions", (String)"textures/releasebutton.png");
    private static final int TOP_STATS_LEFT = 229;
    private static final int TOP_STATS_TOP = 7;
    private static final int TOP_STATS_RIGHT = 327;
    private static final int ATTR_LEFT = 228;
    private static final int ATTR_TOP = 137;
    private static final int ATTR_RIGHT = 326;
    private static final int ATTR_BOTTOM = 194;
    private static final int FOOD_LEFT = 228;
    private static final int FOOD_TOP = 215;
    private static final int FOOD_RIGHT = 327;
    private static final int FOOD_BOTTOM = 236;
    private CompanionButton alertButton;
    private CompanionButton huntButton;
    private CompanionButton patrolButton;
    private CompanionButton sprintButton;
    private CompanionButton clearButton;
    private CompanionButton pickupButton;
    private CompanionButton releaseButton;
    private CompanionButton radiusMinus;
    private CompanionButton radiusPlus;
    private int sidebarX;

    public CompanionScreen(CompanionMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.imageWidth = 345;
        this.imageHeight = 256;
        this.inventoryLabelY = this.imageHeight - 94;
        this.sidebarX = 174;
    }

    protected void init() {
        super.init();
        ++this.topPos;
        int rowHeight = 15;
        int row1 = this.topPos + 66;
        int row2 = row1 + rowHeight;
        int row3 = row2 + rowHeight;
        int col1 = this.leftPos + this.sidebarX + 3;
        int col2 = col1 + 19;
        this.alertButton = (CompanionButton)this.addRenderableWidget((GuiEventListener)new CompanionButton("alert", col1, row1, 16, 12, 0, 0, 13, ALERT_BTN, () -> this.sendToggle("alert"), true));
        this.huntButton = (CompanionButton)this.addRenderableWidget((GuiEventListener)new CompanionButton("hunting", col2, row1, 16, 12, 0, 0, 13, HUNT_BTN, () -> this.sendToggle("hunt"), true));
        this.patrolButton = (CompanionButton)this.addRenderableWidget((GuiEventListener)new CompanionButton("patrolling", col1, row2, 16, 12, 0, 0, 13, PATROL_BTN, () -> this.sendAction("cycle_orders"), true));
        this.sprintButton = (CompanionButton)this.addRenderableWidget((GuiEventListener)new CompanionButton("sprint", col2, row2, 16, 12, 0, 0, 13, SPRINT_BTN, () -> this.sendToggle("sprint"), true));
        this.clearButton = (CompanionButton)this.addRenderableWidget((GuiEventListener)new CompanionButton("clear", this.leftPos + this.sidebarX + 5, row3, 31, 12, 0, 0, 13, CLEAR_BTN, () -> this.sendAction("clear_target"), false));
        int row4 = row3 + rowHeight;
        this.pickupButton = (CompanionButton)this.addRenderableWidget((GuiEventListener)new CompanionButton("pickup", this.leftPos + this.sidebarX + 3, row4, 34, 12, 0, 0, 0, PICKUP_BTN, () -> this.sendToggle("pickup"), true));
        this.releaseButton = (CompanionButton)this.addRenderableWidget((GuiEventListener)new CompanionButton("release", this.leftPos + this.sidebarX + 3, this.topPos + 148, 34, 12, 0, 0, 13, RELEASE_BTN, () -> {
            this.sendAction("release");
            this.onClose();
        }, false));
        int radiusY = this.topPos + 148 + 16;
        ResourceLocation radiusTex = ResourceLocation.fromNamespaceAndPath((String)"modern_companions", (String)"textures/gui/radiusbutton.png");
        this.radiusMinus = (CompanionButton)this.addRenderableWidget((GuiEventListener)new CompanionButton("radius-", this.leftPos + this.sidebarX + 3, radiusY, 16, 12, 17, 0, 13, radiusTex, () -> this.adjustRadius(-2), false));
        this.radiusPlus = (CompanionButton)this.addRenderableWidget((GuiEventListener)new CompanionButton("radius+", this.leftPos + this.sidebarX + 21, radiusY, 16, 12, 0, 0, 13, radiusTex, () -> this.adjustRadius(2), false));
    }

    protected void renderBg(GuiGraphics gfx, float partialTick, int mouseX, int mouseY) {
        int x = this.leftPos;
        int y = this.topPos;
        gfx.blit(BG, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 345, 256);
    }

    protected void renderLabels(GuiGraphics gfx, int mouseX, int mouseY) {
        this.safeCompanion().ifPresent(companion -> {
            int statsX = 233;
            int statsWidth = 90;
            int y = 9;
            gfx.drawString(this.font, (Component)Component.literal((String)"Class").withStyle(ChatFormatting.UNDERLINE), statsX, y, 0, false);
            String cls = companion.getClassDisplayName();
            gfx.drawString(this.font, (Component)Component.literal((String)cls), statsX, y += 10, 0, false);
            gfx.drawString(this.font, (Component)Component.literal((String)"Health").withStyle(ChatFormatting.UNDERLINE), statsX, y += 12, 0, false);
            gfx.drawString(this.font, (Component)Component.literal((String)String.format("%.1f / %d", Float.valueOf(companion.getHealth()), (int)companion.getMaxHealth())), statsX, y += 10, 0, false);
            float xpFrac = companion.getExperienceProgress();
            int xpNeeded = companion.getXpNeededForNextLevel();
            int xpHave = Math.round(xpFrac * (float)xpNeeded);
            gfx.drawString(this.font, (Component)Component.literal((String)("Level " + companion.getExpLvl())), statsX, y += 12, 0, false);
            int barW = Math.max(60, Math.min(90, statsWidth));
            int barH = 6;
            int filledW = (int)((float)barW * xpFrac);
            gfx.fill(statsX, y += 10, statsX + barW, y + barH, -8947849);
            gfx.fill(statsX + 1, y + 1, statsX + 1 + filledW, y + barH - 1, -11163051);
            gfx.drawString(this.font, (Component)Component.literal((String)(xpHave + "/" + xpNeeded)), statsX, y += 10, 0, false);
            gfx.drawString(this.font, (Component)Component.literal((String)("Kills: " + companion.getKillCount())), statsX, y += 12, 0, false);
            gfx.drawString(this.font, (Component)Component.literal((String)("Patrol Radius: " + companion.getPatrolRadius())), statsX, y += 12, 0, false);
            this.renderAttributes(gfx, (AbstractHumanCompanionEntity)((Object)companion));
            this.renderWantedFood(gfx, (AbstractHumanCompanionEntity)((Object)companion));
        });
    }

    public void containerTick() {
        super.containerTick();
    }

    private void sendToggle(String flag) {
        Minecraft mc = Minecraft.getInstance();
        if (mc == null || mc.getConnection() == null) {
            return;
        }
        this.safeCompanion().ifPresent(companion -> {
            boolean newValue = !companion.getFlagValue(flag);
            mc.getConnection().send((Packet)new ServerboundCustomPayloadPacket((CustomPacketPayload)new ToggleFlagPayload(((CompanionMenu)this.menu).getCompanionId(), flag, newValue)));
            companion.applyFlag(flag, newValue);
        });
    }

    private void sendAction(String action) {
        Minecraft mc = Minecraft.getInstance();
        if (mc == null || mc.getConnection() == null) {
            return;
        }
        mc.getConnection().send((Packet)new ServerboundCustomPayloadPacket((CustomPacketPayload)new CompanionActionPayload(((CompanionMenu)this.menu).getCompanionId(), action)));
    }

    private void adjustRadius(int delta) {
        Minecraft mc = Minecraft.getInstance();
        if (mc == null || mc.getConnection() == null) {
            return;
        }
        this.safeCompanion().ifPresent(companion -> {
            int target = Math.max(2, Math.min(32, companion.getPatrolRadius() + delta));
            mc.getConnection().send((Packet)new ServerboundCustomPayloadPacket((CustomPacketPayload)new SetPatrolRadiusPayload(((CompanionMenu)this.menu).getCompanionId(), target)));
            companion.setPatrolRadius(target);
        });
    }

    private Optional<AbstractHumanCompanionEntity> safeCompanion() {
        Entity e;
        AbstractHumanCompanionEntity c = ((CompanionMenu)this.menu).getCompanion();
        if (c == null && this.minecraft != null && this.minecraft.level != null && (e = this.minecraft.level.getEntity(((CompanionMenu)this.menu).getCompanionId())) instanceof AbstractHumanCompanionEntity) {
            AbstractHumanCompanionEntity comp;
            c = comp = (AbstractHumanCompanionEntity)e;
        }
        return Optional.ofNullable(c);
    }

    private void renderAttributes(GuiGraphics gfx, AbstractHumanCompanionEntity companion) {
        int x = 231;
        int y = 140;
        int width = 92;
        this.drawStatLine(gfx, x, y, width, "Strength", companion.getStrength(), this.isSpecialist(companion, 0));
        this.drawStatLine(gfx, x, y += 10, width, "Dexterity", companion.getDexterity(), this.isSpecialist(companion, 1));
        this.drawStatLine(gfx, x, y += 10, width, "Intelligence", companion.getIntelligence(), this.isSpecialist(companion, 2));
        this.drawStatLine(gfx, x, y += 10, width, "Endurance", companion.getEndurance(), this.isSpecialist(companion, 3));
    }

    private void drawStatLine(GuiGraphics gfx, int x, int y, int width, String name, int value, boolean highlight) {
        String line = name + ": " + value + (highlight ? " \u2605" : "");
        int color = highlight ? 16766287 : 0;
        for (FormattedCharSequence seq : this.font.split((FormattedText)Component.literal((String)line), width)) {
            gfx.drawString(this.font, seq, x, y, color, false);
            if ((y += 10) <= 194) continue;
            break;
        }
    }

    private boolean isSpecialist(AbstractHumanCompanionEntity companion, int idx) {
        return companion.getSpecialistAttributeIndex() == idx;
    }

    private void renderWantedFood(GuiGraphics gfx, AbstractHumanCompanionEntity companion) {
        int foodX = 230;
        int foodY = 217;
        int foodWidth = 95;
        String food = companion.getFoodStatusForGui();
        if (food.isEmpty()) {
            food = "Not Hungry";
        }
        for (FormattedCharSequence line : this.font.split((FormattedText)Component.literal((String)food), foodWidth)) {
            gfx.drawString(this.font, line, foodX, foodY, 0, false);
            if ((foodY += 10) <= 236) continue;
            break;
        }
    }

    private class CompanionButton
    extends Button {
        private final String name;
        private int yTexStart;
        private final int yDiffTex;
        private final ResourceLocation texture;
        private final boolean toggleFlag;
        private final int baseY;
        private int xTexStart;

        CompanionButton(String name, int x, int y, int w, int h, int xTexStart, int yTexStart, int yDiffTex, ResourceLocation texture, Runnable onClick, boolean toggleFlag) {
            super(x, y, w, h, (Component)Component.empty(), b -> onClick.run(), DEFAULT_NARRATION);
            this.name = name;
            this.xTexStart = xTexStart;
            this.yTexStart = yTexStart;
            this.baseY = yTexStart;
            this.yDiffTex = yDiffTex;
            this.texture = texture;
            this.toggleFlag = toggleFlag;
        }

        public void renderWidget(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
            this.updateTex();
            int v = this.yTexStart;
            if (this.toggleFlag) {
                v = this.isHoveredOrFocused() ? this.yTexStart + this.yDiffTex : this.yTexStart;
            } else if (this.isHoveredOrFocused()) {
                v = this.yTexStart + this.yDiffTex;
            }
            RenderSystem.enableBlend();
            gfx.blit(this.texture, this.getX(), this.getY(), (float)this.xTexStart, (float)v, this.width, this.height, 256, 256);
            RenderSystem.disableBlend();
        }

        private void updateTex() {
            AbstractHumanCompanionEntity c = CompanionScreen.this.safeCompanion().orElse(null);
            this.yTexStart = this.baseY;
            switch (this.name) {
                case "alert": {
                    this.xTexStart = this.flag(c != null && c.isAlert(), 0, 17);
                    break;
                }
                case "hunting": {
                    this.xTexStart = this.flag(c != null && c.isHunting(), 0, 17);
                    break;
                }
                case "sprint": {
                    this.xTexStart = this.flag(c != null && c.isSprintEnabled(), 0, 17);
                    break;
                }
                case "pickup": {
                    boolean on = c != null && c.isPickupEnabled();
                    this.xTexStart = 0;
                    this.yTexStart = on ? this.baseY + 13 : this.baseY;
                    break;
                }
                case "patrolling": {
                    if (c == null) {
                        this.xTexStart = 0;
                        break;
                    }
                    if (c.isFollowing()) {
                        this.xTexStart = 0;
                        break;
                    }
                    if (c.isPatrolling()) {
                        this.xTexStart = 17;
                        break;
                    }
                    this.xTexStart = 34;
                    break;
                }
                case "radius+": {
                    this.xTexStart = 0;
                    break;
                }
                case "radius-": {
                    this.xTexStart = 17;
                    break;
                }
                default: {
                    this.xTexStart = 0;
                }
            }
        }

        private int flag(boolean value, int on, int off) {
            return value ? on : off;
        }
    }
}

