/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.command;

import com.majorbonghits.moderncompanions.entity.AbstractHumanCompanionEntity;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

@EventBusSubscriber(modid="modern_companions", bus=EventBusSubscriber.Bus.GAME)
public final class ModCommands {
    private static final String LOCATE_CMD = "locate structure #modern_companions:companion_houses";

    private ModCommands() {
    }

    @SubscribeEvent
    public static void register(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"locatecompanionhouse").requires(src -> src.hasPermission(2))).executes(ctx -> ModCommands.forwardLocate((CommandSourceStack)ctx.getSource())));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"locatecompanions").requires(src -> src.hasPermission(2))).executes(ctx -> ModCommands.forwardLocate((CommandSourceStack)ctx.getSource())));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"companionskin").requires(src -> src.getEntity() instanceof ServerPlayer)).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"url", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> ModCommands.setCompanionSkin((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), StringArgumentType.getString((CommandContext)ctx, (String)"url"))))));
    }

    private static int forwardLocate(CommandSourceStack source) {
        source.getServer().getCommands().performPrefixedCommand(source, LOCATE_CMD);
        return 1;
    }

    private static int setCompanionSkin(CommandSourceStack source, String name, String url) {
        ServerPlayer player = Objects.requireNonNull(source.getPlayer());
        if (!ModCommands.isHttpUrl(url)) {
            source.sendFailure((Component)Component.literal((String)"Skin URL must start with http:// or https://"));
            return 0;
        }
        AbstractHumanCompanionEntity companion = ModCommands.findOwnedCompanion(source, player, name);
        if (companion == null) {
            source.sendFailure((Component)Component.literal((String)("No owned companion named \"" + name + "\" was found.")));
            return 0;
        }
        companion.setCustomSkinUrl(url);
        source.sendSuccess(() -> Component.literal((String)("Updated skin for " + companion.getName().getString() + " using " + url)), false);
        return 1;
    }

    private static AbstractHumanCompanionEntity findOwnedCompanion(CommandSourceStack source, ServerPlayer player, String name) {
        String targetName = name.trim();
        for (ServerLevel level : source.getServer().getAllLevels()) {
            for (Entity entity : level.getEntities().getAll()) {
                AbstractHumanCompanionEntity companion;
                if (!(entity instanceof AbstractHumanCompanionEntity) || !targetName.equalsIgnoreCase((companion = (AbstractHumanCompanionEntity)entity).getName().getString()) || !companion.isOwnedBy((LivingEntity)player) && !source.hasPermission(2)) continue;
                return companion;
            }
        }
        return null;
    }

    private static boolean isHttpUrl(String raw) {
        try {
            URL parsed = new URL(raw);
            String protocol = parsed.getProtocol();
            return protocol.equals("http") || protocol.equals("https");
        }
        catch (MalformedURLException e) {
            return false;
        }
    }
}

