/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.compat;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public final class BeastmasterPetHudUtil {
    public static final String KEY_OWNER_NAME = "mc_beast_owner";

    private BeastmasterPetHudUtil() {
    }

    public static boolean isBeastmasterPet(Entity entity) {
        LivingEntity living;
        return entity instanceof LivingEntity && (living = (LivingEntity)entity).getPersistentData().hasUUID("BeastmasterOwner");
    }

    public static boolean writeOwnerName(CompoundTag tag, LivingEntity pet) {
        String ownerName = BeastmasterPetHudUtil.resolveOwnerName(pet);
        if (ownerName != null && !ownerName.isEmpty()) {
            tag.putString(KEY_OWNER_NAME, ownerName);
            return true;
        }
        return false;
    }

    @Nullable
    public static String resolveOwnerName(LivingEntity pet) {
        Level level = pet.level();
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel server = (ServerLevel)level;
        if (!pet.getPersistentData().hasUUID("BeastmasterOwner")) {
            return null;
        }
        UUID masterId = pet.getPersistentData().getUUID("BeastmasterOwner");
        Entity master = server.getEntity(masterId);
        return master != null ? master.getDisplayName().getString() : null;
    }
}

