/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.compat.jade;

import com.majorbonghits.moderncompanions.compat.CompanionTooltipUtil;
import com.majorbonghits.moderncompanions.entity.AbstractHumanCompanionEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum CompanionJadeProvider implements IEntityComponentProvider,
IServerDataProvider<EntityAccessor>
{
    INSTANCE;

    private static final ResourceLocation UID;

    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        Entity entity = accessor.getEntity();
        if (!(entity instanceof AbstractHumanCompanionEntity)) {
            return;
        }
        AbstractHumanCompanionEntity companion = (AbstractHumanCompanionEntity)entity;
        CompoundTag data = accessor.getServerData();
        int str = CompanionTooltipUtil.readOrFallback(data, "mc_str", companion.getStrength());
        int dex = CompanionTooltipUtil.readOrFallback(data, "mc_dex", companion.getDexterity());
        int intel = CompanionTooltipUtil.readOrFallback(data, "mc_int", companion.getIntelligence());
        int end = CompanionTooltipUtil.readOrFallback(data, "mc_end", companion.getEndurance());
        Component line = CompanionTooltipUtil.buildAttributesLine(str, dex, intel, end);
        tooltip.add(line);
    }

    public void appendServerData(CompoundTag tag, EntityAccessor accessor) {
        Entity entity = accessor.getEntity();
        if (entity instanceof AbstractHumanCompanionEntity) {
            AbstractHumanCompanionEntity companion = (AbstractHumanCompanionEntity)entity;
            CompanionTooltipUtil.writeAttributes(tag, companion);
        }
    }

    public ResourceLocation getUid() {
        return UID;
    }

    static {
        UID = ResourceLocation.fromNamespaceAndPath((String)"modern_companions", (String)"companion_attributes");
    }
}

