/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.core;

import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public final class ModConfig {
    public static ModConfigSpec.IntValue AVERAGE_HOUSE_SEPARATION;
    public static ModConfigSpec.BooleanValue FRIENDLY_FIRE_COMPANIONS;
    public static ModConfigSpec.BooleanValue FRIENDLY_FIRE_PLAYER;
    public static ModConfigSpec.BooleanValue FALL_DAMAGE;
    public static ModConfigSpec.BooleanValue SPAWN_ARMOR;
    public static ModConfigSpec.BooleanValue SPAWN_WEAPON;
    public static ModConfigSpec.IntValue BASE_HEALTH;
    public static ModConfigSpec.BooleanValue LOW_HEALTH_FOOD;
    public static ModConfigSpec.BooleanValue CREEPER_WARNING;

    private ModConfig() {
    }

    public static <T> T safeGet(ModConfigSpec.ConfigValue<T> value) {
        try {
            return (T)value.get();
        }
        catch (IllegalStateException ex) {
            return (T)value.getDefault();
        }
    }

    public static void register() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.comment("Settings for world gen (data packs recommended in 1.21.1)").push("worldgen");
        AVERAGE_HOUSE_SEPARATION = builder.comment("Average chunk separation between companion houses").defineInRange("averageHouseSeparation", 20, 11, Integer.MAX_VALUE);
        builder.pop();
        builder.push("companion");
        FRIENDLY_FIRE_COMPANIONS = builder.comment("Whether companions can hurt each other").define("friendlyFireCompanions", false);
        FRIENDLY_FIRE_PLAYER = builder.comment("Whether companion can damage the owning player").define("friendlyFirePlayer", true);
        FALL_DAMAGE = builder.comment("Whether companions take fall damage").define("fallDamage", true);
        SPAWN_ARMOR = builder.comment("Whether companions spawn with random armor").define("spawnArmor", true);
        SPAWN_WEAPON = builder.comment("Whether companions spawn with a weapon").define("spawnWeapon", true);
        BASE_HEALTH = builder.comment("Base health for companions; a small random variance is applied on spawn").defineInRange("baseHealth", 20, 5, Integer.MAX_VALUE);
        LOW_HEALTH_FOOD = builder.comment("If true, companions ask for food when below half health").define("lowHealthFood", true);
        CREEPER_WARNING = builder.comment("If true, companions warn the player about nearby creepers").define("creeperWarning", true);
        builder.pop();
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)builder.build());
    }
}

