/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.entity;

import com.majorbonghits.moderncompanions.core.ModConfig;
import com.majorbonghits.moderncompanions.core.ModEnchantments;
import com.majorbonghits.moderncompanions.core.ModItems;
import com.majorbonghits.moderncompanions.entity.Beastmaster;
import com.majorbonghits.moderncompanions.entity.CompanionData;
import com.majorbonghits.moderncompanions.entity.SummonedWitherSkeleton;
import com.majorbonghits.moderncompanions.entity.ai.AlertGoal;
import com.majorbonghits.moderncompanions.entity.ai.AvoidCreeperGoal;
import com.majorbonghits.moderncompanions.entity.ai.CustomFollowOwnerGoal;
import com.majorbonghits.moderncompanions.entity.ai.CustomHurtByTargetGoal;
import com.majorbonghits.moderncompanions.entity.ai.CustomOwnerHurtByTargetGoal;
import com.majorbonghits.moderncompanions.entity.ai.CustomOwnerHurtTargetGoal;
import com.majorbonghits.moderncompanions.entity.ai.CustomWaterAvoidingRandomStrollGoal;
import com.majorbonghits.moderncompanions.entity.ai.EatGoal;
import com.majorbonghits.moderncompanions.entity.ai.HuntGoal;
import com.majorbonghits.moderncompanions.entity.ai.LowHealthGoal;
import com.majorbonghits.moderncompanions.entity.ai.MoveBackToGuardGoal;
import com.majorbonghits.moderncompanions.entity.ai.MoveBackToPatrolGoal;
import com.majorbonghits.moderncompanions.entity.ai.PatrolGoal;
import com.majorbonghits.moderncompanions.item.ResurrectionScrollItem;
import com.majorbonghits.moderncompanions.menu.CompanionMenu;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractHumanCompanionEntity
extends TamableAnimal {
    private static final EntityDataAccessor<Integer> SKIN_VARIANT = SynchedEntityData.defineId(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SEX = SynchedEntityData.defineId(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> BASE_HEALTH = SynchedEntityData.defineId(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> EXP_LVL = SynchedEntityData.defineId(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<String> CUSTOM_SKIN_URL = SynchedEntityData.defineId(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Integer> STR = SynchedEntityData.defineId(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DEX = SynchedEntityData.defineId(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> INTL = SynchedEntityData.defineId(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> END = SynchedEntityData.defineId(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> KILL_COUNT = SynchedEntityData.defineId(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> EATING = SynchedEntityData.defineId(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> LAST_SWING_TICK = SynchedEntityData.defineId(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> ALERT = SynchedEntityData.defineId(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HUNTING = SynchedEntityData.defineId(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> PATROLLING = SynchedEntityData.defineId(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> FOLLOWING = SynchedEntityData.defineId(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> GUARDING = SynchedEntityData.defineId(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SPRINT_ENABLED = SynchedEntityData.defineId(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> PICKUP_ITEMS = SynchedEntityData.defineId(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Optional<BlockPos>> PATROL_POS = SynchedEntityData.defineId(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private static final EntityDataAccessor<Integer> PATROL_RADIUS = SynchedEntityData.defineId(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<String> FOOD1 = SynchedEntityData.defineId(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<String> FOOD2 = SynchedEntityData.defineId(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Integer> FOOD1_AMT = SynchedEntityData.defineId(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> FOOD2_AMT = SynchedEntityData.defineId(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> EXP_PROGRESS = SynchedEntityData.defineId(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> SPECIALIST = SynchedEntityData.defineId(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final int FOOD_REQUEST_COOLDOWN_TICKS = 600;
    protected final SimpleContainer inventory = new SimpleContainer(54);
    protected final Map<Item, Integer> foodRequirements = new HashMap<Item, Integer>();
    protected final Random rand = new Random();
    public PatrolGoal patrolGoal;
    public MoveBackToPatrolGoal moveBackGoal;
    private int lastFoodRequestTick = -200;
    private int specialistAttr = -1;
    private int totalExperience;
    private float experienceProgress;
    private int lastLevelUpTime;
    private int equipmentStrengthBonus;
    private int equipmentDexterityBonus;
    private int equipmentIntelligenceBonus;
    private int equipmentEnduranceBonus;
    private int lastAppliedSwingTick = -1;

    protected AbstractHumanCompanionEntity(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
        this.setTame(false, false);
        PathNavigation pathNavigation = this.getNavigation();
        if (pathNavigation instanceof GroundPathNavigation) {
            GroundPathNavigation nav = (GroundPathNavigation)pathNavigation;
            nav.setCanOpenDoors(true);
            nav.setCanFloat(true);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        double baseHealth = ModConfig.BASE_HEALTH != null ? ((Integer)ModConfig.safeGet(ModConfig.BASE_HEALTH)).doubleValue() : 20.0;
        return TamableAnimal.createMobAttributes().add(Attributes.FOLLOW_RANGE, 20.0).add(Attributes.MAX_HEALTH, baseHealth).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.MOVEMENT_SPEED, 0.32).add(Attributes.ATTACK_SPEED, 1.6).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SKIN_VARIANT, (Object)0);
        builder.define(SEX, (Object)0);
        builder.define(BASE_HEALTH, (Object)((Integer)ModConfig.safeGet(ModConfig.BASE_HEALTH)));
        builder.define(EXP_LVL, (Object)0);
        builder.define(EATING, (Object)false);
        builder.define(ALERT, (Object)false);
        builder.define(HUNTING, (Object)false);
        builder.define(PATROLLING, (Object)false);
        builder.define(FOLLOWING, (Object)false);
        builder.define(GUARDING, (Object)false);
        builder.define(SPRINT_ENABLED, (Object)false);
        builder.define(PICKUP_ITEMS, (Object)true);
        builder.define(PATROL_POS, Optional.empty());
        builder.define(PATROL_RADIUS, (Object)10);
        builder.define(FOOD1, (Object)"");
        builder.define(FOOD2, (Object)"");
        builder.define(FOOD1_AMT, (Object)0);
        builder.define(FOOD2_AMT, (Object)0);
        builder.define(EXP_PROGRESS, (Object)Float.valueOf(0.0f));
        builder.define(STR, (Object)4);
        builder.define(DEX, (Object)4);
        builder.define(INTL, (Object)4);
        builder.define(END, (Object)4);
        builder.define(SPECIALIST, (Object)-1);
        builder.define(KILL_COUNT, (Object)0);
        builder.define(CUSTOM_SKIN_URL, (Object)"");
        builder.define(LAST_SWING_TICK, (Object)0);
    }

    public void swing(InteractionHand hand) {
        this.swing(hand, true);
    }

    public void swing(InteractionHand hand, boolean updateSelf) {
        this.swinging = false;
        this.swingTime = -1;
        super.swing(hand, true);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(0, (Goal)new EatGoal(this));
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new AvoidCreeperGoal(this, 1.5, 1.5));
        this.goalSelector.addGoal(3, (Goal)new MoveBackToGuardGoal(this));
        this.goalSelector.addGoal(3, (Goal)new CustomFollowOwnerGoal(this, 1.3, 8.0f, 2.5f, true));
        this.goalSelector.addGoal(4, (Goal)new CustomWaterAvoidingRandomStrollGoal(this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new OpenDoorGoal((Mob)this, true));
        this.goalSelector.addGoal(8, (Goal)new LowHealthGoal(this));
        this.patrolGoal = new PatrolGoal(this, 60, this.getPatrolRadius());
        this.moveBackGoal = new MoveBackToPatrolGoal(this, this.getPatrolRadius());
        this.goalSelector.addGoal(3, (Goal)this.moveBackGoal);
        this.goalSelector.addGoal(3, (Goal)this.patrolGoal);
        this.targetSelector.addGoal(1, (Goal)new CustomOwnerHurtByTargetGoal(this));
        this.targetSelector.addGoal(2, (Goal)new CustomOwnerHurtTargetGoal(this));
        this.targetSelector.addGoal(3, (Goal)new CustomHurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new HuntGoal(this));
        this.targetSelector.addGoal(5, (Goal)new AlertGoal(this));
    }

    public boolean isFollowing() {
        return (Boolean)this.entityData.get(FOLLOWING);
    }

    public void setFollowing(boolean value) {
        this.entityData.set(FOLLOWING, (Object)value);
    }

    public boolean isPatrolling() {
        return (Boolean)this.entityData.get(PATROLLING);
    }

    public void setPatrolling(boolean value) {
        this.entityData.set(PATROLLING, (Object)value);
    }

    public boolean isGuarding() {
        return (Boolean)this.entityData.get(GUARDING);
    }

    public void setGuarding(boolean value) {
        this.entityData.set(GUARDING, (Object)value);
    }

    public boolean isPickupEnabled() {
        return (Boolean)this.entityData.get(PICKUP_ITEMS);
    }

    public void setPickupEnabled(boolean value) {
        this.entityData.set(PICKUP_ITEMS, (Object)value);
    }

    public boolean isSprintEnabled() {
        return (Boolean)this.entityData.get(SPRINT_ENABLED);
    }

    public void setSprintEnabled(boolean value) {
        this.entityData.set(SPRINT_ENABLED, (Object)value);
    }

    public boolean isAlert() {
        return (Boolean)this.entityData.get(ALERT);
    }

    public void setAlert(boolean value) {
        this.entityData.set(ALERT, (Object)value);
    }

    public boolean isHunting() {
        return (Boolean)this.entityData.get(HUNTING);
    }

    public void setHunting(boolean value) {
        this.entityData.set(HUNTING, (Object)value);
    }

    public Optional<BlockPos> getPatrolPos() {
        return (Optional)this.entityData.get(PATROL_POS);
    }

    public void setPatrolPos(@Nullable BlockPos pos) {
        this.entityData.set(PATROL_POS, Optional.ofNullable(pos));
    }

    public int getPatrolRadius() {
        return (Integer)this.entityData.get(PATROL_RADIUS);
    }

    public String getClassDisplayName() {
        ResourceLocation key = BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.getType());
        if (key == null) {
            return "Companion";
        }
        String path = key.getPath().replace('_', ' ');
        StringBuilder builder = new StringBuilder();
        for (String part : path.split(" ")) {
            if (part.isEmpty()) continue;
            builder.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1)).append(' ');
        }
        return builder.toString().trim();
    }

    public void setPatrolRadius(int radius) {
        this.entityData.set(PATROL_RADIUS, (Object)Mth.clamp((int)radius, (int)1, (int)64));
        if (this.patrolGoal != null) {
            this.patrolGoal.radius = radius;
        }
        if (this.moveBackGoal != null) {
            this.moveBackGoal.radius = radius;
        }
    }

    public void clearPatrol() {
        this.setPatrolPos(null);
        this.setPatrolling(false);
        this.setPatrolRadius(4);
    }

    public String getFoodStatus() {
        String f1 = (Integer)this.entityData.get(FOOD1_AMT) > 0 ? String.valueOf(this.entityData.get(FOOD1_AMT)) + "x " + (String)this.entityData.get(FOOD1) : "done";
        String f2 = (Integer)this.entityData.get(FOOD2_AMT) > 0 ? String.valueOf(this.entityData.get(FOOD2_AMT)) + "x " + (String)this.entityData.get(FOOD2) : "done";
        return "Wants: " + f1 + " and " + f2;
    }

    public String getFoodStatusForGui() {
        if (!this.isTame()) {
            return this.getWantedFoodsCompact();
        }
        if (this.getHealth() < this.getMaxHealth() - 0.5f) {
            return this.hasFoodInInventory() ? "Healing..." : "Needs food to heal";
        }
        return "";
    }

    public String getWantedFoodsCompact() {
        String second;
        int amt1 = (Integer)this.entityData.get(FOOD1_AMT);
        int amt2 = (Integer)this.entityData.get(FOOD2_AMT);
        String id1 = (String)this.entityData.get(FOOD1);
        String id2 = (String)this.entityData.get(FOOD2);
        String first = amt1 > 0 ? amt1 + "x " + this.prettyItemName(id1) : "";
        String string = second = amt2 > 0 ? amt2 + "x " + this.prettyItemName(id2) : "";
        if (first.isEmpty() && second.isEmpty()) {
            return "";
        }
        if (!first.isEmpty() && !second.isEmpty()) {
            return first + ", " + second;
        }
        return first + second;
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public Map<Item, Integer> getFoodRequirements() {
        return this.foodRequirements;
    }

    public int getSkinIndex() {
        return (Integer)this.entityData.get(SKIN_VARIANT);
    }

    public void setSkinIndex(int index) {
        int sex = this.getSex();
        int max = CompanionData.skins[sex].length;
        this.entityData.set(SKIN_VARIANT, (Object)Mth.clamp((int)index, (int)0, (int)Math.max(0, max - 1)));
    }

    public ResourceLocation getDefaultSkinTexture() {
        int sex = Mth.clamp((int)this.getSex(), (int)0, (int)(CompanionData.skins.length - 1));
        ResourceLocation[] variants = CompanionData.skins[sex];
        int idx = Mth.clamp((int)this.getSkinIndex(), (int)0, (int)(variants.length - 1));
        return variants[idx];
    }

    public Optional<String> getCustomSkinUrl() {
        String raw = (String)this.entityData.get(CUSTOM_SKIN_URL);
        return raw == null || raw.isBlank() ? Optional.empty() : Optional.of(raw);
    }

    public void setCustomSkinUrl(@Nullable String url) {
        this.entityData.set(CUSTOM_SKIN_URL, (Object)(url == null ? "" : url.trim()));
    }

    public int getSex() {
        return (Integer)this.entityData.get(SEX);
    }

    public void setSex(int value) {
        this.entityData.set(SEX, (Object)Mth.clamp((int)value, (int)0, (int)(CompanionData.skins.length - 1)));
    }

    public int getBaseHealth() {
        return (Integer)this.entityData.get(BASE_HEALTH);
    }

    public void setBaseHealth(int health) {
        this.entityData.set(BASE_HEALTH, (Object)health);
    }

    public boolean isEating() {
        return (Boolean)this.entityData.get(EATING);
    }

    public void setEating(boolean eating) {
        this.entityData.set(EATING, (Object)eating);
    }

    public int getExpLvl() {
        return (Integer)this.entityData.get(EXP_LVL);
    }

    public void setExpLvl(int lvl) {
        this.entityData.set(EXP_LVL, (Object)Math.max(lvl, 0));
    }

    public float getExperienceProgress() {
        return this.level().isClientSide ? ((Float)this.entityData.get(EXP_PROGRESS)).floatValue() : this.experienceProgress;
    }

    public int getTotalExperience() {
        return this.totalExperience;
    }

    public int getKillCount() {
        return (Integer)this.entityData.get(KILL_COUNT);
    }

    public void setKillCount(int kills) {
        this.entityData.set(KILL_COUNT, (Object)Math.max(0, kills));
    }

    public void incrementKillCount() {
        if (!this.level().isClientSide) {
            this.setKillCount(this.getKillCount() + 1);
        }
    }

    public int getStrength() {
        return this.getBaseStrength() + this.equipmentStrengthBonus;
    }

    public int getDexterity() {
        return this.getBaseDexterity() + this.equipmentDexterityBonus;
    }

    public int getIntelligence() {
        return this.getBaseIntelligence() + this.equipmentIntelligenceBonus;
    }

    public int getEndurance() {
        return this.getBaseEndurance() + this.equipmentEnduranceBonus;
    }

    public int getBaseStrength() {
        return (Integer)this.entityData.get(STR);
    }

    public int getBaseDexterity() {
        return (Integer)this.entityData.get(DEX);
    }

    public int getBaseIntelligence() {
        return (Integer)this.entityData.get(INTL);
    }

    public int getBaseEndurance() {
        return (Integer)this.entityData.get(END);
    }

    public int getSpecialistAttributeIndex() {
        return (Integer)this.entityData.get(SPECIALIST);
    }

    public void setStrength(int value) {
        this.entityData.set(STR, (Object)Math.max(1, value));
    }

    public void setDexterity(int value) {
        this.entityData.set(DEX, (Object)Math.max(1, value));
    }

    public void setIntelligence(int value) {
        this.entityData.set(INTL, (Object)Math.max(1, value));
    }

    public void setEndurance(int value) {
        this.entityData.set(END, (Object)Math.max(1, value));
    }

    public void setSpecialistAttributeIndex(int idx) {
        this.entityData.set(SPECIALIST, (Object)idx);
        this.specialistAttr = idx;
    }

    public ResourceLocation getSkinTexture() {
        int sex = Mth.clamp((int)this.getSex(), (int)0, (int)(CompanionData.skins.length - 1));
        ResourceLocation[] variants = CompanionData.skins[sex];
        int idx = Mth.clamp((int)this.getSkinIndex(), (int)0, (int)(variants.length - 1));
        return variants[idx];
    }

    public boolean hasFoodInInventory() {
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            if (!CompanionData.isFood(this.inventory.getItem(i))) continue;
            return true;
        }
        return false;
    }

    public ItemStack checkFood() {
        int missing = (int)Math.ceil(this.getMaxHealth() - this.getHealth());
        ItemStack best = ItemStack.EMPTY;
        float bestOverflow = Float.MAX_VALUE;
        float bestUnder = -1.0f;
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            float healValue;
            ItemStack stack = this.inventory.getItem(i);
            if (!CompanionData.isFood(stack) || (healValue = this.estimateHealingPotential(stack, missing)) <= 0.0f) continue;
            if (healValue >= (float)missing) {
                float overflow = healValue - (float)missing;
                if (!(overflow < bestOverflow)) continue;
                bestOverflow = overflow;
                best = stack;
                continue;
            }
            if (bestOverflow != Float.MAX_VALUE || !(healValue > bestUnder)) continue;
            bestUnder = healValue;
            best = stack;
        }
        return best;
    }

    public boolean healFromFoodStack(ItemStack stack) {
        if (stack.isEmpty() || !CompanionData.isFood(stack)) {
            return false;
        }
        float missing = this.getMaxHealth() - this.getHealth();
        if (missing <= 0.01f) {
            return false;
        }
        FoodProperties food = (FoodProperties)stack.get(DataComponents.FOOD);
        if (food != null) {
            int healAmount = Math.max(1, Math.min(food.nutrition(), (int)Math.ceil(missing)));
            this.playConsumptionEffects(stack);
            stack.shrink(1);
            this.heal(healAmount);
            this.applyFoodEffects(food);
            food.usingConvertsTo().ifPresent(this::storeOrDrop);
            return true;
        }
        if (CompanionData.isHealingPotion(stack)) {
            ItemStack potionCopy = stack.copyWithCount(1);
            this.playConsumptionEffects(potionCopy);
            stack.shrink(1);
            this.applyPotionEffects(potionCopy);
            this.storeOrDrop(new ItemStack((ItemLike)Items.GLASS_BOTTLE));
            return true;
        }
        return false;
    }

    private float estimateHealingPotential(ItemStack stack, float missingHealth) {
        FoodProperties food = (FoodProperties)stack.get(DataComponents.FOOD);
        if (food != null) {
            return Math.min((float)food.nutrition(), missingHealth);
        }
        if (!CompanionData.isHealingPotion(stack)) {
            return 0.0f;
        }
        float healAmount = 0.0f;
        PotionContents contents = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        for (MobEffectInstance effect : contents.getAllEffects()) {
            if (effect.getEffect().is(MobEffects.HEAL)) {
                healAmount += 4.0f * (float)(effect.getAmplifier() + 1);
                continue;
            }
            if (effect.getEffect().is(MobEffects.REGENERATION)) {
                healAmount += (float)(effect.getDuration() * (effect.getAmplifier() + 1)) / 50.0f;
                continue;
            }
            if (!effect.getEffect().is(MobEffects.ABSORPTION)) continue;
            healAmount += 4.0f * (float)(effect.getAmplifier() + 1) * 0.5f;
        }
        return Math.min(healAmount, missingHealth + 8.0f);
    }

    private void applyFoodEffects(FoodProperties food) {
        if (this.level().isClientSide()) {
            return;
        }
        for (FoodProperties.PossibleEffect possible : food.effects()) {
            if (!(this.random.nextFloat() <= possible.probability())) continue;
            this.addEffect(possible.effect());
        }
    }

    private void applyPotionEffects(ItemStack stack) {
        if (this.level().isClientSide()) {
            return;
        }
        PotionContents contents = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        for (MobEffectInstance effect : contents.getAllEffects()) {
            if (((MobEffect)effect.getEffect().value()).isInstantenous()) {
                ((MobEffect)effect.getEffect().value()).applyInstantenousEffect(null, null, (LivingEntity)this, effect.getAmplifier(), 1.0);
                continue;
            }
            this.addEffect(new MobEffectInstance(effect));
        }
    }

    private void playConsumptionEffects(ItemStack stack) {
        if (this.level().isClientSide()) {
            return;
        }
        SoundEvent sound = stack.getUseAnimation() == UseAnim.DRINK ? stack.getItem().getDrinkingSound() : stack.getItem().getEatingSound();
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), sound, this.getSoundSource(), 0.7f, 1.0f + (this.getRandom().nextFloat() - 0.5f) * 0.2f);
        for (int j = 0; j < 5; ++j) {
            double dx = this.getRandom().nextGaussian() * 0.02;
            double dy = this.getRandom().nextGaussian() * 0.02;
            double dz = this.getRandom().nextGaussian() * 0.02;
            this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack.copyWithCount(1)), this.getX() + (double)(this.getRandom().nextFloat() * 0.4f - 0.2f), this.getY() + (double)this.getBbHeight() * 0.8, this.getZ() + (double)(this.getRandom().nextFloat() * 0.4f - 0.2f), dx, dy, dz);
        }
    }

    private void storeOrDrop(ItemStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        ItemStack remainder = this.inventory.addItem(stack);
        if (!remainder.isEmpty()) {
            this.spawnAtLocation(remainder);
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack held = player.getItemInHand(hand);
        if (hand == InteractionHand.MAIN_HAND) {
            if (!this.isTame() && !this.level().isClientSide()) {
                if (this.foodRequirements.isEmpty()) {
                    this.assignFoodRequirements();
                }
                if (this.foodRequirements.containsKey(held.getItem())) {
                    int remaining = this.foodRequirements.get(held.getItem());
                    if (remaining > 0) {
                        held.shrink(1);
                        this.foodRequirements.put(held.getItem(), remaining - 1);
                        this.syncFoodRequirements();
                        if (this.foodRequirements.values().stream().allMatch(v -> v <= 0)) {
                            this.tame(player);
                            player.sendSystemMessage((Component)Component.translatable((String)"chat.type.text", (Object[])new Object[]{this.getDisplayName(), Component.literal((String)"Thanks!")}));
                            player.sendSystemMessage((Component)Component.literal((String)"Companion added"));
                            this.setPatrolPos(null);
                            this.setPatrolling(false);
                            this.setFollowing(true);
                            this.setPatrolRadius(4);
                            if (this.patrolGoal != null) {
                                this.patrolGoal.radius = 4;
                            }
                            if (this.moveBackGoal != null) {
                                this.moveBackGoal.radius = 4;
                            }
                        } else if (this.foodRequirements.get(held.getItem()) == 0) {
                            player.sendSystemMessage((Component)Component.translatable((String)"chat.type.text", (Object[])new Object[]{this.getDisplayName(), CompanionData.ENOUGH_FOOD[this.random.nextInt(CompanionData.ENOUGH_FOOD.length)]}));
                        } else {
                            player.sendSystemMessage((Component)Component.translatable((String)"chat.type.text", (Object[])new Object[]{this.getDisplayName(), CompanionData.tameFail[this.random.nextInt(CompanionData.tameFail.length)]}));
                        }
                    } else {
                        player.sendSystemMessage((Component)Component.translatable((String)"chat.type.text", (Object[])new Object[]{this.getDisplayName(), CompanionData.ENOUGH_FOOD[this.random.nextInt(CompanionData.ENOUGH_FOOD.length)]}));
                    }
                } else {
                    player.sendSystemMessage((Component)Component.translatable((String)"chat.type.text", (Object[])new Object[]{this.getDisplayName(), CompanionData.WRONG_FOOD[this.random.nextInt(CompanionData.WRONG_FOOD.length)]}));
                    player.sendSystemMessage((Component)Component.literal((String)this.getFoodStatus()));
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (this.isAlliedTo((Entity)player)) {
                if (held.is((Item)ModItems.COMPANION_MOVER.get())) {
                    return InteractionResult.PASS;
                }
                if (player.isShiftKeyDown()) {
                    if (!this.level().isClientSide()) {
                        this.toggleSit((ServerPlayer)player);
                    }
                } else if (!this.level().isClientSide()) {
                    this.openGui((ServerPlayer)player);
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    private void toggleSit(ServerPlayer player) {
        if (!this.isOrderedToSit()) {
            this.setOrderedToSit(true);
            MutableComponent text = Component.literal((String)"I'll stand here.");
            player.sendSystemMessage((Component)Component.translatable((String)"chat.type.text", (Object[])new Object[]{this.getDisplayName(), text}));
        } else {
            this.setOrderedToSit(false);
            MutableComponent text = Component.literal((String)"I'll move around.");
            player.sendSystemMessage((Component)Component.translatable((String)"chat.type.text", (Object[])new Object[]{this.getDisplayName(), text}));
        }
    }

    public void openGui(ServerPlayer player) {
        SimpleMenuProvider provider = new SimpleMenuProvider((id, inv, p) -> new CompanionMenu(id, inv, this), this.getDisplayName());
        player.openMenu((MenuProvider)provider, buf -> buf.writeVarInt(this.getId()));
    }

    private void assignFoodRequirements() {
        Map<Item, Integer> newReq = CompanionData.getRandomFoodRequirement(this.rand);
        this.foodRequirements.clear();
        this.foodRequirements.putAll(newReq);
        List entries = this.foodRequirements.entrySet().stream().toList();
        this.entityData.set(FOOD1, (Object)BuiltInRegistries.ITEM.getKey((Object)((Item)((Map.Entry)entries.get(0)).getKey())).toString());
        this.entityData.set(FOOD1_AMT, (Object)((Integer)((Map.Entry)entries.get(0)).getValue()));
        this.entityData.set(FOOD2, (Object)BuiltInRegistries.ITEM.getKey((Object)((Item)((Map.Entry)entries.get(1)).getKey())).toString());
        this.entityData.set(FOOD2_AMT, (Object)((Integer)((Map.Entry)entries.get(1)).getValue()));
    }

    private void syncFoodRequirements() {
        if (this.foodRequirements.isEmpty()) {
            return;
        }
        this.foodRequirements.forEach((item, count) -> {
            String id = BuiltInRegistries.ITEM.getKey(item).toString();
            if (id.equals(this.entityData.get(FOOD1))) {
                this.entityData.set(FOOD1_AMT, count);
            } else if (id.equals(this.entityData.get(FOOD2))) {
                this.entityData.set(FOOD2_AMT, count);
            }
        });
    }

    private String prettyItemName(String id) {
        ResourceLocation rl = ResourceLocation.tryParse((String)id);
        if (rl == null) {
            return id;
        }
        Item item = (Item)BuiltInRegistries.ITEM.get(rl);
        return item.getDescription().getString();
    }

    public boolean wantsToAttack(LivingEntity target, LivingEntity owner) {
        if (target instanceof SummonedWitherSkeleton) {
            return false;
        }
        return super.wantsToAttack(target, owner);
    }

    public boolean isAlliedTo(Entity other) {
        if (other instanceof SummonedWitherSkeleton) {
            SummonedWitherSkeleton skeleton = (SummonedWitherSkeleton)other;
            return true;
        }
        return super.isAlliedTo(other);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("Inventory", (Tag)this.inventory.createTag((HolderLookup.Provider)this.registryAccess()));
        tag.putInt("skin", this.getSkinIndex());
        tag.putString("CustomSkinUrl", (String)this.entityData.get(CUSTOM_SKIN_URL));
        tag.putBoolean("Eating", this.isEating());
        tag.putBoolean("Alert", this.isAlert());
        tag.putBoolean("Hunting", this.isHunting());
        tag.putBoolean("Patrolling", this.isPatrolling());
        tag.putBoolean("Following", this.isFollowing());
        tag.putBoolean("Guarding", this.isGuarding());
        tag.putBoolean("SprintEnabled", this.isSprintEnabled());
        tag.putBoolean("Pickup", this.isPickupEnabled());
        tag.putInt("radius", this.getPatrolRadius());
        tag.putInt("sex", this.getSex());
        tag.putInt("baseHealth", this.getBaseHealth());
        tag.putFloat("XpP", this.experienceProgress);
        tag.putInt("XpLevel", this.getExpLvl());
        tag.putInt("XpTotal", this.totalExperience);
        tag.putInt("KillCount", this.getKillCount());
        tag.putString("food1", (String)this.entityData.get(FOOD1));
        tag.putString("food2", (String)this.entityData.get(FOOD2));
        tag.putInt("food1_amt", ((Integer)this.entityData.get(FOOD1_AMT)).intValue());
        tag.putInt("food2_amt", ((Integer)this.entityData.get(FOOD2_AMT)).intValue());
        tag.putInt("Strength", this.getBaseStrength());
        tag.putInt("Dexterity", this.getBaseDexterity());
        tag.putInt("Intelligence", this.getBaseIntelligence());
        tag.putInt("Endurance", this.getBaseEndurance());
        tag.putInt("SpecialistAttr", this.getSpecialistAttributeIndex());
        if (this.getPatrolPos().isPresent()) {
            int[] patrolPos = new int[]{this.getPatrolPos().get().getX(), this.getPatrolPos().get().getY(), this.getPatrolPos().get().getZ()};
            tag.putIntArray("patrol_pos", patrolPos);
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setSkinIndex(tag.getInt("skin"));
        if (tag.contains("CustomSkinUrl")) {
            this.setCustomSkinUrl(tag.getString("CustomSkinUrl"));
        }
        this.setEating(tag.getBoolean("Eating"));
        this.setAlert(tag.getBoolean("Alert"));
        this.setHunting(tag.getBoolean("Hunting"));
        this.setPatrolling(tag.getBoolean("Patrolling"));
        this.setFollowing(tag.getBoolean("Following"));
        this.setGuarding(tag.getBoolean("Guarding"));
        if (tag.contains("SprintEnabled")) {
            this.setSprintEnabled(tag.getBoolean("SprintEnabled"));
        } else if (tag.contains("Stationery")) {
            this.setSprintEnabled(false);
        }
        this.setPickupEnabled(tag.contains("Pickup") ? tag.getBoolean("Pickup") : true);
        this.setPatrolRadius(tag.getInt("radius"));
        this.setSex(tag.getInt("sex"));
        this.experienceProgress = tag.getFloat("XpP");
        this.totalExperience = tag.getInt("XpTotal");
        this.setExpLvl(tag.getInt("XpLevel"));
        this.setKillCount(tag.contains("KillCount") ? tag.getInt("KillCount") : 0);
        this.syncExpProgress();
        this.entityData.set(FOOD1, (Object)tag.getString("food1"));
        this.entityData.set(FOOD2, (Object)tag.getString("food2"));
        this.entityData.set(FOOD1_AMT, (Object)tag.getInt("food1_amt"));
        this.entityData.set(FOOD2_AMT, (Object)tag.getInt("food2_amt"));
        this.foodRequirements.clear();
        ResourceLocation id1 = ResourceLocation.parse((String)((String)this.entityData.get(FOOD1)));
        ResourceLocation id2 = ResourceLocation.parse((String)((String)this.entityData.get(FOOD2)));
        this.foodRequirements.put((Item)BuiltInRegistries.ITEM.get(id1), (Integer)this.entityData.get(FOOD1_AMT));
        this.foodRequirements.put((Item)BuiltInRegistries.ITEM.get(id2), (Integer)this.entityData.get(FOOD2_AMT));
        if (tag.getInt("baseHealth") == 0) {
            this.setBaseHealth((Integer)ModConfig.safeGet(ModConfig.BASE_HEALTH));
        } else {
            this.setBaseHealth(tag.getInt("baseHealth"));
        }
        this.setSpecialistAttributeIndex(tag.contains("SpecialistAttr") ? tag.getInt("SpecialistAttr") : -1);
        if (tag.contains("Inventory", 9)) {
            this.inventory.fromTag(tag.getList("Inventory", 10), (HolderLookup.Provider)this.registryAccess());
        }
        if (tag.contains("patrol_pos")) {
            int[] positions = tag.getIntArray("patrol_pos");
            this.setPatrolPos(new BlockPos(positions[0], positions[1], positions[2]));
        }
        if (tag.contains("radius")) {
            this.patrolGoal = new PatrolGoal(this, 60, tag.getInt("radius"));
            this.moveBackGoal = new MoveBackToPatrolGoal(this, tag.getInt("radius"));
            this.goalSelector.addGoal(3, (Goal)this.moveBackGoal);
            this.goalSelector.addGoal(3, (Goal)this.patrolGoal);
        }
        this.setItemSlot(EquipmentSlot.FEET, ItemStack.EMPTY);
        this.setItemSlot(EquipmentSlot.LEGS, ItemStack.EMPTY);
        this.setItemSlot(EquipmentSlot.CHEST, ItemStack.EMPTY);
        this.setItemSlot(EquipmentSlot.HEAD, ItemStack.EMPTY);
        this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        this.checkArmor();
        if (tag.contains("Strength")) {
            this.setStrength(tag.getInt("Strength"));
            this.setDexterity(tag.getInt("Dexterity"));
            this.setIntelligence(tag.getInt("Intelligence"));
            this.setEndurance(tag.getInt("Endurance"));
        } else {
            this.assignRpgAttributes();
        }
        this.recomputeEquipmentAttributeBonuses();
        this.applyRpgAttributeModifiers();
        this.clampHealthToMax();
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob parent) {
        return null;
    }

    public MobCategory getClassification(boolean forSpawnCount) {
        return MobCategory.AMBIENT;
    }

    public boolean isFood(ItemStack stack) {
        return CompanionData.isFood(stack);
    }

    public void tick() {
        boolean equipmentChanged;
        int swingTick;
        if (this.level().isClientSide()) {
            this.updateSwingTime();
        }
        if (this.level().isClientSide() && (swingTick = ((Integer)this.entityData.get(LAST_SWING_TICK)).intValue()) != this.lastAppliedSwingTick) {
            this.lastAppliedSwingTick = swingTick;
            this.swinging = true;
            this.swingTime = 0;
            this.oAttackAnim = 0.0f;
            this.attackAnim = 0.0f;
            this.swingingArm = InteractionHand.MAIN_HAND;
            super.swing(InteractionHand.MAIN_HAND, true);
        }
        if (!this.level().isClientSide()) {
            this.checkArmor();
            if (this.tickCount % 2 == 0 && this.isPickupEnabled() && this.isTame()) {
                this.collectNearbyItems();
            }
            this.updateSprintState();
            if (this.tickCount % 10 == 0) {
                LivingEntity target;
                this.checkStats();
                if (this.shouldRequestFood()) {
                    this.requestFoodFromOwner();
                }
                if ((target = this.getTarget()) != null && !target.isAlive()) {
                    this.setTarget(null);
                }
            }
        }
        if (equipmentChanged = this.recomputeEquipmentAttributeBonuses()) {
            this.applyRpgAttributeModifiers();
            this.clampHealthToMax();
        }
        super.tick();
    }

    private void updateSprintState() {
        boolean movingOrFighting;
        boolean wantsSprint = this.isSprintEnabled() && !this.isOrderedToSit();
        boolean bl = movingOrFighting = this.getNavigation() != null && !this.getNavigation().isDone() || this.getTarget() != null;
        if (wantsSprint && movingOrFighting) {
            this.setSprinting(true);
        } else {
            this.setSprinting(false);
        }
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        this.assignRpgAttributes();
        int baseHealth = (Integer)ModConfig.safeGet(ModConfig.BASE_HEALTH) + CompanionData.getHealthModifier() + this.getEnduranceBonusHealth();
        this.modifyMaxHealth(baseHealth - 20, "companion base health", true);
        this.setHealth(this.getMaxHealth());
        this.setBaseHealth(baseHealth);
        this.setSex(this.random.nextInt(2));
        this.setSkinIndex(this.random.nextInt(CompanionData.skins[this.getSex()].length));
        this.setCustomName((Component)Component.literal((String)CompanionData.getRandomName(this.getSex())));
        this.setPatrolPos(this.blockPosition());
        this.setPatrolling(true);
        this.setPatrolRadius(15);
        this.patrolGoal = new PatrolGoal(this, 60, this.getPatrolRadius());
        this.moveBackGoal = new MoveBackToPatrolGoal(this, this.getPatrolRadius());
        this.goalSelector.addGoal(3, (Goal)this.moveBackGoal);
        this.goalSelector.addGoal(3, (Goal)this.patrolGoal);
        this.assignFoodRequirements();
        if (((Boolean)ModConfig.safeGet(ModConfig.SPAWN_ARMOR)).booleanValue()) {
            for (int i = 0; i < 4; ++i) {
                EquipmentSlot armorType = EquipmentSlot.values()[i + 2];
                ItemStack itemstack = CompanionData.getSpawnArmor(armorType);
                if (itemstack.isEmpty()) continue;
                this.inventory.setItem(i, itemstack);
            }
            this.checkArmor();
        }
        this.recomputeEquipmentAttributeBonuses();
        this.applyRpgAttributeModifiers();
        this.clampHealthToMax();
        return super.finalizeSpawn(level, difficulty, reason, spawnDataIn);
    }

    public void cycleOrders() {
        if (this.isFollowing()) {
            this.setPatrolling(true);
            this.setFollowing(false);
            this.setGuarding(false);
            this.setPatrolPos(this.blockPosition());
        } else if (this.isPatrolling()) {
            this.setPatrolling(false);
            this.setFollowing(false);
            this.setGuarding(true);
            this.setPatrolPos(this.blockPosition());
        } else {
            this.setPatrolling(false);
            this.setFollowing(true);
            this.setGuarding(false);
        }
    }

    public void toggleAlert() {
        this.setAlert(!this.isAlert());
    }

    public void toggleHunting() {
        this.setHunting(!this.isHunting());
    }

    public void toggleSprint() {
        this.setSprintEnabled(!this.isSprintEnabled());
    }

    public void release() {
        this.setTame(false, true);
        this.setOwnerUUID(null);
        this.setFollowing(false);
        this.setAlert(false);
        this.setHunting(false);
        this.setPatrolPos(this.blockPosition());
        this.setPatrolling(true);
        this.setSprintEnabled(false);
        this.setPatrolRadius(15);
        this.assignFoodRequirements();
        if (this.isOrderedToSit()) {
            this.setOrderedToSit(false);
        }
    }

    public void giveExperiencePoints(int points) {
        int adjusted = Math.max(1, Math.round((float)points * this.getExperienceGainMultiplier()));
        this.experienceProgress += (float)adjusted / (float)this.getXpNeededForNextLevel();
        this.totalExperience = Mth.clamp((int)(this.totalExperience + adjusted), (int)0, (int)Integer.MAX_VALUE);
        this.syncExpProgress();
        while (this.experienceProgress < 0.0f) {
            float f = this.experienceProgress * (float)this.getXpNeededForNextLevel();
            if (this.getExpLvl() > 0) {
                this.giveExperienceLevels(-1);
                this.experienceProgress = 1.0f + f / (float)this.getXpNeededForNextLevel();
                continue;
            }
            this.giveExperienceLevels(-1);
            this.experienceProgress = 0.0f;
        }
        while (this.experienceProgress >= 1.0f) {
            this.experienceProgress = (this.experienceProgress - 1.0f) * (float)this.getXpNeededForNextLevel();
            this.giveExperienceLevels(1);
            this.experienceProgress /= (float)this.getXpNeededForNextLevel();
        }
        this.syncExpProgress();
    }

    public void giveExperienceLevels(int levels) {
        this.setExpLvl(this.getExpLvl() + levels);
        if (this.getExpLvl() < 0) {
            this.setExpLvl(0);
            this.experienceProgress = 0.0f;
            this.totalExperience = 0;
        }
        this.syncExpProgress();
        if (levels > 0 && this.getExpLvl() % 5 == 0 && (float)this.lastLevelUpTime < (float)this.tickCount - 100.0f) {
            this.lastLevelUpTime = this.tickCount;
        }
    }

    public int getXpNeededForNextLevel() {
        int level = this.getExpLvl();
        double curve = Math.pow(level + 1, 1.35);
        int required = (int)Math.round(20.0 + curve * 10.0);
        return Math.max(20, required);
    }

    public void modifyMaxHealth(int change, String name, boolean permanent) {
        AttributeInstance attribute = this.getAttribute(Attributes.MAX_HEALTH);
        if (attribute == null) {
            return;
        }
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"modern_companions", (String)name.replace(" ", "_"));
        attribute.removeModifier(id);
        AttributeModifier modifier = new AttributeModifier(id, (double)change, AttributeModifier.Operation.ADD_VALUE);
        if (permanent) {
            attribute.addPermanentModifier(modifier);
        } else {
            attribute.addTransientModifier(modifier);
        }
    }

    public void checkStats() {
        if ((int)this.getMaxHealth() != this.getBaseHealth() + this.getExpLvl() / 3 && this.getExpLvl() / 3 != 0) {
            this.modifyMaxHealth(this.getExpLvl() / 3, "companion level health", false);
        }
    }

    private void syncExpProgress() {
        if (!this.level().isClientSide) {
            this.entityData.set(EXP_PROGRESS, (Object)Float.valueOf(this.experienceProgress));
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.getEntity() == this.getOwner() && !((Boolean)ModConfig.safeGet(ModConfig.FRIENDLY_FIRE_PLAYER)).booleanValue()) {
            return false;
        }
        if (source.is(DamageTypeTags.IS_FALL) && !((Boolean)ModConfig.safeGet(ModConfig.FALL_DAMAGE)).booleanValue()) {
            return false;
        }
        float adjusted = this.applyEnduranceResistance(source, amount);
        this.hurtArmor(source, adjusted);
        return super.hurt(source, adjusted);
    }

    public void die(DamageSource source) {
        if (!this.level().isClientSide()) {
            AbstractHumanCompanionEntity abstractHumanCompanionEntity = this;
            if (abstractHumanCompanionEntity instanceof Beastmaster) {
                Beastmaster beastmaster = (Beastmaster)abstractHumanCompanionEntity;
                beastmaster.forceDespawnPet();
            }
            this.dropResurrectionScroll();
        }
        super.die(source);
    }

    public void hurtArmor(DamageSource source, float amount) {
        if (!(amount <= 0.0f)) {
            if ((amount /= 4.0f) < 1.0f) {
                amount = 1.0f;
            }
            for (ItemStack itemstack : this.getArmorSlots()) {
                Item item = itemstack.getItem();
                if (!(item instanceof ArmorItem)) continue;
                ArmorItem armorItem = (ArmorItem)item;
                itemstack.hurtAndBreak((int)amount, (LivingEntity)this, armorItem.getEquipmentSlot());
            }
        }
    }

    protected void dropEquipment() {
    }

    private void dropResurrectionScroll() {
        if (!this.isTame()) {
            return;
        }
        ItemStack scroll = ResurrectionScrollItem.createFromCompanion(this, (Item)ModItems.RESURRECTION_SCROLL.get());
        ItemEntity item = this.spawnAtLocation(scroll);
        if (item != null) {
            item.setUnlimitedLifetime();
        }
    }

    public boolean doHurtTarget(Entity entity) {
        this.forceSwingAnimation(InteractionHand.MAIN_HAND);
        ItemStack itemstack = this.getMainHandItem();
        if (!this.level().isClientSide && !itemstack.isEmpty() && entity instanceof LivingEntity) {
            itemstack.hurtAndBreak(1, (LivingEntity)this, EquipmentSlot.MAINHAND);
            if (this.getMainHandItem().isEmpty() && this.isTame() && this.getOwner() != null) {
                MutableComponent broken = Component.literal((String)"My weapon broke!");
                this.getOwner().sendSystemMessage((Component)Component.translatable((String)"chat.type.text", (Object[])new Object[]{this.getDisplayName(), broken}));
            }
        }
        return super.doHurtTarget(entity);
    }

    private void forceSwingAnimation(InteractionHand hand) {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        this.swingTime = 0;
        this.swinging = true;
        this.swingingArm = hand;
        this.entityData.set(LAST_SWING_TICK, (Object)this.tickCount);
        ServerChunkCache chunks = server.getChunkSource();
        chunks.broadcastAndSend((Entity)this, (Packet)new ClientboundAnimatePacket((Entity)this, hand == InteractionHand.MAIN_HAND ? 0 : 3));
    }

    public void checkArmor() {
        ItemStack head = this.getItemBySlot(EquipmentSlot.HEAD);
        ItemStack chest = this.getItemBySlot(EquipmentSlot.CHEST);
        ItemStack legs = this.getItemBySlot(EquipmentSlot.LEGS);
        ItemStack feet = this.getItemBySlot(EquipmentSlot.FEET);
        block6: for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack itemstack = this.inventory.getItem(i);
            Item item = itemstack.getItem();
            if (!(item instanceof ArmorItem)) continue;
            ArmorItem armorItem = (ArmorItem)item;
            switch (armorItem.getEquipmentSlot()) {
                case HEAD: {
                    if (!head.isEmpty() && !CompanionData.isBetterArmor(itemstack, head)) continue block6;
                    this.setItemSlot(EquipmentSlot.HEAD, itemstack);
                    continue block6;
                }
                case CHEST: {
                    if (!chest.isEmpty() && !CompanionData.isBetterArmor(itemstack, chest)) continue block6;
                    this.setItemSlot(EquipmentSlot.CHEST, itemstack);
                    continue block6;
                }
                case LEGS: {
                    if (!legs.isEmpty() && !CompanionData.isBetterArmor(itemstack, legs)) continue block6;
                    this.setItemSlot(EquipmentSlot.LEGS, itemstack);
                    continue block6;
                }
                case FEET: {
                    if (!feet.isEmpty() && !CompanionData.isBetterArmor(itemstack, feet)) continue block6;
                    this.setItemSlot(EquipmentSlot.FEET, itemstack);
                }
            }
        }
    }

    public void checkWeapon() {
    }

    public void applyFlag(String flag, boolean value) {
        switch (flag) {
            case "follow": {
                this.setFollowing(value);
                break;
            }
            case "patrol": {
                this.setPatrolling(value);
                this.setFollowing(!value);
                this.setGuarding(false);
                if (!value) break;
                this.setPatrolPos(this.blockPosition());
                break;
            }
            case "guard": {
                this.setGuarding(value);
                this.setPatrolling(false);
                this.setFollowing(!value);
                if (!value) break;
                this.setPatrolPos(this.blockPosition());
                break;
            }
            case "hunt": {
                this.setHunting(value);
                break;
            }
            case "alert": {
                this.setAlert(value);
                break;
            }
            case "sprint": {
                this.setSprintEnabled(value);
                break;
            }
            case "pickup": {
                this.setPickupEnabled(value);
                break;
            }
        }
    }

    public boolean getFlagValue(String flag) {
        return switch (flag) {
            case "follow" -> this.isFollowing();
            case "patrol" -> this.isPatrolling();
            case "guard" -> this.isGuarding();
            case "hunt" -> this.isHunting();
            case "alert" -> this.isAlert();
            case "sprint" -> this.isSprintEnabled();
            case "pickup" -> this.isPickupEnabled();
            default -> false;
        };
    }

    private void collectNearbyItems() {
        double range = 3.0;
        AABB box = this.getBoundingBox().inflate(range);
        for (ItemEntity item : this.level().getEntitiesOfClass(ItemEntity.class, box, e -> e.isAlive() && !e.hasPickUpDelay())) {
            if (item.getItem().isEmpty() || item.getItem().is((Item)ModItems.RESURRECTION_SCROLL.get())) continue;
            Vec3 pull = this.position().subtract(item.position());
            if (pull.lengthSqr() > 0.01) {
                item.setDeltaMovement(item.getDeltaMovement().scale(0.9).add(pull.normalize().scale(0.08)));
            }
            if (!(this.distanceToSqr((Entity)item) <= 2.25)) continue;
            ItemStack stack = item.getItem();
            ItemStack leftover = this.inventory.addItem(stack);
            this.inventory.setChanged();
            if (leftover.isEmpty()) {
                item.discard();
                continue;
            }
            item.setItem(leftover);
        }
    }

    private void assignRpgAttributes() {
        int[] stats = new int[]{4, 4, 4, 4};
        for (int i = 0; i < 23; ++i) {
            int n = this.random.nextInt(stats.length);
            stats[n] = stats[n] + 1;
        }
        double specialistChance = 0.02 + this.random.nextDouble() * 0.04;
        if (this.random.nextDouble() < specialistChance) {
            int pick;
            int n = pick = this.random.nextInt(stats.length);
            stats[n] = stats[n] + 5;
            this.setSpecialistAttributeIndex(pick);
        } else {
            this.setSpecialistAttributeIndex(-1);
        }
        this.setStrength(stats[0]);
        this.setDexterity(stats[1]);
        this.setIntelligence(stats[2]);
        this.setEndurance(stats[3]);
    }

    private boolean recomputeEquipmentAttributeBonuses() {
        int newStr = this.getEnchantmentBonus(ModEnchantments.EMPOWER);
        int newDex = this.getEnchantmentBonus(ModEnchantments.NIMBILITY);
        int newInt = this.getEnchantmentBonus(ModEnchantments.ENLIGHTENMENT);
        int newEnd = this.getEnchantmentBonus(ModEnchantments.VITALITY);
        if (newStr == this.equipmentStrengthBonus && newDex == this.equipmentDexterityBonus && newInt == this.equipmentIntelligenceBonus && newEnd == this.equipmentEnduranceBonus) {
            return false;
        }
        this.equipmentStrengthBonus = newStr;
        this.equipmentDexterityBonus = newDex;
        this.equipmentIntelligenceBonus = newInt;
        this.equipmentEnduranceBonus = newEnd;
        return true;
    }

    private int getEnchantmentBonus(ResourceKey<Enchantment> enchantment) {
        Optional registry = this.level().registryAccess().registry(Registries.ENCHANTMENT);
        if (registry.isEmpty()) {
            return 0;
        }
        int total = 0;
        for (ItemStack armor : this.getArmorSlots()) {
            total += ((Registry)registry.get()).getHolder(enchantment).map(holder -> EnchantmentHelper.getItemEnchantmentLevel((Holder)holder, (ItemStack)armor)).orElse(0).intValue();
        }
        return total;
    }

    private void applyRpgAttributeModifiers() {
        this.applyStrengthModifiers();
        this.applyDexterityModifiers();
        this.applyEnduranceModifiers();
    }

    private void applyStrengthModifiers() {
        double delta = (double)(this.getStrength() - 4) * 0.25;
        this.applyModifier((Holder<Attribute>)Attributes.ATTACK_DAMAGE, "rpg_strength_damage", delta, AttributeModifier.Operation.ADD_VALUE);
        double kb = (double)(this.getStrength() - 4) * 0.03;
        this.applyModifier((Holder<Attribute>)Attributes.ATTACK_KNOCKBACK, "rpg_strength_knockback", kb, AttributeModifier.Operation.ADD_VALUE);
    }

    private void applyDexterityModifiers() {
        double speed = (double)(this.getDexterity() - 4) * 0.003;
        this.applyModifier((Holder<Attribute>)Attributes.MOVEMENT_SPEED, "rpg_dex_speed", speed, AttributeModifier.Operation.ADD_VALUE);
        double atkSpeed = (double)(this.getDexterity() - 4) * 0.04;
        this.applyModifier((Holder<Attribute>)Attributes.ATTACK_SPEED, "rpg_dex_attack_speed", atkSpeed, AttributeModifier.Operation.ADD_VALUE);
        double kbResist = Math.max(0.0, (double)(this.getDexterity() - 10) * 0.01);
        this.applyModifier((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, "rpg_dex_kb_resist", kbResist, AttributeModifier.Operation.ADD_VALUE);
    }

    private void applyEnduranceModifiers() {
        int baseline = ModConfig.BASE_HEALTH != null ? (Integer)ModConfig.safeGet(ModConfig.BASE_HEALTH) : 20;
        int baseBonusHealth = this.getEnduranceBonusHealth();
        int desiredBase = Math.max(this.getBaseHealth(), baseline + baseBonusHealth);
        this.setBaseHealth(desiredBase);
        this.modifyMaxHealth(desiredBase - 20, "companion base health", true);
        int gearHealthBonus = Math.max(0, this.getEndurance() - this.getBaseEndurance());
        this.applyModifier((Holder<Attribute>)Attributes.MAX_HEALTH, "rpg_end_gear_health", gearHealthBonus, AttributeModifier.Operation.ADD_VALUE);
        double kbResist = Math.min(0.6, (double)(this.getEndurance() - 4) * 0.02);
        this.applyModifier((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, "rpg_end_kb_resist", kbResist, AttributeModifier.Operation.ADD_VALUE);
    }

    private int getEnduranceBonusHealth() {
        return Math.max(0, this.getBaseEndurance() - 4);
    }

    private float applyEnduranceResistance(DamageSource source, float amount) {
        boolean physical;
        boolean bl = physical = !source.is(DamageTypeTags.IS_FIRE) && !source.is(DamageTypeTags.IS_EXPLOSION) && !source.is(DamageTypeTags.BYPASSES_ARMOR) && !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY);
        if (!physical) {
            return amount;
        }
        float reduction = (float)Math.min(0.35, Math.max(0.0, (double)(this.getEndurance() - 4) * 0.015));
        return amount * (1.0f - reduction);
    }

    private void clampHealthToMax() {
        float max = this.getMaxHealth();
        if (this.getHealth() > max) {
            this.setHealth(max);
        }
    }

    private void applyModifier(Holder<Attribute> attribute, String idName, double value, AttributeModifier.Operation op) {
        AttributeInstance instance = this.getAttribute(attribute);
        if (instance == null) {
            return;
        }
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"modern_companions", (String)idName);
        instance.removeModifier(id);
        if (value != 0.0) {
            AttributeModifier modifier = new AttributeModifier(id, value, op);
            instance.addPermanentModifier(modifier);
        }
    }

    private float getExperienceGainMultiplier() {
        return 1.0f + (float)((double)(this.getIntelligence() - 4) * 0.03);
    }

    private boolean shouldRequestFood() {
        return this.isTame() && this.getHealth() < this.getMaxHealth() - 0.5f && !this.hasFoodInInventory() && this.tickCount - this.lastFoodRequestTick > 600;
    }

    private void requestFoodFromOwner() {
        if (this.level().isClientSide()) {
            return;
        }
        if (!this.isTame()) {
            return;
        }
        this.lastFoodRequestTick = this.tickCount;
        LivingEntity livingEntity = this.getOwner();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            MutableComponent text = Component.literal((String)this.randomFoodRequestLine());
            player.sendSystemMessage((Component)Component.translatable((String)"chat.type.text", (Object[])new Object[]{this.getDisplayName(), text}));
        }
    }

    private String randomFoodRequestLine() {
        String[] lines = new String[]{"I'm hurt\u2014please give me some food!", "Ouch. Could really use a snack right now.", "Low on health here. Got anything edible?", "One more hit might drop me. Food, please!", "Feeling woozy, little food would help.", "Bandages? Nah. Bread? Yes, please.", "My stomach says 'ow'. Do you have rations?", "If you feed me, I can keep fighting.", "Let's trade: I keep you safe; you keep me fed.", "Healing would be faster with a bite to eat.", "Health bar's looking pretty red over here...", "I can see the respawn screen from here. Food?", "If I fall over, that's on you and your lack of snacks.", "I fight better when I'm not dying of hunger, just saying.", "This would be a great moment for a snack break.", "I\u2019m not saying I\u2019m dramatic, but I might faint without food.", "Ow. That hurt. Got anything tasty and healing?", "Pretty sure a sandwich could fix at least half of this.", "Food now, heroics later. Deal?", "I\u2019d complain more, but I\u2019m too hungry.", "If you feed me, I promise to stop yelling about it\u2026 for a bit.", "We\u2019re in the danger zone. Apply food directly to companion.", "I think my HP fell out somewhere back there. Got food?", "Your loyal companion requires immediate snacks.", "I can tank hits, not starvation. Help.", "I\u2019m one bad decision away from dropping. Food might help.", "I\u2019d love to keep protecting you, but my health disagrees.", "Everything hurts except my appetite.", "I\u2019m not mad, I\u2019m just hungry and almost dead.", "I can bite enemies or I can bite food. Your choice.", "Pretty sure food is super effective against 'almost dead'.", "Okay, I admit it, I need a snack and a hug.", "My armor's cracked and so am I. Food?", "Warning: companion integrity at 12%. Apply food.", "Pretty sure my spleen just rage quit. Got stew?", "If you toss food, I promise to catch it. Probably.", "I'd walk it off, but I can barely stand. Rations?", "Is it normal to hear boss music and my stomach growling?", "Low health, high anxiety, zero snacks. Bad combo.", "If you have bread, now\u2019s the time for a miracle.", "Potion, salve, drumstick.. I\u2019m not picky.", "If I drop, loot my body for regrets and crumbs.", "I'll stop complaining the second I start chewing.", "Your inventory looks heavy. Let me lighten it\u2014via snacks.", "Can't parry death on an empty stomach.", "My survival strategy currently involves you feeding me.", "Health potions are nice, but have you tried soup?", "Help, I appear to be leaking. Send food.", "Doctor's orders: more food, less getting stabbed.", "If you feed me, I\u2019ll pretend this was all part of the plan.", "I'm fine. Totally fine. Just kidding, please feed me.", "Imagine how epic I'd be at full health and full belly.", "New quest: Restore companion. Objective: Provide snacks.", "Pretty sure my HP bar qualifies as a horror story.", "If hunger doesn\u2019t get me, that last hit will.", "I'm one sneeze away from collapsing.", "I can tank monsters, not skipping meals.", "Food now would really boost company morale. My morale.", "This feels like a 'eat first, fight later' situation.", "On the bright side, at least I still have my appetite.", "If you hear a thud, that was me. Bring food.", "My inner monologue is just 'ow' and 'snacks' on repeat.", "Good news: I'm loyal. Bad news: I'm starving.", "Let\u2019s not make my tombstone read 'died snackless.'", "I could really go for something that isn\u2019t floor right now.", "If I had more food, I\u2019d have less dying.", "Tell my story\u2026 unless you have food, then save me instead.", "Reminder: companions run better on calories.", "Critical condition achieved. Time for critical snacks.", "Half of my health is gone and so is all the jerky.", "My HP is lower than your standards. Fix that with food.", "Do we have a combat medic or a combat sandwich?", "My body says 'rest' but my stomach says 'buffet.'", "I\u2019ve had better days and more snacks.", "If 'nearly dead' had a flavor, it would be 'no food.'", "I swear I dodge better after a good meal.", "Low health has entered the chat. Please respond with food.", "Your companion is buffering\u2026 need food to continue.", "Consider this a polite pre-death snack request.", "I'm holding the line, but I'd rather be holding a sandwich.", "If reinforcements aren't coming, at least let the snacks arrive."};
        return lines[this.rand.nextInt(lines.length)];
    }
}

