/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.entity;

import com.majorbonghits.moderncompanions.core.ModConfig;
import com.majorbonghits.moderncompanions.entity.AbstractHumanCompanionEntity;
import com.majorbonghits.moderncompanions.item.DaggerItem;
import com.majorbonghits.moderncompanions.item.QuarterstaffItem;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class Alchemist
extends AbstractHumanCompanionEntity {
    private int potionTicker;

    public Alchemist(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
    }

    @Override
    public void tick() {
        if (!this.level().isClientSide()) {
            this.tossSupportiveMix();
            this.tossHostileMix();
            this.checkPotionSlot();
        }
        super.tick();
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData data) {
        if (((Boolean)ModConfig.safeGet(ModConfig.SPAWN_WEAPON)).booleanValue()) {
            this.inventory.setItem(4, Items.SPLASH_POTION.getDefaultInstance());
            this.checkPotionSlot();
        }
        return super.finalizeSpawn(level, difficulty, reason, data);
    }

    private void checkPotionSlot() {
        ItemStack stack;
        int i;
        ItemStack hand = this.getMainHandItem();
        for (i = 0; i < this.inventory.getContainerSize(); ++i) {
            stack = this.inventory.getItem(i);
            if (!hand.isEmpty() || !(stack.getItem() instanceof DaggerItem) && !(stack.getItem() instanceof QuarterstaffItem)) continue;
            this.setItemSlot(EquipmentSlot.MAINHAND, stack);
            hand = stack;
        }
        for (i = 0; i < this.inventory.getContainerSize(); ++i) {
            stack = this.inventory.getItem(i);
            if (!stack.is(Items.SPLASH_POTION) || !hand.isEmpty()) continue;
            this.setItemSlot(EquipmentSlot.MAINHAND, stack);
            hand = stack;
        }
    }

    private void tossSupportiveMix() {
        if (++this.potionTicker % 35 != 0) {
            return;
        }
        this.level().getEntities((Entity)this, this.getBoundingBox().inflate(8.0), this::isAlly).forEach(entity -> {
            LivingEntity living;
            if (entity instanceof LivingEntity && (living = (LivingEntity)entity).getHealth() / living.getMaxHealth() < 0.7f) {
                int amp = this.random.nextFloat() < 0.25f ? 1 : 0;
                living.heal(2.0f + (float)amp);
                living.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 80, amp, true, true));
            }
        });
    }

    private void tossHostileMix() {
        if (this.random.nextInt(45) != 0) {
            return;
        }
        this.level().getEntities((Entity)this, this.getBoundingBox().inflate(8.0), e -> {
            AbstractHumanCompanionEntity comp;
            TamableAnimal tam;
            return !(!(e instanceof LivingEntity) || this.isAlliedTo((Entity)e) || e instanceof TamableAnimal && (tam = (TamableAnimal)e).isOwnedBy(this.getOwner()) || e instanceof AbstractHumanCompanionEntity && (comp = (AbstractHumanCompanionEntity)((Object)e)).getOwner() == this.getOwner());
        }).stream().findFirst().ifPresent(entity -> {
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                boolean upgrade = this.random.nextFloat() < 0.2f;
                living.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 100, upgrade ? 1 : 0, true, true));
                living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 80, upgrade ? 1 : 0, true, true));
            }
        });
    }

    private boolean isAlly(Entity entity) {
        if (entity == this) {
            return true;
        }
        if (entity instanceof AbstractHumanCompanionEntity) {
            AbstractHumanCompanionEntity comp = (AbstractHumanCompanionEntity)entity;
            return comp.getOwner() != null && this.getOwner() != null && comp.getOwner() == this.getOwner();
        }
        if (entity instanceof TamableAnimal) {
            TamableAnimal tamable = (TamableAnimal)entity;
            return tamable.isTame() && this.getOwner() != null && this.getOwner().equals((Object)tamable.getOwner());
        }
        return entity == this.getOwner();
    }
}

