/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.entity;

import com.majorbonghits.moderncompanions.core.ModConfig;
import com.majorbonghits.moderncompanions.entity.AbstractHumanCompanionEntity;
import com.majorbonghits.moderncompanions.entity.ai.ArcherRangedBowAttackGoal;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class Archer
extends AbstractHumanCompanionEntity
implements RangedAttackMob {
    public Archer(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
        this.goalSelector.addGoal(2, new ArcherRangedBowAttackGoal<Archer>(this, 1.0, 20, 20.0f));
    }

    public void checkBow() {
        ItemStack hand = this.getItemBySlot(EquipmentSlot.MAINHAND);
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack stack = this.inventory.getItem(i);
            if (!(stack.getItem() instanceof BowItem) || !hand.isEmpty()) continue;
            this.setItemSlot(EquipmentSlot.MAINHAND, stack);
        }
    }

    @Override
    public void tick() {
        if (!this.level().isClientSide()) {
            this.checkBow();
        }
        super.tick();
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        ItemStack bow = this.getItemInHand(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem));
        ItemStack projectile = this.getProjectile(bow);
        AbstractArrow arrow = ProjectileUtil.getMobArrow((LivingEntity)this, (ItemStack)projectile, (float)distanceFactor, (ItemStack)bow);
        double dx = target.getX() - this.getX();
        double dy = target.getY(0.3333333333333333) - arrow.getY();
        double dz = target.getZ() - this.getZ();
        double distance = Math.sqrt(dx * dx + dz * dz);
        arrow.shoot(dx, dy + distance * (double)0.2f, dz, 1.6f, (float)(this.level().getDifficulty().getId() * 3));
        this.playSound(SoundEvents.ARROW_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)arrow);
        if (!this.level().isClientSide) {
            this.getMainHandItem().hurtAndBreak(1, (LivingEntity)this, EquipmentSlot.MAINHAND);
            if (this.getMainHandItem().isEmpty() && this.isTame() && this.getOwner() != null) {
                MutableComponent broken = Component.literal((String)"My bow broke!");
                this.getOwner().sendSystemMessage((Component)Component.translatable((String)"chat.type.text", (Object[])new Object[]{this.getDisplayName(), broken}));
            }
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        this.checkBow();
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData data) {
        if (((Boolean)ModConfig.safeGet(ModConfig.SPAWN_WEAPON)).booleanValue()) {
            this.inventory.setItem(4, Items.BOW.getDefaultInstance());
            this.checkBow();
        }
        return super.finalizeSpawn(level, difficulty, reason, data);
    }
}

