/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.entity;

import com.majorbonghits.moderncompanions.core.ModConfig;
import com.majorbonghits.moderncompanions.core.TagsInit;
import com.majorbonghits.moderncompanions.entity.AbstractHumanCompanionEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class Axeguard
extends AbstractHumanCompanionEntity {
    public Axeguard(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
    }

    public boolean isAxe(ItemStack stack) {
        return stack.is(TagsInit.Items.AXES) || !stack.is(TagsInit.Items.SWORDS) && stack.getItem() instanceof AxeItem;
    }

    public void checkAxe() {
        ItemStack hand = this.getItemBySlot(EquipmentSlot.MAINHAND);
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack itemstack = this.inventory.getItem(i);
            if (!this.isAxe(itemstack) || !hand.isEmpty()) continue;
            this.setItemSlot(EquipmentSlot.MAINHAND, itemstack);
            hand = itemstack;
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        this.checkAxe();
    }

    @Override
    public void tick() {
        if (!this.level().isClientSide()) {
            this.checkAxe();
        }
        super.tick();
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData data) {
        ItemStack itemstack;
        if (((Boolean)ModConfig.safeGet(ModConfig.SPAWN_WEAPON)).booleanValue() && !(itemstack = this.getSpawnAxe()).isEmpty()) {
            this.inventory.setItem(4, itemstack);
            this.checkAxe();
        }
        return super.finalizeSpawn(level, difficulty, reason, data);
    }

    public ItemStack getSpawnAxe() {
        float materialFloat = this.random.nextFloat();
        if (materialFloat < 0.5f) {
            return Items.WOODEN_AXE.getDefaultInstance();
        }
        if (materialFloat < 0.9f) {
            return Items.STONE_AXE.getDefaultInstance();
        }
        return Items.IRON_AXE.getDefaultInstance();
    }
}

