/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.entity;

import com.majorbonghits.moderncompanions.core.ModConfig;
import com.majorbonghits.moderncompanions.entity.AbstractHumanCompanionEntity;
import com.majorbonghits.moderncompanions.entity.ai.ArcherRangedBowAttackGoal;
import com.majorbonghits.moderncompanions.entity.ai.FollowBeastmasterGoal;
import com.majorbonghits.moderncompanions.item.ClubItem;
import com.majorbonghits.moderncompanions.item.HammerItem;
import com.majorbonghits.moderncompanions.item.SpearItem;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class Beastmaster
extends AbstractHumanCompanionEntity
implements RangedAttackMob {
    public static final String BEASTMASTER_OWNER_TAG = "BeastmasterOwner";
    private static final String PET_TAG = "BeastmasterPet";
    private static final String PET_RESPAWN_TAG = "BeastRespawn";
    private static final String PET_LOOKUP_TAG = "BeastLookup";
    private static final String PET_TYPE_TAG = "BeastPetType";
    private static final int PET_LOAD_GRACE_TICKS = 80;
    private static final String[] PET_NAMES = new String[]{"Fang", "Ember", "Shadow", "Ash", "Pebble", "Luna", "Mistral", "Bolt", "Blaze", "Copper", "Rogue", "Echo", "Nova", "Willow", "Koda", "Storm", "Maple", "Onyx", "Bramble", "Tango", "Sable", "Cinder", "Aspen", "Mango", "Hazel", "Riven", "Basil", "Skye", "Thistle", "Hollow", "Marble", "Sparrow", "Juniper", "Clover", "Garnet", "Jasper", "Quartz", "Slate", "Nimbus", "Pip", "Pixel", "Atlas", "Soot", "Dusk", "Rumble", "Velvet", "Glint", "Cobb", "Indigo", "Taffy", "Poppy", "Rust", "Zephyr", "Comet", "Drift", "Puddle", "Mochi", "Ivy", "Thyme", "Cricket", "Freckle", "Pepper", "Kumo", "Moss", "Berry", "Twix", "Gizmo", "Fable", "Rook", "Draco", "Smudge", "Jinx", "Sunny", "Aurora", "Cosmo", "Sprout", "Nugget", "Biscuit", "Noodle", "Chai", "Pumpkin", "Glacier", "Frost", "Whisper", "Galaxy", "Mocha", "Sprinkle", "Truffle", "Phoenix", "Rune", "Tinsel", "Fidget", "Button", "Havoc", "Flint", "Blossom", "Dottie", "Ziggy", "Lyric", "Miso", "Rascal", "Quill", "Misty", "Clove", "Curry", "River", "Stormy", "Indy", "Loaf", "Pickle", "Sushi", "Bean", "Mellow", "Raven", "Cobalt", "Violet", "Nyx", "Cypress", "Lotus", "Opal", "Topaz", "Brick", "Sprite", "Parker", "Indie", "Bubbles", "Rafa", "Rhea", "Finn", "Rory", "Sora", "Loki", "Opie", "Pepita", "Rolo", "Ritz", "Cocoa", "Churro", "Frito", "Tempo", "Rhythm", "Melody", "Aria", "Jelly", "Peanut", "Sesame", "Waffle", "Pancake", "Taco", "Nacho", "Salsa", "Kiwi", "Fig", "Plum", "Cherry", "Petal", "Mulberry", "Drizzle", "Marshmallow", "Pebbles", "Cinnamon", "Saffron", "Nebula"};
    private static final ResourceLocation PET_ATTACK_MOD = ResourceLocation.fromNamespaceAndPath((String)"modern_companions", (String)"pet_attack_bonus");
    private static final ResourceLocation PET_HEALTH_MOD = ResourceLocation.fromNamespaceAndPath((String)"modern_companions", (String)"pet_health_bonus");
    private static final ResourceLocation PET_SPEED_MOD = ResourceLocation.fromNamespaceAndPath((String)"modern_companions", (String)"pet_speed_bonus");
    private UUID petId;
    private int petRespawnTimer;
    private int missingPetGrace;
    private ResourceLocation petTypeId;
    private boolean suppressPetRespawn;

    @Nullable
    public LivingEntity getPetEntity(ServerLevel level) {
        LivingEntity living;
        if (this.petId == null) {
            return null;
        }
        Entity pet = level.getEntity(this.petId);
        return pet instanceof LivingEntity ? (living = (LivingEntity)pet) : null;
    }

    public Beastmaster(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
        this.goalSelector.addGoal(2, new ArcherRangedBowAttackGoal<Beastmaster>(this, 1.05, 22, 20.0f));
    }

    @Override
    public void tick() {
        if (!this.level().isClientSide()) {
            this.checkBow();
            this.managePet();
            this.applyAnimalBuffs();
        }
        super.tick();
    }

    @Override
    public void die(DamageSource source) {
        if (!this.level().isClientSide()) {
            this.suppressPetRespawn = true;
            this.petRespawnTimer = 0;
            this.missingPetGrace = 0;
            this.despawnPet();
        }
        super.die(source);
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        if (this.isOwnPet(entity)) {
            return false;
        }
        boolean hit = super.doHurtTarget(entity);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (!this.level().isClientSide() && this.isBeast(living)) {
                living.hurt(this.damageSources().mobAttack((LivingEntity)this), 2.5f);
            }
        }
        return hit;
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (this.isOwnPet((Entity)target)) {
            return;
        }
        ItemStack bow = this.getItemInHand(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem));
        if (bow.isEmpty() || !(bow.getItem() instanceof BowItem)) {
            return;
        }
        ItemStack projectile = this.getProjectile(bow);
        if (projectile.isEmpty() || !(projectile.getItem() instanceof ArrowItem)) {
            return;
        }
        AbstractArrow arrow = ProjectileUtil.getMobArrow((LivingEntity)this, (ItemStack)projectile, (float)distanceFactor, (ItemStack)bow);
        double dx = target.getX() - this.getX();
        double dy = target.getY(0.3333333333333333) - arrow.getY();
        double dz = target.getZ() - this.getZ();
        double distance = Math.sqrt(dx * dx + dz * dz);
        arrow.shoot(dx, dy + distance * (double)0.18f, dz, 1.55f, (float)(this.level().getDifficulty().getId() * 3));
        this.level().addFreshEntity((Entity)arrow);
        if (!this.level().isClientSide) {
            this.getMainHandItem().hurtAndBreak(1, (LivingEntity)this, EquipmentSlot.MAINHAND);
        }
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData data) {
        if (((Boolean)ModConfig.safeGet(ModConfig.SPAWN_WEAPON)).booleanValue()) {
            this.inventory.setItem(4, Items.BOW.getDefaultInstance());
            this.checkBow();
        }
        SpawnGroupData spawnData = super.finalizeSpawn(level, difficulty, reason, data);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.petId == null) {
                this.spawnPet(serverLevel);
            }
        }
        return spawnData;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.petId != null) {
            tag.putUUID(PET_TAG, this.petId);
        }
        tag.putInt(PET_RESPAWN_TAG, this.petRespawnTimer);
        tag.putInt(PET_LOOKUP_TAG, this.missingPetGrace);
        if (this.petTypeId != null) {
            tag.putString(PET_TYPE_TAG, this.petTypeId.toString());
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.hasUUID(PET_TAG)) {
            this.petId = tag.getUUID(PET_TAG);
        }
        this.petRespawnTimer = tag.getInt(PET_RESPAWN_TAG);
        this.missingPetGrace = tag.getInt(PET_LOOKUP_TAG);
        if (tag.contains(PET_TYPE_TAG)) {
            this.petTypeId = ResourceLocation.tryParse((String)tag.getString(PET_TYPE_TAG));
        }
        this.checkBow();
    }

    private void checkBow() {
        ItemStack hand = this.getItemBySlot(EquipmentSlot.MAINHAND);
        if (!(hand.isEmpty() || this.isPreferredWeapon(hand) && this.inventoryContains(hand.getItem()))) {
            this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
            hand = ItemStack.EMPTY;
        }
        ItemStack candidate = ItemStack.EMPTY;
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack stack = this.inventory.getItem(i);
            if (stack.getItem() instanceof BowItem) {
                candidate = stack;
                break;
            }
            if (!candidate.isEmpty() || !(stack.getItem() instanceof ClubItem) && !(stack.getItem() instanceof HammerItem) && !(stack.getItem() instanceof SpearItem)) continue;
            candidate = stack;
        }
        if (hand.isEmpty() && !candidate.isEmpty()) {
            this.setItemSlot(EquipmentSlot.MAINHAND, candidate);
        }
    }

    private boolean isPreferredWeapon(ItemStack stack) {
        return stack.getItem() instanceof BowItem || stack.getItem() instanceof ClubItem || stack.getItem() instanceof HammerItem || stack.getItem() instanceof SpearItem;
    }

    private boolean inventoryContains(Item item) {
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            if (this.inventory.getItem(i).getItem() != item) continue;
            return true;
        }
        return false;
    }

    private boolean isBeast(LivingEntity target) {
        return target instanceof Wolf || target instanceof Hoglin || target.getType().getCategory() == MobCategory.CREATURE;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void managePet() {
        LivingEntity pet;
        ServerLevel server;
        block8: {
            Level level = this.level();
            if (!(level instanceof ServerLevel)) return;
            server = (ServerLevel)level;
            if (!this.shouldAllowPetRespawn()) {
                return;
            }
            LivingEntity livingEntity = pet = this.petId != null ? (LivingEntity)server.getEntity(this.petId) : null;
            if (this.petId != null && pet == null) {
                pet = this.findExistingPet(server);
                if (pet != null) {
                    this.petId = pet.getUUID();
                    this.missingPetGrace = 0;
                    this.ensurePetOwnership(pet);
                    this.setupPetGoalsIfNeeded(pet);
                    break block8;
                } else {
                    if (this.missingPetGrace == 0) {
                        this.missingPetGrace = 80;
                        return;
                    }
                    --this.missingPetGrace;
                    if (this.missingPetGrace > 0) return;
                    this.petId = null;
                    this.petRespawnTimer = Math.max(this.petRespawnTimer, 120);
                    return;
                }
            }
            this.missingPetGrace = 0;
        }
        if (pet != null) {
            if (pet.isAlive()) {
                this.ensurePetOwnership(pet);
                this.ensurePetTypeFromEntity(pet);
                this.setupPetGoalsIfNeeded(pet);
                this.drivePetCombat(pet);
                return;
            }
            this.ensurePetTypeFromEntity(pet);
            this.petId = null;
            this.petRespawnTimer = 120;
            this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 120, 1, true, true));
            this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 120, 0, true, true));
        }
        if (this.petRespawnTimer > 0) {
            --this.petRespawnTimer;
            return;
        }
        this.spawnPet(server);
    }

    private void drivePetCombat(LivingEntity pet) {
        LivingEntity target = this.pickThreat();
        if (target == null || target == this || target == this.getOwner()) {
            return;
        }
        if (!(pet instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)pet;
        this.maybeAddMeleeGoal(mob);
        if (!target.isAlive()) {
            mob.setTarget(null);
            return;
        }
        if (mob.getTarget() != target) {
            mob.setTarget(target);
        }
        if (mob.getNavigation().isDone() || mob.distanceToSqr((Entity)target) > 4.0) {
            mob.getNavigation().moveTo((Entity)target, 1.25);
        }
        if (mob.distanceToSqr((Entity)target) < 2.25 && mob.tickCount % 12 == 0) {
            this.swingAndDamage(mob, target);
        }
    }

    public boolean canAttack(LivingEntity target) {
        if (this.isOwnPet((Entity)target)) {
            return false;
        }
        return super.canAttack(target);
    }

    private boolean isOwnPet(Entity entity) {
        return this.petId != null && entity != null && this.petId.equals(entity.getUUID());
    }

    private void swingAndDamage(Mob mob, LivingEntity target) {
        float dmg = 3.0f;
        AttributeInstance attack = mob.getAttribute(Attributes.ATTACK_DAMAGE);
        if (attack != null) {
            dmg = (float)attack.getValue();
        }
        mob.swing(InteractionHand.MAIN_HAND, true);
        target.hurt(mob.damageSources().mobAttack((LivingEntity)mob), dmg);
    }

    @Nullable
    private LivingEntity pickThreat() {
        Player player;
        LivingEntity playerAttacker;
        LivingEntity attacker = this.getLastHurtByMob();
        if (attacker != null && attacker.isAlive()) {
            return attacker;
        }
        LivingEntity livingEntity = this.getOwner();
        if (livingEntity instanceof Player && (playerAttacker = (player = (Player)livingEntity).getLastHurtByMob()) != null && playerAttacker.isAlive()) {
            return playerAttacker;
        }
        LivingEntity target = this.getTarget();
        if (target != null && target.isAlive()) {
            return target;
        }
        return null;
    }

    private void maybeAddMeleeGoal(Mob mob) {
        boolean hasAttackAttribute = mob.getAttributes().hasAttribute(Attributes.ATTACK_DAMAGE);
        if (!hasAttackAttribute) {
            mob.goalSelector.getAvailableGoals().stream().filter(w -> w.getGoal() instanceof MeleeAttackGoal).map(WrappedGoal::getGoal).toList().forEach(arg_0 -> ((GoalSelector)mob.goalSelector).removeGoal(arg_0));
            return;
        }
        boolean hasAttackGoal = mob.goalSelector.getAvailableGoals().stream().anyMatch(w -> w.getGoal() instanceof MeleeAttackGoal);
        if (!hasAttackGoal && mob instanceof PathfinderMob) {
            PathfinderMob pathMob = (PathfinderMob)mob;
            pathMob.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal(pathMob, 1.25, true));
        }
    }

    @Nullable
    private LivingEntity findExistingPet(ServerLevel server) {
        LivingEntity byId;
        if (this.petId != null && (byId = (LivingEntity)server.getEntity(this.petId)) != null) {
            this.ensurePetTypeFromEntity(byId);
            return byId;
        }
        return server.getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(32.0), e -> {
            TamableAnimal tam;
            return this.petId != null && e.getUUID().equals(this.petId) || e instanceof TamableAnimal && (tam = (TamableAnimal)e).isTame() && this.getUUID().equals(tam.getOwnerUUID());
        }).stream().findFirst().map(e -> {
            this.ensurePetTypeFromEntity((LivingEntity)e);
            return e;
        }).orElse(null);
    }

    private void spawnPet(ServerLevel server) {
        LivingEntity pet = this.createPet(server);
        if (pet == null) {
            return;
        }
        pet.moveTo(this.getX() + (this.random.nextDouble() - 0.5) * 2.0, this.getY(), this.getZ() + (this.random.nextDouble() - 0.5) * 2.0, this.getYRot(), this.getXRot());
        if (pet instanceof TamableAnimal) {
            TamableAnimal tamable = (TamableAnimal)pet;
            tamable.setTame(true, true);
            tamable.setOwnerUUID(this.getUUID());
            tamable.setOrderedToSit(false);
        }
        if (pet instanceof Mob) {
            Mob mob = (Mob)pet;
            mob.finalizeSpawn((ServerLevelAccessor)server, server.getCurrentDifficultyAt(this.blockPosition()), MobSpawnType.MOB_SUMMONED, null);
            this.setupPetGoalsIfNeeded((LivingEntity)mob);
            mob.setPersistenceRequired();
        }
        pet.getPersistentData().putUUID(BEASTMASTER_OWNER_TAG, this.getUUID());
        this.assignRandomPetName(pet);
        server.addFreshEntity((Entity)pet);
        this.petId = pet.getUUID();
    }

    private void ensurePetTypeFromEntity(LivingEntity pet) {
        if (this.petTypeId == null) {
            this.petTypeId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)pet.getType());
        }
    }

    private void despawnPet() {
        Level level;
        if (this.level().isClientSide() || !((level = this.level()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        this.petRespawnTimer = 0;
        this.missingPetGrace = 0;
        this.suppressPetRespawn = true;
        boolean removed = false;
        if (this.petId != null) {
            Entity pet = server.getEntity(this.petId);
            if (pet != null) {
                pet.discard();
                removed = true;
            }
            this.petId = null;
        }
        if (!removed) {
            for (LivingEntity candidate : server.getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(64.0))) {
                if (!candidate.getPersistentData().hasUUID(BEASTMASTER_OWNER_TAG) || !candidate.getPersistentData().getUUID(BEASTMASTER_OWNER_TAG).equals(this.getUUID())) continue;
                candidate.discard();
                removed = true;
            }
        }
    }

    public void forceDespawnPet() {
        this.despawnPet();
    }

    private boolean shouldAllowPetRespawn() {
        return !this.suppressPetRespawn && this.isAlive() && !this.isRemoved();
    }

    @Nullable
    private LivingEntity createPet(ServerLevel server) {
        LivingEntity pet;
        EntityType<? extends LivingEntity> type = this.resolveOrPickPetType();
        LivingEntity livingEntity = pet = type != null ? (LivingEntity)type.create((Level)server) : null;
        if (pet == null && type == EntityType.PANDA) {
            pet = new Panda(EntityType.PANDA, (Level)server);
        }
        if (pet == null) {
            this.petTypeId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.WOLF);
            pet = (LivingEntity)EntityType.WOLF.create((Level)server);
        }
        return pet;
    }

    private EntityType<? extends LivingEntity> resolveOrPickPetType() {
        EntityType chosen;
        if (this.petTypeId != null) {
            EntityType resolved = BuiltInRegistries.ENTITY_TYPE.getOptional(this.petTypeId).orElse(EntityType.WOLF);
            this.petTypeId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)resolved);
            return resolved;
        }
        int roll = this.random.nextInt(1000);
        if (roll < 5) {
            chosen = EntityType.POLAR_BEAR;
        } else if (roll < 15) {
            chosen = EntityType.HOGLIN;
        } else {
            int common = this.random.nextInt(9);
            chosen = switch (common) {
                case 0 -> EntityType.CAMEL;
                case 1 -> EntityType.CAT;
                case 2 -> EntityType.FOX;
                case 3 -> EntityType.GOAT;
                case 4 -> EntityType.OCELOT;
                case 5 -> EntityType.PANDA;
                case 6 -> EntityType.PIG;
                case 7 -> EntityType.SPIDER;
                case 8 -> EntityType.WOLF;
                default -> EntityType.WOLF;
            };
        }
        this.petTypeId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)chosen);
        return chosen;
    }

    private void sanitizePetGoals(Mob mob) {
        mob.targetSelector.getAvailableGoals().stream().map(WrappedGoal::getGoal).toList().forEach(arg_0 -> ((GoalSelector)mob.targetSelector).removeGoal(arg_0));
    }

    private void addFollowGoal(Mob mob) {
        boolean hasFollow = mob.goalSelector.getAvailableGoals().stream().anyMatch(w -> w.getGoal() instanceof FollowBeastmasterGoal);
        if (!hasFollow) {
            mob.goalSelector.addGoal(1, (Goal)new FollowBeastmasterGoal(mob, this, 1.2, 4.0f, 2.0f));
        }
    }

    private void setupPetGoalsIfNeeded(LivingEntity pet) {
        if (!(pet instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)pet;
        this.sanitizePetGoals(mob);
        this.pruneWanderGoals(mob);
        this.boostPandaSpeedIfNeeded(mob);
        this.addFollowGoal(mob);
        this.applyPetScaling(mob);
    }

    private void pruneWanderGoals(Mob mob) {
        mob.goalSelector.getAvailableGoals().stream().filter(w -> w.getGoal() instanceof RandomStrollGoal || w.getGoal() instanceof WaterAvoidingRandomStrollGoal).map(WrappedGoal::getGoal).toList().forEach(arg_0 -> ((GoalSelector)mob.goalSelector).removeGoal(arg_0));
    }

    private void applyPetScaling(Mob mob) {
        AttributeInstance speed;
        AttributeInstance health;
        double str = Math.max(0, this.getStrength());
        double dex = Math.max(0, this.getDexterity());
        double end = Math.max(0, this.getEndurance());
        AttributeInstance attack = mob.getAttribute(Attributes.ATTACK_DAMAGE);
        if (attack != null) {
            this.removeModifier(attack, PET_ATTACK_MOD);
            double bonus = 0.15 * str;
            if (bonus > 0.0) {
                attack.addPermanentModifier(new AttributeModifier(PET_ATTACK_MOD, bonus, AttributeModifier.Operation.ADD_VALUE));
            }
        }
        if ((health = mob.getAttribute(Attributes.MAX_HEALTH)) != null) {
            this.removeModifier(health, PET_HEALTH_MOD);
            double bonus = 0.4 * end;
            if (bonus > 0.0) {
                health.addPermanentModifier(new AttributeModifier(PET_HEALTH_MOD, bonus, AttributeModifier.Operation.ADD_VALUE));
                mob.setHealth((float)health.getValue());
            }
        }
        if ((speed = mob.getAttribute(Attributes.MOVEMENT_SPEED)) != null) {
            this.removeModifier(speed, PET_SPEED_MOD);
            double bonus = 0.003 * dex;
            if (bonus > 0.0) {
                speed.addPermanentModifier(new AttributeModifier(PET_SPEED_MOD, bonus, AttributeModifier.Operation.ADD_VALUE));
            }
        }
    }

    private void removeModifier(AttributeInstance attribute, ResourceLocation id) {
        attribute.removeModifier(id);
    }

    private void boostPandaSpeedIfNeeded(Mob mob) {
        AttributeInstance speed;
        if (mob instanceof Panda) {
            AttributeInstance speed2 = mob.getAttribute(Attributes.MOVEMENT_SPEED);
            if (speed2 != null && speed2.getBaseValue() < 0.3) {
                speed2.setBaseValue(0.3);
            }
        } else if (mob instanceof Camel && (speed = mob.getAttribute(Attributes.MOVEMENT_SPEED)) != null && speed.getBaseValue() < 0.2) {
            speed.setBaseValue(0.2);
        }
    }

    private void ensurePetOwnership(LivingEntity pet) {
        if (pet instanceof TamableAnimal) {
            TamableAnimal tamable = (TamableAnimal)pet;
            if (!this.getUUID().equals(tamable.getOwnerUUID())) {
                tamable.setTame(true, false);
                tamable.setOwnerUUID(this.getUUID());
                tamable.setOrderedToSit(false);
            }
        }
        pet.getPersistentData().putUUID(BEASTMASTER_OWNER_TAG, this.getUUID());
        this.enforcePetNameVisibility(pet);
    }

    private void assignRandomPetName(LivingEntity pet) {
        if (pet.hasCustomName()) {
            return;
        }
        String name = PET_NAMES[this.random.nextInt(PET_NAMES.length)];
        pet.setCustomName((Component)Component.literal((String)name));
        pet.setCustomNameVisible(false);
    }

    private void enforcePetNameVisibility(LivingEntity pet) {
        if (pet.hasCustomName() && pet.isCustomNameVisible()) {
            pet.setCustomNameVisible(false);
        }
    }

    private void applyAnimalBuffs() {
        if (this.level().random.nextInt(80) != 0 || !(this.level() instanceof ServerLevel)) {
            return;
        }
        this.level().getEntitiesOfClass(TamableAnimal.class, this.getBoundingBox().inflate(10.0), tamable -> tamable.isTame() && tamable.getOwner() != null && (tamable.getOwner().equals((Object)this) || tamable.getOwner().equals((Object)this.getOwner()))).forEach(tame -> {
            boolean boostDamage = this.random.nextBoolean();
            int amplifier = this.random.nextFloat() < 0.35f ? 1 : 0;
            MobEffectInstance effect = boostDamage ? new MobEffectInstance(MobEffects.DAMAGE_BOOST, 160, amplifier, true, true) : new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 160, amplifier, true, true);
            tame.addEffect(effect);
        });
    }

    public ItemStack getProjectile(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof ProjectileWeaponItem) {
            ProjectileWeaponItem weapon = (ProjectileWeaponItem)item;
            Predicate predicate = weapon.getSupportedHeldProjectiles();
            ItemStack projectiles = ProjectileWeaponItem.getHeldProjectile((LivingEntity)this, (Predicate)predicate);
            return projectiles.isEmpty() ? new ItemStack((ItemLike)Items.ARROW) : projectiles;
        }
        return new ItemStack((ItemLike)Items.ARROW);
    }
}

