/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.entity;

import com.majorbonghits.moderncompanions.entity.Beastmaster;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

@EventBusSubscriber(modid="modern_companions")
public final class BeastmasterEvents {
    private BeastmasterEvents() {
    }

    @SubscribeEvent
    public static void onPetKill(LivingDeathEvent event) {
        Entity killer = event.getSource().getEntity();
        if (!(killer instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)killer;
        Level level = event.getEntity().level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        CompoundTag data = living.getPersistentData();
        if (!data.hasUUID("BeastmasterOwner")) {
            return;
        }
        UUID ownerId = data.getUUID("BeastmasterOwner");
        Entity owner = server.getEntity(ownerId);
        if (owner instanceof Beastmaster) {
            Beastmaster beastmaster = (Beastmaster)owner;
            beastmaster.incrementKillCount();
        }
    }
}

