/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.entity;

import com.majorbonghits.moderncompanions.core.ModConfig;
import com.majorbonghits.moderncompanions.core.TagsInit;
import com.majorbonghits.moderncompanions.entity.AbstractHumanCompanionEntity;
import com.majorbonghits.moderncompanions.item.ClubItem;
import com.majorbonghits.moderncompanions.item.HammerItem;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class Berserker
extends AbstractHumanCompanionEntity {
    private static final ResourceLocation RAGE_MOD = ResourceLocation.fromNamespaceAndPath((String)"modern_companions", (String)"berserker_rage");
    private static final ResourceLocation KB_MOD = ResourceLocation.fromNamespaceAndPath((String)"modern_companions", (String)"berserker_kb");

    public Berserker(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.25, true));
        this.bumpKnockbackResist();
    }

    @Override
    public void tick() {
        if (!this.level().isClientSide()) {
            this.checkWeapons();
            this.updateRage();
        }
        super.tick();
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        float adjusted = amount;
        if (!source.is(DamageTypeTags.BYPASSES_ARMOR)) {
            adjusted *= 1.1f;
        }
        return super.hurt(source, adjusted);
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        boolean hit = super.doHurtTarget(entity);
        if (!this.level().isClientSide() && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (hit) {
                this.cleaveAround(living);
            }
        }
        return hit;
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData data) {
        if (((Boolean)ModConfig.safeGet(ModConfig.SPAWN_WEAPON)).booleanValue()) {
            this.inventory.setItem(4, this.pickSpawnWeapon());
            this.checkWeapons();
        }
        return super.finalizeSpawn(level, difficulty, reason, data);
    }

    private ItemStack pickSpawnWeapon() {
        float roll = this.random.nextFloat();
        if (roll < 0.4f) {
            return Items.WOODEN_AXE.getDefaultInstance();
        }
        if (roll < 0.75f) {
            return Items.STONE_AXE.getDefaultInstance();
        }
        if (roll < 0.9f) {
            return Items.IRON_AXE.getDefaultInstance();
        }
        return Items.IRON_SWORD.getDefaultInstance();
    }

    private void bumpKnockbackResist() {
        AttributeInstance kb = this.getAttribute(Attributes.KNOCKBACK_RESISTANCE);
        if (kb != null && kb.getModifier(KB_MOD) == null) {
            kb.addPermanentModifier(new AttributeModifier(KB_MOD, 0.45, AttributeModifier.Operation.ADD_VALUE));
        }
    }

    private void checkWeapons() {
        ItemStack hand = this.getItemBySlot(EquipmentSlot.MAINHAND);
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack stack = this.inventory.getItem(i);
            if (!this.isPreferredWeapon(stack) || !hand.isEmpty()) continue;
            this.setItemSlot(EquipmentSlot.MAINHAND, stack);
            hand = stack;
        }
    }

    private boolean isPreferredWeapon(ItemStack stack) {
        return stack.is(TagsInit.Items.AXES) || stack.is(TagsInit.Items.SWORDS) || stack.getItem() instanceof AxeItem || stack.getItem() instanceof SwordItem || stack.getItem() instanceof ClubItem || stack.getItem() instanceof HammerItem;
    }

    private void updateRage() {
        AttributeInstance damage = this.getAttribute(Attributes.ATTACK_DAMAGE);
        if (damage == null) {
            return;
        }
        damage.removeModifier(RAGE_MOD);
        float percentMissing = 1.0f - this.getHealth() / this.getMaxHealth();
        double bonus = Math.min(5.0, 6.0 * (double)percentMissing);
        if (bonus > 0.0) {
            damage.addTransientModifier(new AttributeModifier(RAGE_MOD, bonus, AttributeModifier.Operation.ADD_VALUE));
        }
    }

    private void cleaveAround(LivingEntity primary) {
        double reach = 2.8;
        double splash = Math.max(1.0, this.getAttributeValue(Attributes.ATTACK_DAMAGE) * 0.35);
        this.level().getEntitiesOfClass(LivingEntity.class, primary.getBoundingBox().inflate(reach), other -> {
            AbstractHumanCompanionEntity comp;
            TamableAnimal tam;
            return !(other == this || other == primary || this.isAlliedTo((Entity)other) || other instanceof TamableAnimal && (tam = (TamableAnimal)other).isOwnedBy(this.getOwner()) || other instanceof AbstractHumanCompanionEntity && (comp = (AbstractHumanCompanionEntity)((Object)other)).getOwner() == this.getOwner());
        }).forEach(other -> other.hurt(this.damageSources().mobAttack((LivingEntity)this), (float)splash));
    }
}

