/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.entity;

import com.majorbonghits.moderncompanions.core.ModConfig;
import com.majorbonghits.moderncompanions.entity.AbstractHumanCompanionEntity;
import com.majorbonghits.moderncompanions.item.QuarterstaffItem;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class Cleric
extends AbstractHumanCompanionEntity {
    private int healTicker;

    public Cleric(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
    }

    @Override
    public void tick() {
        if (!this.level().isClientSide()) {
            this.checkStaff();
            this.tickHealing();
            this.tickBlessings();
        }
        super.tick();
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        Mob mob;
        boolean hit = super.doHurtTarget(entity);
        if (!this.level().isClientSide() && entity instanceof Mob && ((mob = (Mob)entity).getType().is(EntityTypeTags.UNDEAD) || mob instanceof Zombie)) {
            mob.hurt(this.damageSources().mobAttack((LivingEntity)this), 3.0f);
        }
        return hit;
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData data) {
        if (((Boolean)ModConfig.safeGet(ModConfig.SPAWN_WEAPON)).booleanValue()) {
            this.inventory.setItem(4, Items.GOLDEN_SWORD.getDefaultInstance());
            this.inventory.setItem(5, Items.TOTEM_OF_UNDYING.getDefaultInstance());
            this.checkStaff();
        }
        return super.finalizeSpawn(level, difficulty, reason, data);
    }

    private void checkStaff() {
        ItemStack hand = this.getItemBySlot(EquipmentSlot.MAINHAND);
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack stack = this.inventory.getItem(i);
            if (!stack.is(Items.GOLDEN_SWORD) && !(stack.getItem() instanceof BowItem) && !(stack.getItem() instanceof QuarterstaffItem) || !hand.isEmpty()) continue;
            this.setItemSlot(EquipmentSlot.MAINHAND, stack);
            hand = stack;
        }
        ItemStack offhand = this.getItemBySlot(EquipmentSlot.OFFHAND);
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack stack = this.inventory.getItem(i);
            if (!stack.is(Items.TOTEM_OF_UNDYING) || !offhand.isEmpty()) continue;
            this.setItemSlot(EquipmentSlot.OFFHAND, stack);
            offhand = stack;
        }
    }

    private void tickHealing() {
        if (++this.healTicker % 30 != 0) {
            return;
        }
        this.level().getEntities((Entity)this, this.getBoundingBox().inflate(6.0), this::isAlly).forEach(e -> {
            LivingEntity living;
            if (e instanceof LivingEntity && (living = (LivingEntity)e).getHealth() / living.getMaxHealth() < 0.65f) {
                living.heal(2.5f);
                living.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 60, 0, true, true));
            }
        });
    }

    private void tickBlessings() {
        if (this.random.nextInt(120) != 0) {
            return;
        }
        this.level().getEntities((Entity)this, this.getBoundingBox().inflate(6.0), this::isAlly).forEach(e -> {
            if (e instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)e;
                living.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 100, 0, true, true));
                living.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 80, 0, true, true));
            }
        });
    }

    private boolean isAlly(Entity entity) {
        if (entity == this) {
            return false;
        }
        if (entity instanceof AbstractHumanCompanionEntity) {
            AbstractHumanCompanionEntity comp = (AbstractHumanCompanionEntity)entity;
            return comp.getOwner() != null && this.getOwner() != null && comp.getOwner() == this.getOwner();
        }
        if (entity instanceof TamableAnimal) {
            TamableAnimal tamable = (TamableAnimal)entity;
            return tamable.isTame() && this.getOwner() != null && this.getOwner().equals((Object)tamable.getOwner());
        }
        return entity == this.getOwner();
    }
}

