/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.entity;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Giant;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionContents;

public class CompanionData {
    public static final Random rand = new Random();
    public static final Item[] ALL_FOODS = new Item[]{Items.COOKIE, Items.BREAD, Items.MELON_SLICE, Items.APPLE, Items.SWEET_BERRIES, Items.CARROT, Items.BAKED_POTATO, Items.COOKED_SALMON, Items.COOKED_COD, Items.COOKED_MUTTON, Items.COOKED_PORKCHOP, Items.COOKED_BEEF, Items.COOKED_CHICKEN, Items.COOKED_RABBIT};
    public static final Item[] EXTRA_HEAL_CONSUMABLES = new Item[]{Items.GOLDEN_APPLE, Items.ENCHANTED_GOLDEN_APPLE, Items.GOLDEN_CARROT, Items.HONEY_BOTTLE};
    public static final Item[] RESOURCE_ITEMS = new Item[]{Items.COAL, Items.CHARCOAL, Items.IRON_INGOT, Items.GOLD_INGOT, Items.COPPER_INGOT, Items.DIAMOND, Items.EMERALD, Items.LAPIS_LAZULI, Items.REDSTONE, Items.QUARTZ, Items.AMETHYST_SHARD};
    private static final Set<Item> DISALLOWED_FOODS = Set.of(Items.SPIDER_EYE, Items.ROTTEN_FLESH, Items.BEEF, Items.PORKCHOP, Items.CHICKEN, Items.MUTTON, Items.RABBIT, Items.COD, Items.SALMON);
    public static final MutableComponent[] tameFail = new MutableComponent[]{Component.literal((String)"I need more food."), Component.literal((String)"Is that all you got?"), Component.literal((String)"I'm still hungry."), Component.literal((String)"Can I have some more?"), Component.literal((String)"I'm going to need a bit more."), Component.literal((String)"That's not enough."), Component.literal((String)"You call that a meal?"), Component.literal((String)"My stomach didn't even notice that."), Component.literal((String)"Nope. Still hungry."), Component.literal((String)"I'm going to pretend that never happened. Try again."), Component.literal((String)"Nice start. Now add about ten more of those."), Component.literal((String)"I appreciate the effort, not the portion size."), Component.literal((String)"You're going to have to commit harder than that."), Component.literal((String)"That was a snack, not a meal."), Component.literal((String)"I'm going to need a lot more if you want my loyalty."), Component.literal((String)"My hunger bar barely moved.")};
    public static final MutableComponent[] notTamed = new MutableComponent[]{Component.literal((String)"Do you have any food?"), Component.literal((String)"I'm hungry."), Component.literal((String)"Have you seen any food around here?"), Component.literal((String)"I could use some food."), Component.literal((String)"I wish I had some food."), Component.literal((String)"I'm starving."), Component.literal((String)"Got any snacks on you? Asking for a friend. I'm the friend."), Component.literal((String)"We could be best friends... if you had food."), Component.literal((String)"I'll listen when the food starts talking."), Component.literal((String)"You look like someone who carries snacks. Prove me right."), Component.literal((String)"No food, no deal."), Component.literal((String)"We can talk taming after we talk feeding."), Component.literal((String)"Is there a delivery service around here? Preferably you."), Component.literal((String)"I'm interviewing humans. Requirement: must bring food."), Component.literal((String)"If you had food, this conversation would be going better."), Component.literal((String)"Step one: food. Step two: maybe I'll like you.")};
    public static final MutableComponent[] WRONG_FOOD = new MutableComponent[]{Component.literal((String)"That's not what I asked for."), Component.literal((String)"I didn't ask for that."), Component.literal((String)"Looks like you didn't understand my request."), Component.literal((String)"Did you forget what I asked for?"), Component.literal((String)"I don't remember asking for that"), Component.literal((String)"That's\u2026 boldly incorrect."), Component.literal((String)"Are you even listening to me?"), Component.literal((String)"Points for effort, not for accuracy."), Component.literal((String)"Close. But also not close at all."), Component.literal((String)"This is the opposite of what I wanted."), Component.literal((String)"Creative choice. Still wrong, though."), Component.literal((String)"Did your inventory slip or was that on purpose?"), Component.literal((String)"I'm picky, not desperate."), Component.literal((String)"I asked for food, not whatever that is."), Component.literal((String)"Try again, but this time use your memory.")};
    public static final MutableComponent[] ENOUGH_FOOD = new MutableComponent[]{Component.literal((String)"I have enough of that."), Component.literal((String)"I don't want that anymore."), Component.literal((String)"I want something else now."), Component.literal((String)"If I eat one more of those, I'll explode."), Component.literal((String)"Variety would be nice, you know."), Component.literal((String)"I am officially bored of that flavor."), Component.literal((String)"No more of that, please. My taste buds are on strike."), Component.literal((String)"I'm full on that. Emotionally and physically."), Component.literal((String)"Do you have literally anything else?"), Component.literal((String)"Thanks, but I'm good on those for the next century."), Component.literal((String)"My stomach says no. My soul also says no."), Component.literal((String)"I get it, you like that item. I don't anymore."), Component.literal((String)"Try something new. Surprise me\u2014in a good way.")};
    public static final Class<?>[] alertMobs = new Class[]{Blaze.class, EnderMan.class, Endermite.class, Ghast.class, Giant.class, Guardian.class, Hoglin.class, MagmaCube.class, Phantom.class, Shulker.class, Silverfish.class, Slime.class, Spider.class, Vex.class, AbstractSkeleton.class, Zoglin.class, Zombie.class, Raider.class};
    public static final Class<?>[] huntMobs = new Class[]{Chicken.class, Cow.class, MushroomCow.class, Pig.class, Rabbit.class, Sheep.class};
    public static final ResourceLocation[][] skins = new ResourceLocation[][]{{CompanionData.tex("textures/entities/male/medieval-man-hugh.png"), CompanionData.tex("textures/entities/male/alexandros.png"), CompanionData.tex("textures/entities/male/cyrus.png"), CompanionData.tex("textures/entities/male/diokles.png"), CompanionData.tex("textures/entities/male/dion.png"), CompanionData.tex("textures/entities/male/georgios.png"), CompanionData.tex("textures/entities/male/ioannis.png"), CompanionData.tex("textures/entities/male/medieval-peasant-schwaechlich.png"), CompanionData.tex("textures/entities/male/medieval-peasant-without-vest.png"), CompanionData.tex("textures/entities/male/medieval-peasant-with-vest-on.png"), CompanionData.tex("textures/entities/male/panos.png"), CompanionData.tex("textures/entities/male/viking-blue-tunic.png"), CompanionData.tex("textures/entities/male/cronos-jojo.png"), CompanionData.tex("textures/entities/male/medieval-man-alard.png"), CompanionData.tex("textures/entities/male/peasant-ginger.png"), CompanionData.tex("textures/entities/male/townsman-green-tunic.png"), CompanionData.tex("textures/entities/male/polish-farmer.png"), CompanionData.tex("textures/entities/male/peasant.png"), CompanionData.tex("textures/entities/male/rustic-farmer.png"), CompanionData.tex("textures/entities/male/medieval-villager.png")}, {CompanionData.tex("textures/entities/female/a-rogue-i-guess.png"), CompanionData.tex("textures/entities/female/deidre-gramville.png"), CompanionData.tex("textures/entities/female/deidre-gramville2.png"), CompanionData.tex("textures/entities/female/eleora-halle.png"), CompanionData.tex("textures/entities/female/fantastic-blue.png"), CompanionData.tex("textures/entities/female/ftu-emma.png"), CompanionData.tex("textures/entities/female/girl-medieval-peasant.png"), CompanionData.tex("textures/entities/female/medieval-barmaid.png"), CompanionData.tex("textures/entities/female/runaway.png"), CompanionData.tex("textures/entities/female/shannon-flux.png"), CompanionData.tex("textures/entities/female/the-traveller.png"), CompanionData.tex("textures/entities/female/x-ayesha.png")}};
    public static final ResourceLocation[][] maleArmor = new ResourceLocation[][]{{CompanionData.tex("textures/entities/armor/chainmail_arms_layer_2.png"), CompanionData.tex("textures/entities/armor/chainmail_arms_layer_1.png")}, {CompanionData.tex("textures/entities/armor/iron_arms_layer_2.png"), CompanionData.tex("textures/entities/armor/iron_arms_layer_1.png")}, {CompanionData.tex("textures/entities/armor/steel_layer_2.png"), CompanionData.tex("textures/entities/armor/steel_layer_1.png")}};
    public static final ResourceLocation[][] femaleArmor = new ResourceLocation[][]{{CompanionData.tex("textures/entities/armor/chainmail_layer_2.png"), CompanionData.tex("textures/entities/armor/chainmail_layer_1.png")}, {CompanionData.tex("textures/entities/armor/iron_layer_2.png"), CompanionData.tex("textures/entities/armor/iron_layer_1.png")}, {CompanionData.tex("textures/entities/armor/steel_layer_2.png"), CompanionData.tex("textures/entities/armor/steel_layer_1.png")}};
    public static final String[][] firstNames = new String[][]{{"Aaron", "Abel", "Abraham", "Adam", "Adrian", "Aidan", "Aiden", "Albert", "Alfred", "Andrew", "Anthony", "Arthur", "Asher", "Austin", "Barrett", "Barry", "Beau", "Benjamin", "Blake", "Bobby", "Brad", "Bradley", "Brandon", "Brent", "Brett", "Brian", "Brody", "Bryan", "Caleb", "Calvin", "Cameron", "Carl", "Carlos", "Casey", "Carter", "Cedric", "Chad", "Charles", "Charlie", "Christian", "Christopher", "Clark", "Clayton", "Clifford", "Cody", "Colby", "Cole", "Colin", "Collin", "Connor", "Conrad", "Corey", "Craig", "Damian", "Damien", "Damon", "Daniel", "Darren", "Darryl", "David", "Dean", "Declan", "Dennis", "Derek", "Derrick", "Desmond", "Devin", "Diego", "Dominic", "Donald", "Donovan", "Douglas", "Drew", "Dustin", "Dylan", "Edward", "Edwin", "Eli", "Elias", "Elijah", "Elliot", "Elliott", "Ethan", "Eugene", "Evan", "Everett", "Felix", "Fernando", "Finley", "Finn", "Francis", "Francisco", "Frank", "Franklin", "Gabriel", "Gage", "Gareth", "Gavin", "George", "Gerald", "Gilbert", "Glen", "Glenn", "Gordon", "Graham", "Grant", "Grayson", "Greg", "Gregory", "Harley", "Harold", "Harrison", "Harry", "Harvey", "Hayden", "Heath", "Hector", "Henry", "Hudson", "Hugh", "Hugo", "Hunter", "Ian", "Isaac", "Isaiah", "Israel", "Jack", "Jackson", "Jacob", "Jaden", "Jake", "James", "Jamie", "Jared", "Jason", "Jasper", "Javier", "Jeff", "Jeffrey", "Jeremiah", "Jeremy", "Jerome", "Jesse", "Jesus", "Joel", "John", "Johnny", "Jonah", "Jonathan", "Jordan", "Jorge", "Jose", "Joseph", "Joshua", "Josiah", "Juan", "Jude", "Julian", "Julio", "Justin", "Kaden", "Kai", "Kaleb", "Karl", "Kayden", "Keith", "Kelvin", "Kenneth", "Kevin", "Kieran", "Kyle", "Landon", "Larry", "Lawrence", "Lee", "Leo", "Leon", "Leonard", "Leroy", "Liam", "Logan", "Lonnie", "Louis", "Luca", "Lucas", "Luis", "Luke", "Malcolm", "Manuel", "Marcus", "Mario", "Mark", "Marshall", "Martin", "Mason", "Mateo", "Matthew", "Maurice", "Max", "Maximilian", "Maxwell", "Micah", "Michael", "Miguel", "Miles", "Mitchell", "Morgan", "Nate", "Nathan", "Nathaniel", "Neil", "Nelson", "Nicholas", "Nico", "Nolan", "Noah", "Norman", "Oliver", "Omar", "Oscar", "Owen", "Parker", "Patrick", "Paul", "Peter", "Philip", "Phillip", "Preston", "Quentin", "Quinn", "Rafael", "Ralph", "Ramon", "Randall", "Randy", "Raphael", "Ray", "Raymond", "Reece", "Reed", "Reid", "Rhys", "Ricardo", "Richard", "Rick", "Ricky", "Riley", "Roberto", "Robert", "Rodney", "Roger", "Roland", "Roman", "Ronald", "Ronnie", "Ross", "Roy", "Russell", "Ryan", "Samuel", "Scott", "Sean", "Sebastian", "Sergio", "Seth", "Shane", "Shaun", "Shawn", "Silas", "Simon", "Spencer", "Stanley", "Stephen", "Steven", "Stuart", "Terrence", "Theodore", "Thomas", "Timothy", "Todd", "Tom", "Travis", "Trevor", "Tristan", "Troy", "Tyler", "Tyrone", "Victor", "Vincent", "Warren", "Wayne", "Wesley", "Weston", "Wilfred", "Will", "William", "Wyatt", "Xavier", "Zach", "Zachariah", "Zachary"}, {"Abigail", "Ada", "Adelaide", "Adeline", "Aimee", "Alexa", "Alexandra", "Alexis", "Alice", "Alicia", "Alison", "Allison", "Alyssa", "Amelia", "Amelie", "Amy", "Anastasia", "Andrea", "Angela", "Angelica", "Angelina", "Anna", "Annabelle", "Anne", "Annie", "April", "Ariana", "Arianna", "Aria", "Ashley", "Aubrey", "Audrey", "Autumn", "Ava", "Bailey", "Barbara", "Beatrice", "Belinda", "Bella", "Beth", "Bethany", "Bianca", "Brenda", "Brianna", "Bridget", "Britney", "Brooke", "Caitlin", "Camila", "Camille", "Candice", "Cara", "Carla", "Carlie", "Carmen", "Caroline", "Carolyn", "Cassandra", "Catherine", "Cathy", "Cecilia", "Celeste", "Chanel", "Charlotte", "Chelsea", "Chloe", "Christina", "Christine", "Claire", "Clara", "Clarissa", "Courtney", "Crystal", "Cynthia", "Daisy", "Dakota", "Daniella", "Danielle", "Darlene", "Dawn", "Deborah", "Debra", "Delilah", "Diana", "Diane", "Donna", "Dorothy", "Eden", "Edith", "Eileen", "Eleanor", "Elena", "Eliana", "Elinor", "Elisa", "Elise", "Eliza", "Elizabeth", "Ella", "Ellen", "Ellie", "Eloise", "Elsa", "Emily", "Emma", "Erica", "Erin", "Esme", "Estelle", "Esther", "Eva", "Evelyn", "Faith", "Faye", "Felicity", "Fern", "Fiona", "Florence", "Frances", "Francesca", "Freya", "Gabriela", "Gabriella", "Gail", "Georgia", "Georgina", "Gillian", "Gloria", "Grace", "Gwen", "Gwendolyn", "Hailey", "Hannah", "Harper", "Hazel", "Heather", "Heidi", "Helen", "Helena", "Holly", "Hope", "Imogen", "Ingrid", "Irene", "Iris", "Isabel", "Isabella", "Isla", "Ivy", "Jacqueline", "Jade", "Jamie", "Jane", "Janet", "Janice", "Jasmine", "Jean", "Jenna", "Jennifer", "Jessica", "Jillian", "Joan", "Joanna", "Jodie", "Jordan", "Josephine", "Josie", "Joy", "Judith", "Judy", "Julia", "Juliana", "Julie", "Juliet", "June", "Justine", "Karen", "Katherine", "Kathleen", "Katrina", "Kayla", "Keira", "Kelly", "Kelsey", "Kimberly", "Kirsten", "Kristen", "Kristin", "Lacey", "Lana", "Lara", "Laura", "Lauren", "Leah", "Leanne", "Lena", "Lesley", "Lila", "Lillian", "Lily", "Linda", "Lindsey", "Lisa", "Lola", "Loretta", "Lottie", "Louisa", "Louise", "Lucia", "Lucille", "Lucy", "Luna", "Lydia", "Mackenzie", "Macy", "Madeline", "Madison", "Mae", "Maeve", "Maggie", "Maisie", "Mandy", "Margaret", "Margot", "Maria", "Mariah", "Mariam", "Marian", "Marilyn", "Marina", "Martha", "Mary", "Matilda", "Maya", "Megan", "Melanie", "Melissa", "Mia", "Michelle", "Mila", "Molly", "Monica", "Morgan", "Naomi", "Natalia", "Natalie", "Natasha", "Niamh", "Nicole", "Nicola", "Nina", "Noelle", "Nora", "Norah", "Olivia", "Paige", "Pamela", "Patricia", "Paula", "Penelope", "Phoebe", "Poppy", "Priscilla", "Rachel", "Rebecca", "Reese", "Riley", "Rita", "Robyn", "Rosa", "Rosalie", "Rose", "Rosie", "Ruby", "Ruth", "Sabrina", "Samantha", "Sandra", "Sara", "Sarah", "Savannah", "Scarlett", "Selena", "Serena", "Shannon", "Sharon", "Sheila", "Shelby", "Sienna", "Sierra", "Simone", "Sofia", "Sophia", "Sophie", "Stacey", "Stella", "Stephanie", "Summer", "Susan", "Suzanne", "Sydney", "Tara", "Tessa", "Theresa", "Tiffany", "Tracy", "Trinity", "Valentina", "Valerie", "Vanessa", "Vera", "Veronica", "Victoria", "Violet", "Vivian", "Wendy", "Whitney", "Willow", "Yasmin", "Yvonne", "Zara", "Zoe", "Zoey"}};
    public static final String[] lastNames = new String[]{"Adams", "Ainsworth", "Alexander", "Allen", "Anderson", "Andrews", "Armstrong", "Arnold", "Atkins", "Atkinson", "Austin", "Bailey", "Baker", "Ball", "Banks", "Barber", "Barker", "Barnes", "Barnett", "Barrett", "Barry", "Bates", "Baxter", "Beck", "Bell", "Bennett", "Benson", "Bentley", "Berry", "Black", "Blake", "Booth", "Bowen", "Boyd", "Bradley", "Brady", "Brewer", "Bridges", "Briggs", "Brooks", "Brown", "Bryant", "Buckley", "Bullock", "Burke", "Burnett", "Burns", "Burton", "Bush", "Butler", "Byrne", "Campbell", "Carlson", "Carpenter", "Carr", "Carroll", "Carter", "Casey", "Chambers", "Chapman", "Chandler", "Christensen", "Clark", "Clarke", "Clayton", "Cobb", "Cohen", "Cole", "Coleman", "Collins", "Conner", "Cook", "Cooper", "Curtis", "Cox", "Craig", "Crawford", "Cross", "Cruz", "Cunningham", "Curtis", "Dalton", "Daniel", "Daniels", "Davidson", "Davis", "Dawson", "Day", "Dean", "Delaney", "Dennis", "Dixon", "Douglas", "Doyle", "Duncan", "Dunn", "Edwards", "Elliott", "Ellis", "Erickson", "Eriksen", "Evans", "Farrell", "Ferguson", "Fernandez", "Fisher", "Fitzgerald", "Fleming", "Fletcher", "Flores", "Ford", "Foster", "Fowler", "Fox", "Francis", "Franklin", "Freeman", "Gallagher", "Gardner", "Garner", "Garcia", "Garrison", "George", "Gibbs", "Gibson", "Gilbert", "Gill", "Glover", "Gonzalez", "Goodman", "Gordon", "Graham", "Grant", "Graves", "Gray", "Green", "Greene", "Gregory", "Griffin", "Griffiths", "Hall", "Hamilton", "Hansen", "Hanson", "Harper", "Harris", "Harrison", "Hart", "Harvey", "Hawkins", "Hayes", "Haynes", "Henderson", "Henry", "Hernandez", "Hicks", "Hill", "Hines", "Hodges", "Hoffman", "Holland", "Holmes", "Holt", "Hopkins", "Horton", "Howard", "Howe", "Hudson", "Hughes", "Hunt", "Hunter", "Ingram", "Jackson", "Jacobs", "James", "Jarvis", "Jenkins", "Jennings", "Jensen", "Johnson", "Johnston", "Jones", "Jordan", "Kane", "Keller", "Kelley", "Kelly", "Kennedy", "Khan", "King", "Kirk", "Klein", "Knight", "Lambert", "Lane", "Lang", "Lawrence", "Lawson", "Leach", "Lee", "Lewis", "Little", "Lloyd", "Logan", "Long", "Lopez", "Lowe", "Lucas", "Lynch", "Lyons", "MacDonald", "Madden", "Manning", "Marks", "Marsh", "Marshall", "Martin", "Martinez", "Mason", "Matthews", "Maxwell", "May", "McBride", "McCarthy", "McCormick", "McDonald", "McGee", "McGrath", "McGregor", "McKenzie", "McLean", "McMillan", "Medina", "Mendez", "Meyer", "Miller", "Mills", "Mitchell", "Moody", "Moore", "Morales", "Morgan", "Morris", "Morrison", "Morton", "Moss", "Murphy", "Murray", "Myers", "Nelson", "Newman", "Newton", "Nichols", "Nicholson", "Nixon", "Nolan", "Norman", "Norris", "O'Brien", "O'Connor", "O'Neill", "Oliver", "Olson", "Ortiz", "Owens", " Page", "Palmer", "Parker", "Patel", "Patrick", "Patterson", "Payne", "Pearce", "Pearson", "Pena", "Perez", "Perkins", "Perry", "Peters", "Peterson", "Phillips", "Pierce", "Poole", "Porter", "Potter", "Powell", "Powers", "Price", "Quinn", "Ramirez", "Ramos", "Randall", "Ray", "Reed", "Rees", "Reese", "Reid", "Reyes", "Reynolds", "Rhodes", "Rice", "Richards", "Richardson", "Riley", "Rivers", "Robbins", "Roberts", "Robertson", "Robinson", "Rodgers", "Rodriguez", "Rogers", "Rose", "Ross", "Rowe", "Ruiz", "Russell", "Ryan", "Salazar", "Sanders", "Sanderson", "Sandoval", "Santiago", "Saunders", "Schmidt", "Scott", "Sharp", "Shaw", "Sheffield", "Shelton", "Short", "Silva", "Simmons", "Simpson", "Singh", "Sloan", "Smith", "Snyder", "Spencer", "Stanley", "Stephens", "Stevens", "Stewart", "Stone", "Sullivan", "Summers", "Sutton", "Taylor", "Terry", "Thomas", "Thompson", "Thornton", "Todd", "Torres", "Townsend", "Tran", "Tucker", "Turner", "Tyler", "Vasquez", "Vaughn", "Vazquez", "Wade", "Wagner", "Walker", "Wallace", "Walsh", "Walters", "Ward", "Warren", "Washington", "Waters", "Watkins", "Watson", "Watts", "Weaver", "Webb", "Weber", "Welch", "Wells", "West", "Wheeler", "White", "Whitaker", "Whitehead", "Whitfield", "Williams", "Williamson", "Willis", "Wilson", "Wise", "Wolfe", "Wong", "Wood", "Woods", "Wright", "Wyatt", "Young", "Zimmerman"};

    public static int getHealthModifier() {
        float healthFloat = rand.nextFloat();
        if ((double)healthFloat <= 0.03) {
            return -4;
        }
        if ((double)healthFloat <= 0.1) {
            return -3;
        }
        if ((double)healthFloat <= 0.2) {
            return -2;
        }
        if ((double)healthFloat <= 0.35) {
            return -1;
        }
        if ((double)healthFloat <= 0.65) {
            return 0;
        }
        if ((double)healthFloat <= 0.8) {
            return 1;
        }
        if ((double)healthFloat <= 0.9) {
            return 2;
        }
        if ((double)healthFloat <= 0.97) {
            return 3;
        }
        return 4;
    }

    public static ItemStack getSpawnArmor(EquipmentSlot armorType) {
        float materialFloat = rand.nextFloat();
        if (materialFloat <= 0.4f) {
            return ItemStack.EMPTY;
        }
        if (materialFloat <= 0.7f) {
            return switch (armorType) {
                case EquipmentSlot.HEAD -> Items.LEATHER_HELMET.getDefaultInstance();
                case EquipmentSlot.CHEST -> Items.LEATHER_CHESTPLATE.getDefaultInstance();
                case EquipmentSlot.LEGS -> Items.LEATHER_LEGGINGS.getDefaultInstance();
                case EquipmentSlot.FEET -> Items.LEATHER_BOOTS.getDefaultInstance();
                default -> ItemStack.EMPTY;
            };
        }
        if (materialFloat <= 0.9f) {
            return switch (armorType) {
                case EquipmentSlot.HEAD -> Items.CHAINMAIL_HELMET.getDefaultInstance();
                case EquipmentSlot.CHEST -> Items.CHAINMAIL_CHESTPLATE.getDefaultInstance();
                case EquipmentSlot.LEGS -> Items.CHAINMAIL_LEGGINGS.getDefaultInstance();
                case EquipmentSlot.FEET -> Items.CHAINMAIL_BOOTS.getDefaultInstance();
                default -> ItemStack.EMPTY;
            };
        }
        return switch (armorType) {
            case EquipmentSlot.HEAD -> Items.IRON_HELMET.getDefaultInstance();
            case EquipmentSlot.CHEST -> Items.IRON_CHESTPLATE.getDefaultInstance();
            case EquipmentSlot.LEGS -> Items.IRON_LEGGINGS.getDefaultInstance();
            case EquipmentSlot.FEET -> Items.IRON_BOOTS.getDefaultInstance();
            default -> ItemStack.EMPTY;
        };
    }

    public static String getRandomName(int sex) {
        String firstName = firstNames[sex][rand.nextInt(firstNames[sex].length)];
        String lastName = lastNames[rand.nextInt(lastNames.length)];
        return firstName + " " + lastName;
    }

    public static boolean isArmorSlot(EquipmentSlot slot) {
        return slot == EquipmentSlot.HEAD || slot == EquipmentSlot.CHEST || slot == EquipmentSlot.LEGS || slot == EquipmentSlot.FEET;
    }

    public static boolean isArmorSlot(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)item;
            return CompanionData.isArmorSlot(armor.getEquipmentSlot());
        }
        return false;
    }

    public static boolean isBetterArmor(ItemStack candidate, ItemStack current) {
        ArmorItem candArmor;
        Item item;
        block6: {
            block5: {
                item = candidate.getItem();
                if (!(item instanceof ArmorItem)) break block5;
                candArmor = (ArmorItem)item;
                item = current.getItem();
                if (item instanceof ArmorItem) break block6;
            }
            return current.isEmpty();
        }
        ArmorItem curArmor = (ArmorItem)item;
        if (candArmor.getEquipmentSlot() != curArmor.getEquipmentSlot()) {
            return current.isEmpty();
        }
        if (candArmor.getMaterial() == ArmorMaterials.NETHERITE && curArmor.getMaterial() != ArmorMaterials.NETHERITE) {
            return true;
        }
        return candArmor.getDefense() > curArmor.getDefense();
    }

    public static Map<Item, Integer> getRandomFoodRequirement(Random random) {
        HashMap<Item, Integer> food = new HashMap<Item, Integer>();
        Item foodItem = CompanionData.pickAllowedFood(random);
        Item resourceItem = CompanionData.pickResource(random);
        food.put(foodItem, random.nextInt(4) + 2);
        food.put(resourceItem, random.nextInt(5) + 2);
        return food;
    }

    public static boolean isFood(ItemStack stack) {
        Item item = stack.getItem();
        if (DISALLOWED_FOODS.contains(item)) {
            return false;
        }
        for (Item food : ALL_FOODS) {
            if (!food.equals(item)) continue;
            return true;
        }
        for (Item bonus : EXTRA_HEAL_CONSUMABLES) {
            if (!bonus.equals(item)) continue;
            return true;
        }
        return CompanionData.isHealingPotion(stack);
    }

    public static boolean isHealingPotion(ItemStack stack) {
        if (!(stack.getItem() instanceof PotionItem)) {
            return false;
        }
        PotionContents contents = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        boolean hasHealingEffect = false;
        for (MobEffectInstance effect : contents.getAllEffects()) {
            if (((MobEffect)effect.getEffect().value()).getCategory() == MobEffectCategory.HARMFUL) {
                return false;
            }
            if (!effect.getEffect().is(MobEffects.HEAL) && !effect.getEffect().is(MobEffects.REGENERATION)) continue;
            hasHealingEffect = true;
        }
        return hasHealingEffect;
    }

    private static Item pickAllowedFood(Random random) {
        Item candidate;
        while (DISALLOWED_FOODS.contains(candidate = ALL_FOODS[random.nextInt(ALL_FOODS.length)])) {
        }
        return candidate;
    }

    private static Item pickResource(Random random) {
        return RESOURCE_ITEMS[random.nextInt(RESOURCE_ITEMS.length)];
    }

    private static ResourceLocation tex(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"modern_companions", (String)path);
    }
}

