/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.entity;

import com.majorbonghits.moderncompanions.core.ModConfig;
import com.majorbonghits.moderncompanions.entity.AbstractHumanCompanionEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

@EventBusSubscriber(modid="modern_companions")
public final class CompanionEvents {
    private CompanionEvents() {
    }

    @SubscribeEvent
    public static void giveExperience(LivingDeathEvent event) {
        Entity entity = event.getSource().getEntity();
        if (entity instanceof AbstractHumanCompanionEntity) {
            AbstractHumanCompanionEntity companion = (AbstractHumanCompanionEntity)entity;
            entity = event.getEntity().level();
            if (entity instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)entity;
                companion.incrementKillCount();
                companion.giveExperiencePoints(event.getEntity().getExperienceReward(serverLevel, (Entity)companion));
            }
        }
    }

    @SubscribeEvent
    public static void friendlyFire(LivingIncomingDamageEvent event) {
        LivingEntity livingEntity;
        Projectile proj;
        Entity entity;
        DamageSource source = event.getSource();
        Entity direct = source.getDirectEntity();
        Entity attacker = source.getEntity();
        AbstractHumanCompanionEntity companion = null;
        if (attacker instanceof AbstractHumanCompanionEntity) {
            AbstractHumanCompanionEntity comp;
            companion = comp = (AbstractHumanCompanionEntity)attacker;
        } else if (direct instanceof Projectile && (entity = (proj = (Projectile)direct).getOwner()) instanceof AbstractHumanCompanionEntity) {
            AbstractHumanCompanionEntity comp;
            companion = comp = (AbstractHumanCompanionEntity)entity;
        }
        if (companion == null || !companion.isTame()) {
            return;
        }
        if (!((Boolean)ModConfig.safeGet(ModConfig.FRIENDLY_FIRE_PLAYER)).booleanValue() && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (companion.getOwner() == player) {
                event.setCanceled(true);
                return;
            }
        }
        if (!((Boolean)ModConfig.safeGet(ModConfig.FRIENDLY_FIRE_COMPANIONS)).booleanValue()) {
            AbstractHumanCompanionEntity otherComp;
            TamableAnimal other;
            livingEntity = event.getEntity();
            if (livingEntity instanceof TamableAnimal && (other = (TamableAnimal)livingEntity).isTame() && other.getOwner() == companion.getOwner()) {
                event.setCanceled(true);
                return;
            }
            livingEntity = event.getEntity();
            if (livingEntity instanceof AbstractHumanCompanionEntity && (otherComp = (AbstractHumanCompanionEntity)livingEntity).getOwner() == companion.getOwner()) {
                event.setCanceled(true);
            }
        }
    }
}

