/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.entity;

import com.majorbonghits.moderncompanions.Constants;
import com.majorbonghits.moderncompanions.core.ModConfig;
import com.majorbonghits.moderncompanions.entity.magic.AbstractMageCompanion;
import com.majorbonghits.moderncompanions.entity.projectile.NonExplodingLargeFireball;
import com.majorbonghits.moderncompanions.entity.projectile.NonIgnitingSmallFireball;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FireMage
extends AbstractMageCompanion {
    private static final int HEAVY_COOLDOWN_TICKS = 560;

    public FireMage(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        if (this.isOwnerInDanger(target, 2.5f)) {
            return;
        }
        Vec3 dir = new Vec3(target.getX() - this.getX(), target.getY(0.5) - this.getEyeY(), target.getZ() - this.getZ()).normalize();
        if (dir.lengthSqr() < 1.0E-6) {
            return;
        }
        NonIgnitingSmallFireball fireball = new NonIgnitingSmallFireball((Level)server, (LivingEntity)this, dir);
        fireball.setPos(this.getX(), this.getEyeY() - (double)0.2f, this.getZ());
        fireball.shoot(dir.x, dir.y, dir.z, 1.15f, 0.0f);
        fireball.setOwner((Entity)this);
        server.addFreshEntity((Entity)fireball);
        this.swingCast();
    }

    @Override
    public boolean tryHeavyAttack(LivingEntity target, float distanceFactor) {
        if (this.heavyCooldown > 0) {
            return false;
        }
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel server = (ServerLevel)level;
        if (this.isOwnerInDanger(target, 4.0f)) {
            return false;
        }
        if (this.random.nextBoolean()) {
            return false;
        }
        Vec3 dir = new Vec3(target.getX() - this.getX(), target.getY((double)0.35f) - this.getEyeY(), target.getZ() - this.getZ()).normalize();
        NonExplodingLargeFireball fireball = new NonExplodingLargeFireball((Level)server, (LivingEntity)this, dir.scale(0.9), 1);
        fireball.setPos(this.getX(), this.getEyeY() - (double)0.1f, this.getZ());
        fireball.shoot(dir.x, dir.y, dir.z, 1.1f, 0.0f);
        fireball.setOwner((Entity)this);
        server.addFreshEntity((Entity)fireball);
        this.heavyCooldown = 560;
        this.swingCast();
        return true;
    }

    @Override
    public int getLightIntervalTicks() {
        return 32;
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData data) {
        if (((Boolean)ModConfig.safeGet(ModConfig.SPAWN_WEAPON)).booleanValue()) {
            this.inventory.setItem(4, Items.BLAZE_ROD.getDefaultInstance());
            this.inventory.setItem(5, new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(Constants.id("wooden_quarterstaff"))));
            this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        }
        return super.finalizeSpawn(level, difficulty, reason, data);
    }

    @Override
    public int getHeavyRecoveryTicks() {
        return 560;
    }
}

