/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.entity;

import com.majorbonghits.moderncompanions.core.ModConfig;
import com.majorbonghits.moderncompanions.core.TagsInit;
import com.majorbonghits.moderncompanions.entity.AbstractHumanCompanionEntity;
import com.majorbonghits.moderncompanions.item.ClubItem;
import com.majorbonghits.moderncompanions.item.DaggerItem;
import com.majorbonghits.moderncompanions.item.GlaiveItem;
import com.majorbonghits.moderncompanions.item.HammerItem;
import com.majorbonghits.moderncompanions.item.QuarterstaffItem;
import com.majorbonghits.moderncompanions.item.SpearItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class Knight
extends AbstractHumanCompanionEntity {
    public Knight(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
    }

    private boolean isPreferredWeapon(ItemStack stack) {
        return stack.getItem() instanceof SwordItem || stack.getItem() instanceof DaggerItem || stack.getItem() instanceof ClubItem || stack.getItem() instanceof SpearItem || stack.getItem() instanceof GlaiveItem || stack.getItem() instanceof QuarterstaffItem || stack.getItem() instanceof HammerItem || stack.is(TagsInit.Items.SWORDS);
    }

    public void checkSword() {
        ItemStack hand = this.getItemBySlot(EquipmentSlot.MAINHAND);
        if (!(hand.isEmpty() || this.isPreferredWeapon(hand) && this.inventoryContains(hand.getItem()))) {
            this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
            hand = ItemStack.EMPTY;
        }
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack itemstack = this.inventory.getItem(i);
            if (!this.isPreferredWeapon(itemstack) || !hand.isEmpty()) continue;
            this.setItemSlot(EquipmentSlot.MAINHAND, itemstack);
            hand = itemstack;
        }
    }

    private boolean inventoryContains(Item item) {
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            if (this.inventory.getItem(i).getItem() != item) continue;
            return true;
        }
        return false;
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        this.checkSword();
    }

    @Override
    public void tick() {
        if (!this.level().isClientSide()) {
            this.checkSword();
        }
        super.tick();
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData data) {
        ItemStack itemstack;
        if (((Boolean)ModConfig.safeGet(ModConfig.SPAWN_WEAPON)).booleanValue() && !(itemstack = this.getSpawnSword()).isEmpty()) {
            this.inventory.setItem(4, itemstack);
            this.checkSword();
        }
        return super.finalizeSpawn(level, difficulty, reason, data);
    }

    public ItemStack getSpawnSword() {
        float materialFloat = this.random.nextFloat();
        if (materialFloat < 0.5f) {
            return Items.WOODEN_SWORD.getDefaultInstance();
        }
        if (materialFloat < 0.9f) {
            return Items.STONE_SWORD.getDefaultInstance();
        }
        return Items.IRON_SWORD.getDefaultInstance();
    }
}

