/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.entity;

import com.majorbonghits.moderncompanions.Constants;
import com.majorbonghits.moderncompanions.core.ModConfig;
import com.majorbonghits.moderncompanions.entity.magic.AbstractMageCompanion;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class LightningMage
extends AbstractMageCompanion {
    private static final int HEAVY_COOLDOWN_TICKS = 150;

    public LightningMage(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        if (this.isAlliedTo((Entity)target) || this.getOwner() != null && this.getOwner() == target) {
            return;
        }
        if (this.isOwnerInDanger(target, 3.0f)) {
            return;
        }
        LightningBolt bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)server);
        if (bolt == null) {
            return;
        }
        bolt.moveTo(target.getX(), target.getY(), target.getZ());
        bolt.setVisualOnly(true);
        server.addFreshEntity((Entity)bolt);
        target.hurt(server.damageSources().lightningBolt(), this.magicDamage(5.0f));
        this.swingCast();
    }

    @Override
    public boolean tryHeavyAttack(LivingEntity target, float distanceFactor) {
        if (this.heavyCooldown > 0) {
            return false;
        }
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel server = (ServerLevel)level;
        List hostiles = server.getEntitiesOfClass(LivingEntity.class, target.getBoundingBox().inflate(5.0), other -> other != this && other != target && !this.isAlliedTo((Entity)other) && other.isAlive());
        if (hostiles.size() < 1) {
            return false;
        }
        hostiles.add(0, target);
        int boltsCast = 0;
        for (LivingEntity victim : hostiles) {
            LightningBolt bolt;
            if (victim == null || !victim.isAlive() || this.isAlliedTo((Entity)victim) || this.getOwner() != null && this.getOwner() == victim || this.isOwnerInDanger(victim, 3.0f) || (bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)server)) == null) continue;
            bolt.moveTo(victim.getX(), victim.getY(), victim.getZ());
            bolt.setVisualOnly(true);
            server.addFreshEntity((Entity)bolt);
            float bonus = server.isThundering() ? 2.0f : 0.0f;
            victim.hurt(server.damageSources().lightningBolt(), this.magicDamage(6.0f + bonus));
            if (++boltsCast < 4) continue;
            break;
        }
        if (boltsCast == 0) {
            return false;
        }
        this.heavyCooldown = 150;
        this.swingCast();
        return true;
    }

    @Override
    public int getLightIntervalTicks() {
        return 26;
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData data) {
        if (((Boolean)ModConfig.safeGet(ModConfig.SPAWN_WEAPON)).booleanValue()) {
            this.inventory.setItem(4, Items.STICK.getDefaultInstance());
            this.inventory.setItem(5, new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(Constants.id("iron_dagger"))));
            this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        }
        return super.finalizeSpawn(level, difficulty, reason, data);
    }

    @Override
    public int getHeavyRecoveryTicks() {
        return 150;
    }
}

