/*
 * Decompiled with CFR 0.152.
 */
package com.majorbonghits.moderncompanions.entity;

import com.majorbonghits.moderncompanions.Constants;
import com.majorbonghits.moderncompanions.core.ModConfig;
import com.majorbonghits.moderncompanions.core.ModEntityTypes;
import com.majorbonghits.moderncompanions.entity.SummonedWitherSkeleton;
import com.majorbonghits.moderncompanions.entity.magic.AbstractMageCompanion;
import com.majorbonghits.moderncompanions.entity.projectile.SoftWitherSkull;
import java.util.List;
import java.util.Random;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Necromancer
extends AbstractMageCompanion {
    private static final int HEAVY_COOLDOWN_TICKS = 180;
    private final Random rng = new Random();

    public Necromancer(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        if (this.isAlliedTo((Entity)target)) {
            return;
        }
        if (this.isOwnerInDanger(target, 3.0f)) {
            return;
        }
        Vec3 dir = target.position().add(0.0, (double)Math.min(0.1f, target.getBbHeight() * 0.08f), 0.0).subtract(this.position()).normalize().scale(0.55);
        SoftWitherSkull skull = (SoftWitherSkull)((EntityType)ModEntityTypes.SOFT_WITHER_SKULL.get()).create((Level)server);
        if (skull == null) {
            return;
        }
        skull.setNoGravity(true);
        skull.shoot(dir.x, dir.y, dir.z, 1.25f, 0.0f);
        skull.setPos(this.getX(), this.getY() + (double)1.1f, this.getZ());
        skull.setOwner((Entity)this);
        server.addFreshEntity((Entity)skull);
        this.swingCast();
    }

    @Override
    public boolean tryHeavyAttack(LivingEntity target, float distanceFactor) {
        if (this.heavyCooldown > 0) {
            return false;
        }
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel server = (ServerLevel)level;
        List owned = server.getEntitiesOfClass(SummonedWitherSkeleton.class, this.getBoundingBox().inflate(128.0, 64.0, 128.0), skel -> skel.getSummoner() == this && skel.isAlive());
        if (!owned.isEmpty()) {
            return false;
        }
        int toSummon = 1 + this.rng.nextInt(3);
        int spawned = 0;
        int lifetimeSeconds = 60 + this.rng.nextInt(121);
        for (int i = 0; i < toSummon; ++i) {
            SummonedWitherSkeleton skeleton = (SummonedWitherSkeleton)((EntityType)ModEntityTypes.SUMMONED_WITHER_SKELETON.get()).create((Level)server);
            if (skeleton == null) continue;
            double offsetX = (this.rng.nextDouble() - 0.5) * 2.5;
            double offsetZ = (this.rng.nextDouble() - 0.5) * 2.5;
            skeleton.moveTo(this.getX() + offsetX, this.getY(), this.getZ() + offsetZ, this.getYRot(), 0.0f);
            skeleton.configureSummon((LivingEntity)this, lifetimeSeconds);
            if (!skeleton.isFriendlyTo((Entity)target)) {
                skeleton.setTarget(target);
            }
            server.addFreshEntity((Entity)skeleton);
            ++spawned;
        }
        if (spawned == 0) {
            return false;
        }
        this.heavyCooldown = 180;
        this.swingCast();
        return true;
    }

    @Override
    public int getLightIntervalTicks() {
        return 20;
    }

    @Override
    public float getPreferredRange() {
        return 20.0f;
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData data) {
        if (((Boolean)ModConfig.safeGet(ModConfig.SPAWN_WEAPON)).booleanValue()) {
            this.inventory.setItem(4, new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(Constants.id("stone_dagger"))));
            this.inventory.setItem(5, Items.BONE.getDefaultInstance());
            this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        }
        return super.finalizeSpawn(level, difficulty, reason, data);
    }

    @Override
    public int getHeavyRecoveryTicks() {
        return 180;
    }

    @Override
    public boolean isAlliedTo(Entity other) {
        SummonedWitherSkeleton summoned;
        if (other instanceof SummonedWitherSkeleton && (summoned = (SummonedWitherSkeleton)other).getSummoner() == this) {
            return true;
        }
        return super.isAlliedTo(other);
    }
}

